/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ItemStorageUtils {
    private Logger logger = LoggerFactory.getLogger(ItemStorageUtils.class);
    @Resource
    private ICacheService cacheService;

    public boolean addItemStorage(Long shopId, Long skuId, Long num) {
        boolean result = true;
        String cacheKey = this.getCacheKey(shopId);
        Long resultNum = this.cacheService.hincrBy(cacheKey, String.valueOf(skuId), num);
        if (resultNum == null || resultNum == 0L) {
            result = false;
        }
        this.logger.info("redis\u5546\u54c1\u5e93\u5b58\u65b0\u589ecacheKey:{},skuId:{},addNum:{},totalNum:{},result:{}", new Object[]{cacheKey, skuId, num, resultNum, result});
        return result;
    }

    public boolean addItemStorage(Date inventoryEffectiveDate, Long shopId, Long skuId, Long num) {
        if (inventoryEffectiveDate == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(inventoryEffectiveDate);
        boolean result = true;
        String cacheKey = this.getCacheKey(shopId);
        Long resultNum = this.cacheService.hincrBy(cacheKey, String.valueOf(skuId + "_" + date), num);
        if (resultNum == null || resultNum == 0L) {
            result = false;
        }
        this.logger.info("redis\u5546\u54c1\u5e93\u5b58\u65b0\u589ecacheKey:{},skuId:{},inventoryEffectiveDate:{},addNum:{},totalNum:{},result:{}", new Object[]{cacheKey, skuId, date, num, resultNum, result});
        return result;
    }

    public boolean addItemStorage(String inventoryEffectiveDate, Long shopId, Long skuId, Long num) {
        boolean result = true;
        String cacheKey = this.getCacheKey(shopId);
        Long resultNum = StringUtils.isBlank((CharSequence)inventoryEffectiveDate) ? this.cacheService.hincrBy(cacheKey, String.valueOf(skuId), num) : this.cacheService.hincrBy(cacheKey, skuId + "_" + inventoryEffectiveDate, num);
        if (resultNum == null || resultNum == 0L) {
            result = false;
        }
        this.logger.info("redis\u5546\u54c1\u5e93\u5b58\u65b0\u589ecacheKey:{},skuId:{},inventoryEffectiveDate:{},addNum:{},totalNum:{},result:{}", new Object[]{cacheKey, skuId, inventoryEffectiveDate, num, resultNum, result});
        return result;
    }

    public boolean subItemStorage(Long shopId, Long skuId, Long num) {
        boolean result = true;
        String cacheKey = this.getCacheKey(shopId);
        Long resultNum = this.cacheService.hincrBy(cacheKey, String.valueOf(skuId), num);
        if (resultNum < 0L) {
            resultNum = this.cacheService.hincrBy(cacheKey, String.valueOf(skuId), Long.valueOf(-num.longValue()));
            result = false;
        }
        this.logger.info("redis\u5546\u54c1\u5e93\u5b58\u6263\u51cfcacheKey:{},skuId:{},subNum:{},totalNum:{},result:{}", new Object[]{cacheKey, skuId, num, resultNum, result});
        return result;
    }

    public boolean subItemStorage(String inventoryEffectiveDate, Long shopId, Long skuId, Long num) {
        boolean result = true;
        String cacheKey = this.getCacheKey(shopId);
        Long resultNum = this.cacheService.hincrBy(cacheKey, String.valueOf(skuId + "_" + inventoryEffectiveDate), num);
        if (resultNum < 0L) {
            resultNum = this.cacheService.hincrBy(cacheKey, String.valueOf(skuId + "_" + inventoryEffectiveDate), Long.valueOf(-num.longValue()));
            result = false;
        }
        this.logger.info("redis\u5546\u54c1\u5e93\u5b58\u6263\u51cfcacheKey:{},skuId:{},subNum:{},totalNum:{},result:{}", new Object[]{cacheKey, skuId, num, resultNum, result});
        return result;
    }

    public boolean delItemStorage(Long shopId, Long skuId) {
        String cacheKey = this.getCacheKey(shopId);
        Map resultMap = this.cacheService.hgetAll(cacheKey);
        String skuIdStr = String.valueOf(skuId);
        boolean result = true;
        for (String key : resultMap.keySet()) {
            if (!key.contains(skuIdStr)) continue;
            String[] var = new String[]{key};
            result = this.cacheService.hdel(cacheKey, var);
            this.logger.info("redis\u5546\u54c1\u5e93\u5b58\u5220\u9664cacheKey:{},skuId:{},key:{},result:{}", new Object[]{cacheKey, skuId, key, result});
        }
        return result;
    }

    public Long queryItemStorage(Long shopId, Long skuId) {
        String cacheKey = this.getCacheKey(shopId);
        Long avaNum = (Long)this.cacheService.hget(cacheKey, String.valueOf(skuId), Long.class);
        if (avaNum == null) {
            avaNum = 0L;
        }
        this.logger.info("redis\u5546\u54c1\u5e93\u5b58\u67e5\u8be2cacheKey:{},skuId:{},avaNum:{}", new Object[]{cacheKey, skuId, avaNum});
        return avaNum;
    }

    public Long queryItemStorage(String inventoryEffectiveDate, Long shopId, Long skuId) {
        String cacheKey = this.getCacheKey(shopId);
        String key = StringUtils.isNotBlank((CharSequence)inventoryEffectiveDate) ? skuId + "_" + inventoryEffectiveDate : String.valueOf(skuId);
        Long avaNum = (Long)this.cacheService.hget(cacheKey, key, Long.class);
        this.logger.info("redis\u5546\u54c1\u5e93\u5b58\u67e5\u8be2cacheKey:{},skuId:{},inventoryEffectiveDate:{},avaNum:{}", new Object[]{cacheKey, skuId, inventoryEffectiveDate, avaNum});
        return avaNum;
    }

    private String getCacheKey(Long shopId) {
        return "shopId_" + shopId;
    }
}

