/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IBrandService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.BrandEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="brandQueryApi")
public class BrandQueryApiImpl
implements IBrandQueryApi {
    @Resource
    private IBrandService brandService;

    public RestResponse<BrandRespDto> queryById(Long id) {
        BrandEo brandEo = this.brandService.selectById(id);
        BrandRespDto brandRespDto = null;
        if (brandEo != null) {
            brandRespDto = new BrandRespDto();
            DtoHelper.eo2Dto((BaseEo)brandEo, (BaseVo)brandRespDto);
        }
        return new RestResponse((Object)brandRespDto);
    }

    public RestResponse<PageInfo<BrandRespDto>> queryByPage(String filters, Integer pageNum, Integer pageSize) {
        TagReqDto.BrandReqDto dto = new TagReqDto.BrandReqDto();
        if (StringUtils.isNotBlank((CharSequence)filters)) {
            dto = (TagReqDto.BrandReqDto)JSON.parseObject((String)filters, TagReqDto.BrandReqDto.class);
        }
        BrandEo brandEo = BrandEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)brandEo);
        QueryParamUtils.fillQueryCreateStartTime(dto.getCreateBeginTime(), (BaseEo)brandEo);
        QueryParamUtils.fillQueryCreateEndTime(dto.getCreateEndTime(), (BaseEo)brandEo);
        QueryParamUtils.fillQueryUpdateStartTime(dto.getUpdateBeginTime(), (BaseEo)brandEo);
        QueryParamUtils.fillQueryUpdateEndTime(dto.getUpdateEndTime(), (BaseEo)brandEo);
        QueryParamUtils.columnLike((BaseEo)brandEo, "code", brandEo.getCode());
        QueryParamUtils.columnLike((BaseEo)brandEo, "name", brandEo.getName());
        if (StringUtils.isBlank((CharSequence)brandEo.getOrderByDesc())) {
            brandEo.setOrderByDesc("create_time");
        }
        PageInfo<BrandEo> brandEoPageInfo = this.brandService.queryBrandByPage(brandEo, pageNum, pageSize);
        ArrayList list = Lists.newArrayList();
        PageInfo pageInfo = new PageInfo((List)list);
        DtoHelper.eoList2DtoList((Collection)brandEoPageInfo.getList(), (Collection)list, BrandRespDto.class);
        CubeBeanUtils.copyProperties((Object)pageInfo, brandEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList((List)list);
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<List<BrandRespDto>> queryByIds(String brandIds) {
        String[] ids;
        ArrayList<Long> brandIdList = new ArrayList<Long>();
        for (String id : ids = brandIds.trim().split(",")) {
            brandIdList.add(Long.parseLong(id));
        }
        return new RestResponse(this.brandService.queryByIds(brandIdList));
    }

    public RestResponse<BrandRespDto> queryCode(String code) {
        return new RestResponse((Object)this.brandService.queryCode(code));
    }
}

