/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemModifyStatusReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOffShelfReqListDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOnShelfReqListDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPublishReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStatReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemTagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.OffItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfModifyShopAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemTagService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.cache.IItemCacheClearService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemTagRelationEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="itemApi")
public class ItemApiImpl
implements IItemApi {
    private Logger logger = LoggerFactory.getLogger(ItemApiImpl.class);
    @Resource
    private IItemService itemService;
    @Resource
    private IItemShelfService itemShelfService;
    @Resource
    private IItemTagService itemTagService;
    @Autowired
    private IItemSkuService itemSkuService;
    @Autowired
    private IShelfService shelfService;
    @Resource
    private List<IItemCacheClearService> itemCacheClearServices;

    public RestResponse<Void> removeItem(String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            this.itemService.removeItem(Long.valueOf(id));
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeItemShelf(@NotNull String ids) {
        this.shelfService.batchRemoveShelf(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> onShelfItem(ItemOnShelfReqListDto itemOnShelfReqListDto) {
        this.logger.info("\u540e\u53f0\u5546\u54c1\u4e0a\u67b6\u64cd\u4f5c\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemOnShelfReqListDto));
        if (null != itemOnShelfReqListDto.getReshelf() && itemOnShelfReqListDto.getReshelf().booleanValue()) {
            this.logger.info("\u91cd\u65b0\u4e0a\u67b6\uff0c\u4e0b\u67b6\u5e76\u5220\u9664\u539f\u4e0a\u67b6\u8bb0\u5f55");
            this.itemShelfService.offAndDrop(itemOnShelfReqListDto.getItemShelfReqDtos());
        }
        this.itemShelfService.onShelfItemList(itemOnShelfReqListDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addItemDir(Long itemId, String dirIds, Long shopId, Long channelId) {
        this.itemShelfService.addItemDir(itemId, dirIds, shopId, channelId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> offShelfItem(String itemIds) {
        if (StringUtils.isEmpty((CharSequence)itemIds)) {
            return RestResponse.VOID;
        }
        String[] ids = itemIds.split(",");
        ArrayList<OffItemReqDto> offItemReqDtos = new ArrayList<OffItemReqDto>();
        for (String itemId : ids) {
            OffItemReqDto offItemReqDto = new OffItemReqDto();
            offItemReqDto.setItemId(Long.valueOf(itemId));
            offItemReqDtos.add(offItemReqDto);
        }
        this.itemShelfService.offShelfItem(offItemReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> offShelfItem(ItemOffShelfReqListDto itemOffShelfReqListDto) {
        this.itemShelfService.offShelfItem(itemOffShelfReqListDto.getOffItemReqDtos());
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteDirItemByIds(String dirItemIds) {
        String[] ids;
        ArrayList<Long> dirItemIdList = new ArrayList<Long>();
        for (String id : ids = dirItemIds.split(",")) {
            dirItemIdList.add(Long.parseLong(id));
        }
        this.itemShelfService.deleteDirItemByIds(dirItemIdList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> publish(ItemPublishReqDto itemPublishReqDto) {
        this.itemService.publish(itemPublishReqDto);
        this.itemCacheClearServices.forEach(cacheClearService -> cacheClearService.clear(itemPublishReqDto.getItemId()));
        return RestResponse.VOID;
    }

    public RestResponse<Void> audit(ItemAuditReqDto itemAuditReqDto) {
        this.itemService.audit(itemAuditReqDto);
        this.itemCacheClearServices.forEach(cacheClearService -> cacheClearService.clear(itemAuditReqDto.getItemId()));
        return RestResponse.VOID;
    }

    public RestResponse<Void> addItemTag(List<ItemTagReqDto> requestItemTags) {
        ArrayList itemTagEos = Lists.newArrayList();
        if (null != requestItemTags) {
            DtoHelper.dtoList2EoList(requestItemTags, (Collection)itemTagEos, ItemTagRelationEo.class);
        }
        this.itemTagService.relateToItem(itemTagEos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeItemTag(@NotNull Long id, @NotNull String tagIds) {
        String[] tagIdList;
        ArrayList<ItemTagRelationEo> itemTagEos = new ArrayList<ItemTagRelationEo>();
        for (String tagId : tagIdList = tagIds.split(",")) {
            ItemTagRelationEo itemTagEo = ItemTagRelationEo.newInstance();
            itemTagEo.setTagId(Long.valueOf(Long.parseLong(tagId)));
            itemTagEo.setItemId(id);
            itemTagEos.add(itemTagEo);
        }
        this.itemTagService.removeRelation(itemTagEos);
        return RestResponse.VOID;
    }

    public RestResponse<List<ItemRespDto>> checkShoppingCartItemInvalid(String itemIds, String filter) {
        String[] ids;
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        for (String id : ids = itemIds.trim().split(",")) {
            itemIdList.add(Long.parseLong(id));
        }
        return new RestResponse(this.itemService.queryItemStatus(itemIdList));
    }

    public RestResponse<Void> modifyShelfTask(List<ShelfTaskUpdateReqDto> shelfTaskUpdateReqDtos) {
        this.itemShelfService.modifyShelfTask(shelfTaskUpdateReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeShelfTask(List<Long> ids, Long instanceId, Long tenantId) {
        this.itemShelfService.removeShelfTask(ids, instanceId, tenantId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addOrModifyItemSalesCount(ItemStatReqDto itemStatReqDto) {
        this.itemService.addOrModifyItemSalesCount(itemStatReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchModifyItemStatus(@RequestBody ItemModifyStatusReqDto modifyStatusReqDto) {
        this.itemService.modifyItemStatus(modifyStatusReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> newSyncEs(ShelfQueryReqDto shelfQueryReqDto) {
        shelfQueryReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        List<ShelfQueryRespDto> selfList = this.shelfService.queryShelfList(shelfQueryReqDto);
        selfList.forEach(shelfQueryRespDto -> {
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            CubeBeanUtils.copyProperties((Object)shelfReqDto, (Object)shelfQueryReqDto, (String[])new String[0]);
            this.itemService.refreshSyn(shelfReqDto);
        });
        return new RestResponse();
    }

    public RestResponse<Void> syncEs() {
        ShelfQueryReqDto shelfQueryReqDto = new ShelfQueryReqDto();
        shelfQueryReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        List<ShelfQueryRespDto> selfList = this.shelfService.queryShelfList(shelfQueryReqDto);
        selfList.forEach(shelfQueryRespDto -> {
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            CubeBeanUtils.copyProperties((Object)shelfReqDto, (Object)shelfQueryReqDto, (String[])new String[0]);
            this.itemService.refresh(shelfReqDto);
        });
        return new RestResponse();
    }

    public RestResponse<Long> addItem(@NotNull ItemChangeApplyDto changeApplyDto) {
        return new RestResponse((Object)this.itemService.addItem(changeApplyDto));
    }

    public RestResponse<Void> modifyItem(@NotNull ItemReqDto itemReqDto) {
        this.itemService.modifyItem(itemReqDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> batchModifyShelfShopAuth(ShelfModifyShopAuthReqDto modifyShopAuthReqDto) {
        this.itemShelfService.batchModifyShelfShopAuth(modifyShopAuthReqDto);
        return RestResponse.VOID;
    }
}

