/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.core.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class Coder {
    public static final String KEY_SHA = "SHA";
    public static final String KEY_MD5 = "MD5";
    public static final String KEY_SHA_512 = "SHA-512";
    public static final String KEY_MAC = "HmacMD5";

    public static byte[] decryptBASE64(String key) throws Exception {
        return new BASE64Decoder().decodeBuffer(key);
    }

    public static String encryptBASE64(byte[] key) throws Exception {
        return new BASE64Encoder().encodeBuffer(key);
    }

    public static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance(KEY_MD5);
        md5.update(data);
        return md5.digest();
    }

    public static byte[] encryptSHA(byte[] data) throws Exception {
        MessageDigest sha = MessageDigest.getInstance(KEY_SHA);
        sha.update(data);
        return sha.digest();
    }

    public static String initMacKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_MAC);
        SecretKey secretKey = keyGenerator.generateKey();
        return Coder.encryptBASE64(secretKey.getEncoded());
    }

    public static byte[] encryptHMAC(byte[] data, String key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(Coder.decryptBASE64(key), KEY_MAC);
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        return mac.doFinal(data);
    }

    public static String byteToHex(byte[] inbuf) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < inbuf.length; ++i) {
            String byteStr = Integer.toHexString(inbuf[i] & 0xFF);
            if (byteStr.length() != 2) {
                strBuf.append('0').append(byteStr);
                continue;
            }
            strBuf.append(byteStr);
        }
        return new String(strBuf);
    }

    public static byte[] hexToByte(String inbuf) {
        int len = inbuf.length() / 2;
        byte[] outbuf = new byte[len];
        for (int i = 0; i < len; ++i) {
            String tmpbuf = inbuf.substring(i * 2, i * 2 + 2);
            outbuf[i] = (byte)Integer.parseInt(tmpbuf, 16);
        }
        return outbuf;
    }

    public static void ascii2Hex(int len, byte[] data_in, byte[] data_out) {
        byte[] temp1 = new byte[1];
        byte[] temp2 = new byte[1];
        int i = 0;
        int j = 0;
        while (i < len) {
            temp1[0] = data_in[i];
            temp2[0] = data_in[i + 1];
            if (temp1[0] >= 48 && temp1[0] <= 57) {
                temp1[0] = (byte)(temp1[0] - 48);
                temp1[0] = (byte)(temp1[0] << 4);
                temp1[0] = (byte)(temp1[0] & 0xF0);
            } else if (temp1[0] >= 97 && temp1[0] <= 102) {
                temp1[0] = (byte)(temp1[0] - 87);
                temp1[0] = (byte)(temp1[0] << 4);
                temp1[0] = (byte)(temp1[0] & 0xF0);
            }
            if (temp2[0] >= 48 && temp2[0] <= 57) {
                temp2[0] = (byte)(temp2[0] - 48);
                temp2[0] = (byte)(temp2[0] & 0xF);
            } else if (temp2[0] >= 97 && temp2[0] <= 102) {
                temp2[0] = (byte)(temp2[0] - 87);
                temp2[0] = (byte)(temp2[0] & 0xF);
            }
            data_out[j] = (byte)(temp1[0] | temp2[0]);
            i += 2;
            ++j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashBytes(String hashAlg, byte[] dataBytes) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(hashAlg.trim());
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(dataBytes);
            byte[] buffer = new byte[4096];
            int readCount = is.read(buffer, 0, 4096);
            while (readCount != -1) {
                digest.update(buffer, 0, readCount);
                readCount = is.read(buffer, 0, 4096);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

