/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.core.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IpHelper {
    private static String ipRegExp = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";

    public static String readRealIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static boolean segmentCheck(String segment, String ip) {
        if ((segment = segment.replaceAll("\uff0c", ",")).indexOf(",") > 0) {
            String[] segments = segment.split(",");
            boolean pass = false;
            for (String s : segments) {
                if (null != s) {
                    s = s.trim();
                }
                if (!IpHelper.segmentCheck(s, ip)) continue;
                pass = true;
                break;
            }
            return pass;
        }
        return IpHelper.singleSegmentCheck(segment, ip);
    }

    public static boolean singleSegmentCheck(String segment, String ip) {
        long chkIpInLong;
        if (segment.indexOf("/") < 0) {
            return segment.equals(ip);
        }
        segment = segment.replace(" ", "").trim();
        ip = ip.trim();
        String[] temp = segment.split("/");
        String sip = temp[0];
        if (temp.length < 2) {
            return false;
        }
        if (!sip.matches(ipRegExp) || !ip.matches(ipRegExp)) {
            return false;
        }
        int mask = Integer.parseInt(temp[1]);
        if (mask < 0 || mask > 32) {
            return false;
        }
        if (!ip.matches(ipRegExp)) {
            return false;
        }
        long sipInLong = IpHelper.ipToLong(sip);
        int matchCount = Long.numberOfLeadingZeros(sipInLong ^ (chkIpInLong = IpHelper.ipToLong(ip)));
        return matchCount - 32 >= mask;
    }

    public static long ipToLong(String strIP) {
        long[] ip = new long[4];
        int position1 = strIP.indexOf(".");
        int position2 = strIP.indexOf(".", position1 + 1);
        int position3 = strIP.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIP.substring(0, position1));
        ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIP.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String longToIP(long longIP) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIP >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIP & 0xFFL));
        sb.append(".");
        return sb.toString();
    }

    public static boolean isLocalIp(String ip) {
        if (ip.startsWith("10.")) {
            return true;
        }
        if ("127.0.0.1".equals(ip)) {
            return true;
        }
        if (ip.startsWith("192.168.")) {
            return true;
        }
        return IpHelper.singleSegmentCheck("172.16.0.0/12", ip);
    }

    public static boolean isIp(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        String[] temp = ip.split("\\.");
        if (temp.length != 4 && temp.length != 6) {
            return false;
        }
        for (String string : temp) {
            if (string.length() != 1 && string.startsWith("0")) {
                return false;
            }
            if (string.length() > 3) {
                return false;
            }
            int val = Integer.valueOf(string);
            if (val <= 255) continue;
            return false;
        }
        return true;
    }
}

