/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.core.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SecureUtil {
    private static Logger logger = LoggerFactory.getLogger(SecureUtil.class);

    public static String MD5(Map<String, String> encryptMap, String salt) throws Exception {
        ArrayList<String> array = new ArrayList<String>();
        for (Map.Entry<String, String> entry : encryptMap.entrySet()) {
            array.add(entry.getKey() + "=" + entry.getValue());
        }
        String encryptSrc = StringUtils.join(array, (String)"&");
        logger.debug("\u7b7e\u540dKey\u4e3a:" + salt);
        logger.info("\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32\u4e3a\uff1a" + encryptSrc);
        return SecureUtil.MD5(encryptSrc + salt);
    }

    public static String MD5(String s) throws Exception {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        byte[] btInput = s.getBytes("utf8");
        MessageDigest mdInst = MessageDigest.getInstance("MD5");
        mdInst.update(btInput);
        byte[] md = mdInst.digest();
        int j = md.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        String sign = new String(str);
        logger.info("\u5f97\u5230\u7b7e\u540d\u503c\u4e3a:" + sign);
        return sign;
    }

    public static String binary(byte[] bytes, int radix) {
        return new BigInteger(1, bytes).toString(radix);
    }

    public static String base64Encode(byte[] bytes) {
        return new BASE64Encoder().encode(bytes);
    }

    public static byte[] base64Decode(String base64Code) throws Exception {
        return StringUtils.isEmpty((CharSequence)base64Code) ? null : new BASE64Decoder().decodeBuffer(base64Code);
    }

    public static byte[] md5(byte[] bytes) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(bytes);
        return md.digest();
    }

    public static byte[] md5(String msg) throws Exception {
        return StringUtils.isEmpty((CharSequence)msg) ? null : SecureUtil.md5(msg.getBytes());
    }

    public static String md5Encrypt(String msg) throws Exception {
        return StringUtils.isEmpty((CharSequence)msg) ? null : SecureUtil.base64Encode(SecureUtil.md5(msg));
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128, new SecureRandom(encryptKey.getBytes()));
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, new SecretKeySpec(kgen.generateKey().getEncoded(), "AES"));
        return cipher.doFinal(content.getBytes("utf-8"));
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return SecureUtil.base64Encode(SecureUtil.aesEncryptToBytes(content, encryptKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128, new SecureRandom(decryptKey.getBytes()));
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, new SecretKeySpec(kgen.generateKey().getEncoded(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty((CharSequence)encryptStr) ? null : SecureUtil.aesDecryptByBytes(SecureUtil.base64Decode(encryptStr), decryptKey);
    }
}

