/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.dto;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.annotation.CheckParameter;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.payment.constant.PayConstant;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.util.SignUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BaseDto
extends RequestDto {
    @ApiModelProperty(name="sign", value="\u7b7e\u540d\u4fe1\u606f", required=true)
    @CheckParameter(require=true, length=64)
    private String sign;
    @ApiModelProperty(name="sign", value="\u516c\u5171\u7b7e\u540d\u4fe1\u606f", required=true)
    @CheckParameter(length=64)
    private String globalSign;

    public Map<String, String> bean2Map() {
        return (Map)JSON.parseObject((String)this.toString(), TreeMap.class);
    }

    public String toString() {
        return JSON.toJSONString((Object)((Object)this));
    }

    public BaseDto json2Bean(String jsonData) {
        return (BaseDto)((Object)JSON.parseObject((String)jsonData, ((Object)((Object)this)).getClass()));
    }

    public BaseDto map2Bean(Map<String, String> mapData) {
        String extFields = mapData.get("extFields");
        Map extMap = null;
        if (!StringUtils.isEmpty((CharSequence)extFields)) {
            extMap = (Map)JSON.parseObject((String)extFields, TreeMap.class);
        }
        mapData.remove("extFields");
        BaseDto baseDto = (BaseDto)((Object)JSON.parseObject((String)JSON.toJSONString(mapData), ((Object)((Object)this)).getClass()));
        baseDto.setExtFields(extMap);
        return baseDto;
    }

    public Map<String, String> xml2Map(String xml) throws Exception {
        Document document = DocumentHelper.parseText((String)xml);
        Element rootElement = document.getRootElement();
        TreeMap<String, String> simMap = new TreeMap<String, String>();
        Iterator it = rootElement.elementIterator();
        System.out.print("");
        while (it.hasNext()) {
            Element element = (Element)it.next();
            simMap.put(element.getName(), element.getText());
        }
        return simMap;
    }

    public Map<Object, Object> json2Map(String json) {
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    public List<Object> json2List(String json) {
        return (List)JSON.parseObject((String)json, List.class);
    }

    public Map<String, String> formData2Map(String formData) {
        String[] params = formData.split("&");
        HashMap<String, String> paramMap = new HashMap<String, String>(20);
        for (String param : params) {
            String[] split = param.split("=");
            if (split.length != 2) continue;
            paramMap.put(split[0].trim(), split[1].trim());
        }
        return paramMap;
    }

    public boolean verifySign(String salt) throws VerifyException {
        return this.verifySign(this.bean2Map(), salt);
    }

    public boolean verifySign(Map<String, String> map, String salt) throws VerifyException {
        try {
            String sig = this.getSign();
            this.excludeAttr(map);
            String localSign = SignUtil.MD5(map, salt);
            if (!localSign.equalsIgnoreCase(sig)) {
                throw new VerifyException("\u7b7e\u540d\u4e0d\u4e00\u81f4");
            }
        }
        catch (Exception e) {
            throw new VerifyException("INVALID_SIGN:\u7b7e\u540d\u4e0d\u4e00\u81f4");
        }
        return true;
    }

    public boolean verifyGlobalSign(String salt) throws VerifyException {
        return this.verifyGlobalSign(this.bean2Map(), salt);
    }

    public boolean verifyGlobalSign(Map<String, String> map, String salt) throws VerifyException {
        try {
            String sig = this.getGlobalSign();
            this.excludeAttr(map);
            String localSign = SignUtil.MD5(map, salt);
            if (!localSign.equalsIgnoreCase(sig)) {
                throw new VerifyException("\u7b7e\u540d\u4e0d\u4e00\u81f4");
            }
        }
        catch (Exception e) {
            throw new VerifyException("INVALID_SIGN:\u7b7e\u540d\u4e0d\u4e00\u81f4");
        }
        return true;
    }

    public void doEncrypt(String salt) throws Exception {
        this.doEncrypt(this.bean2Map(), salt);
    }

    public void doEncrypt(Map<String, String> map, String salt) throws Exception {
        this.excludeAttr(map);
        this.setSign(SignUtil.MD5(map, salt));
    }

    public void doGlobalEncrypt(String salt) throws Exception {
        this.doGlobalEncrypt(this.bean2Map(), salt);
    }

    public void doGlobalEncrypt(Map<String, String> map, String salt) throws Exception {
        this.excludeAttr(map);
        this.setGlobalSign(SignUtil.MD5(map, salt));
    }

    private void excludeAttr(Map<String, String> map) {
        for (String excludeAttr : PayConstant.ENCRYPT_SIGN_EXCLUDE_ATTR) {
            if (!map.containsKey(excludeAttr)) continue;
            map.remove(excludeAttr);
        }
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getGlobalSign() {
        return this.globalSign;
    }

    public void setGlobalSign(String globalSign) {
        this.globalSign = globalSign;
    }
}

