/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.dto;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.annotation.CheckParameter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.payment.constant.PayConstant;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.util.SignUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BaseResponse<T>
extends RestResponse<T> {
    private String result;
    private String failCode;
    private String failMsg;
    private String globalSign;
    @CheckParameter(require=true, length=64)
    private String sign;

    public BaseResponse() {
    }

    public BaseResponse(String result) {
        this.result = result;
    }

    public BaseResponse(T data) {
    }

    public BaseResponse(String result, String failCode, String failMsg) {
        this(result);
        this.failCode = failCode;
        this.failMsg = failMsg;
    }

    public void doEncrypt(String salt) throws Exception {
        Map<String, String> map = this.bean2Map();
        map.put("data", JSON.toJSONString((Object)this.getData()));
        this.doEncrypt(map, salt);
    }

    public void doGlobalEncrypt(String salt) throws Exception {
        Map<String, String> map = this.bean2Map();
        map.put("data", JSON.toJSONString((Object)this.getData()));
        this.doGlobalEncrypt(map, salt);
    }

    public boolean verifySign(String salt) throws VerifyException {
        Map<String, String> map = this.bean2Map();
        map.put("data", JSON.toJSONString((Object)this.getData()));
        return this.verifySign(map, salt);
    }

    public boolean verifyGlobalSign(String salt) throws VerifyException {
        Map<String, String> map = this.bean2Map();
        map.put("data", JSON.toJSONString((Object)this.getData()));
        return this.verifyGlobalSign(map, salt);
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getFailCode() {
        return this.failCode;
    }

    public void setFailCode(String failCode) {
        this.failCode = failCode;
    }

    public String getFailMsg() {
        return this.failMsg;
    }

    public void setFailMsg(String failMsg) {
        this.failMsg = failMsg;
    }

    public Map<String, String> bean2Map() {
        return (Map)JSON.parseObject((String)this.toString(), TreeMap.class);
    }

    public String toString() {
        return JSON.toJSONString((Object)((Object)this));
    }

    public BaseResponse json2Bean(String jsonData) {
        return (BaseResponse)((Object)JSON.parseObject((String)jsonData, ((Object)((Object)this)).getClass()));
    }

    public BaseResponse map2Bean(Map<String, String> mapData) {
        return (BaseResponse)((Object)JSON.parseObject((String)JSON.toJSONString(mapData), ((Object)((Object)this)).getClass()));
    }

    public Map<String, String> xml2Map(String xml) throws Exception {
        Document document = DocumentHelper.parseText((String)xml);
        Element rootElement = document.getRootElement();
        TreeMap<String, String> simMap = new TreeMap<String, String>();
        Iterator it = rootElement.elementIterator();
        System.out.print("");
        while (it.hasNext()) {
            Element element = (Element)it.next();
            simMap.put(element.getName(), element.getText());
        }
        return simMap;
    }

    public Map<Object, Object> json2Map(String json) {
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    public List<Object> json2List(String json) {
        return (List)JSON.parseObject((String)json, List.class);
    }

    public Map<String, String> formData2Map(String formData) {
        String[] params = formData.split("&");
        HashMap<String, String> paramMap = new HashMap<String, String>(20);
        for (String param : params) {
            String[] split = param.split("=");
            if (split.length != 2) continue;
            paramMap.put(split[0].trim(), split[1].trim());
        }
        return paramMap;
    }

    public boolean verifySign(Map<String, String> map, String salt) throws VerifyException {
        try {
            String sig = this.getSign();
            this.excludeAttr(map);
            String localSign = SignUtil.MD5(map, salt);
            if (!localSign.equalsIgnoreCase(sig)) {
                throw new VerifyException("\u7b7e\u540d\u4e0d\u4e00\u81f4");
            }
        }
        catch (Exception e) {
            throw new VerifyException("INVALID_SIGN:\u7b7e\u540d\u4e0d\u4e00\u81f4");
        }
        return true;
    }

    public boolean verifyGlobalSign(Map<String, String> map, String salt) throws VerifyException {
        try {
            String sig = this.getGlobalSign();
            this.excludeAttr(map);
            String localSign = SignUtil.MD5(map, salt);
            if (!localSign.equalsIgnoreCase(sig)) {
                throw new VerifyException("\u7b7e\u540d\u4e0d\u4e00\u81f4");
            }
        }
        catch (Exception e) {
            throw new VerifyException("INVALID_SIGN:\u7b7e\u540d\u4e0d\u4e00\u81f4");
        }
        return true;
    }

    public void doEncrypt(Map<String, String> map, String salt) throws Exception {
        this.excludeAttr(map);
        this.setSign(SignUtil.MD5(map, salt));
    }

    public void doGlobalEncrypt(Map<String, String> map, String salt) throws Exception {
        this.excludeAttr(map);
        this.setGlobalSign(SignUtil.MD5(map, salt));
    }

    private void excludeAttr(Map<String, String> map) {
        for (String excludeAttr : PayConstant.ENCRYPT_SIGN_EXCLUDE_ATTR) {
            if (!map.containsKey(excludeAttr)) continue;
            map.remove(excludeAttr);
        }
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getGlobalSign() {
        return this.globalSign;
    }

    public void setGlobalSign(String globalSign) {
        this.globalSign = globalSign;
    }
}

