/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.service.RequestValidateService;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.util.CheckParameterUtil;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.PayAppVo;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.BaseRespDomain;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StoreEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiBaseService<T extends BaseRequest> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected StoreDas payStoreDas;
    @Resource
    private RequestValidateService requestValidateService;
    @Resource
    protected ICacheService cacheService;
    @Resource
    private PayAppVo payAppVo;
    protected static final int DEFAULT_CACHED_TIME = 1800;

    public void _validate(T request) throws Exception {
        CheckParameterUtil<T> requestChecker = new CheckParameterUtil<T>();
        try {
            requestChecker.check4Object(request);
        }
        catch (Exception e) {
            this.logger.error("\u6821\u9a8c\u8bf7\u6c42\u53c2\u6570\u51fa\u9519", (Throwable)e);
            throw new ApiException("INVALID_PARAM", (Throwable)e);
        }
        this.requestValidateService.validateBaseRequest((BaseRequest)request);
        this.validate(request);
    }

    public BaseResponse execute(T request) throws ApiException, VerifyException {
        try {
            this.logger.info("\u6536\u5230\u5546\u6237API\u8bf7\u6c42:{}", (Object)request.toString());
            BaseResponse response = this.responseCachedResult(request);
            if (response == null) {
                this._validate(request);
                response = this._execute(request);
                StoreEo payStore = (StoreEo)this.payStoreDas.selectByLogicKey((Object)request.getStoreId());
                response.doEncrypt(payStore.getApiSecret());
                response.doGlobalEncrypt(this.payAppVo.getApiSecret());
                this.cacheResult(request, response);
            }
            this.logger.info("\u54cd\u5e94\u5546\u6237:{}", (Object)response.toString());
            return response;
        }
        catch (ApiException apiException) {
            this.logger.error("", (Throwable)apiException);
            throw apiException;
        }
        catch (VerifyException ve) {
            this.logger.error(ve.getMessage(), (Throwable)ve);
            throw ve;
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            throw new ApiException("SYSTEM_ERROR", ErrorCode.getErrorMsg((String)"SYSTEM_ERROR"));
        }
    }

    public abstract BaseResponse _execute(T var1) throws Exception;

    protected void packageApiResponse(BaseResponse response, BaseGatewayResult result) {
        if (result.isDoneSucc()) {
            response.setResult("SUCCESS");
        } else {
            response.setFailCode(result.getErrorCode());
            response.setFailMsg(result.getErrorMsg());
            response.setResult("FAIL");
        }
    }

    protected void packageApiResponse(BaseResponse response, BaseRespDomain result) {
        if ("000000".equals(result.getRspCode())) {
            response.setResult("SUCCESS");
        } else {
            if (StringUtils.isBlank((CharSequence)result.getRspCode())) {
                response.setFailCode("SYSTEM_ERROR");
                response.setFailMsg(ErrorCode.getErrorMsg((String)"SYSTEM_ERROR"));
            } else {
                response.setFailCode(result.getRspCode());
                response.setFailMsg(result.getRspMsg());
            }
            response.setResult("FAIL");
        }
    }

    protected void setData(BaseResponse response, BaseRespDomain result) {
        if ("SUCCESS".equals(response.getResult())) {
            response.setData((Object)result.getResponseMap());
        }
    }

    public abstract void validate(T var1) throws Exception;

    public void setRequestValidateService(RequestValidateService requestValidateService) {
        this.requestValidateService = requestValidateService;
    }

    public void cacheResult(T t, BaseResponse response) {
        this.logger.info("\u4e0d\u7f13\u5b58\u54cd\u5e94\u7ed3\u679c");
    }

    public BaseResponse responseCachedResult(T t) {
        return null;
    }
}

