/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl;

import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.CloseRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.CloseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.ConfirmReponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.ConfirmRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.EnterpriseTransferRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.EnterpriseTransferResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="createTradeService")
public class CreateTradeServiceImpl
implements ICreateTradeService {
    @Resource
    private ApiBaseService createPayOrderTradeService;
    @Resource
    private ApiBaseService createEnterpriseTransferOrderService;
    @Resource
    private ApiBaseService createRefundPayOrderTradeService;
    @Resource
    private ApiBaseService createEnterOrderTradeService;
    @Resource
    private ApiBaseService createNewEnterOrderTradeService;
    @Resource
    private ApiBaseService closePayOrderTradeService;
    @Resource
    private ApiBaseService<ConfirmRequest> comfirmPayOrderTradeService;
    @Resource
    private ApiBaseService createRefundPayEnterOrderService;

    public PayResponse createPayOrder(PayRequest request) throws ApiException, VerifyException {
        return (PayResponse)this.createPayOrderTradeService.execute(request);
    }

    public EnterpriseTransferResponse createEnterpriseTransferOrder(EnterpriseTransferRequest request) throws ApiException, VerifyException {
        return (EnterpriseTransferResponse)this.createEnterpriseTransferOrderService.execute(request);
    }

    public RefundResponse createRefundOrder(RefundRequest request) throws ApiException, VerifyException {
        if (TradeIdType.verifyIdType((String)request.getTradeId(), (TradeIdType)TradeIdType.PAY)) {
            return (RefundResponse)this.createRefundPayOrderTradeService.execute(request);
        }
        return (RefundResponse)this.createRefundPayEnterOrderService.execute(request);
    }

    public PayEnterResponse createEnterOrder(PayEnterRequest request) throws ApiException, VerifyException {
        return (PayEnterResponse)this.createEnterOrderTradeService.execute(request);
    }

    public PayEnterResponse createNewEnterOrder(PayEnterRequest request) throws ApiException, VerifyException {
        return (PayEnterResponse)this.createNewEnterOrderTradeService.execute(request);
    }

    public CloseResponse closePayOrder(CloseRequest request) throws ApiException, VerifyException {
        return (CloseResponse)this.closePayOrderTradeService.execute(request);
    }

    public ConfirmReponse confirmOrder(ConfirmRequest request) throws ApiException, VerifyException {
        return (ConfirmReponse)this.comfirmPayOrderTradeService.execute(request);
    }
}

