/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.account;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.account.AccountApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.account.CustAccountQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.account.CustAccountQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.EPayAccountPartnerService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.BaseRespDomain;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.CustAccountQueryReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.CustAccountQueryResp;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="accountQueryService")
public class AccountQueryServiceImpl
extends AccountApiBaseService<CustAccountQueryRequest> {
    @Resource
    private EPayAccountPartnerService ePayAccountPartnerService;

    @Override
    public BaseResponse _execute(CustAccountQueryRequest request) throws Exception {
        PartnerConfigEo payPartnerConfig = this.partnerConfigManager.getEPayPartnerconfig();
        CustAccountQueryReq custAccountReq = new CustAccountQueryReq();
        custAccountReq.setQydm(payPartnerConfig.getPtMerId());
        custAccountReq.setThirdLogNo(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        custAccountReq.setSupAcctId(payPartnerConfig.getPtAccount());
        custAccountReq.setThirdCustId(request.getUserId());
        custAccountReq.setReserve(request.getReserve());
        CustAccountQueryResp respDomain = this.ePayAccountPartnerService.queryCustAccount(custAccountReq);
        CustAccountQueryResponse resp = new CustAccountQueryResponse();
        this.packageApiResponse((BaseResponse)resp, (BaseRespDomain)respDomain);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("ptUserId", respDomain.getCustAcctId());
        data.put("balance", respDomain.getTotalBalance());
        data.put("avaBalance", respDomain.getTotalAmount());
        data.put("freezeAmt", respDomain.getTotalFreezeAmount());
        resp.setData(data);
        return resp;
    }

    @Override
    public void validate(CustAccountQueryRequest request) throws Exception {
    }
}

