/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.account;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.account.AccountApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.account.BindExtractAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.account.BindExtractAccountResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.BaseRespDomain;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.account.BindExtractAccReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.account.BindExtractAccResp;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="bindExtractAccountService")
public class BindExtractAccountServiceImpl
extends AccountApiBaseService<BindExtractAccountRequest> {
    @Override
    public BaseResponse _execute(BindExtractAccountRequest request) throws Exception {
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getEPayPartnerconfig();
        BindExtractAccountResponse response = new BindExtractAccountResponse();
        BindExtractAccReq rep = new BindExtractAccReq();
        if (request.getBindType().equals(BindExtractAccountRequest.BindTypeEnum.UNIONPAY.getType())) {
            if (StringUtils.isBlank((CharSequence)request.getBankCode())) {
                throw new ApiException("backCode\u5fc5\u4f20");
            }
            rep.setTranFunc("6066");
        } else {
            if (StringUtils.isBlank((CharSequence)request.getsBankCode())) {
                throw new ApiException("sBankCode\u5fc5\u4f20");
            }
            rep.setTranFunc("6055");
        }
        rep.setQydm(partnerConfig.getPtMerId());
        rep.setThirdLogNo(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        rep.setSupAcctId(partnerConfig.getPtAccount());
        rep.setCustAcctId(request.getPtUserId());
        rep.setThirdCustId(request.getUserId());
        rep.setCustName(request.getUserName());
        rep.setIdCode(request.getIdCode());
        rep.setIdType("1");
        rep.setAcctId(request.getBankAccount());
        rep.setBankType(request.getBankType());
        rep.setBankName(request.getBankName());
        rep.setBankCode(request.getBankCode());
        rep.setsBankCode(request.getsBankCode());
        rep.setMobilePhone(request.getMobile());
        BindExtractAccResp resp = this.ePayAccountPartnerService.bindExtractAccount(rep);
        this.packageApiResponse((BaseResponse)response, (BaseRespDomain)resp);
        HashMap<String, String> data = new HashMap<String, String>(1);
        data.put("mobile", request.getMobile());
        response.setData(data);
        return response;
    }

    @Override
    public void validate(BindExtractAccountRequest request) throws Exception {
    }
}

