/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.account;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.account.SpecAccountQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.account.SpecAccountQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.EPayAccountPartnerService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.CustAcctInfoQueryDetail;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.CustAcctInfoQueryReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.CustAcctInfoQueryResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.TradeIdGenService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;

@Service(value="specAccountQueryService")
public class SpecAccountQueryServiceImpl
extends ApiBaseService<SpecAccountQueryRequest> {
    @Resource
    private EPayAccountPartnerService ePayAccountPartnerService;
    @Resource
    private TradeIdGenService tradeIdGenService;
    @Resource
    protected PartnerConfigManager partnerConfigManager;

    @Override
    public BaseResponse _execute(SpecAccountQueryRequest request) throws Exception {
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getEPayPartnerconfig();
        CustAcctInfoQueryReq req = new CustAcctInfoQueryReq();
        req.setQydm(partnerConfig.getPtMerId());
        req.setSupAcctId(partnerConfig.getPtAccount());
        req.setThirdLogNo(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        req.setSelectFlag("3");
        return this.rechargeResp(this.ePayAccountPartnerService.queryCustAccountInfo(req));
    }

    private SpecAccountQueryResponse rechargeResp(CustAcctInfoQueryResp resp) {
        SpecAccountQueryResponse response = new SpecAccountQueryResponse();
        if (!"000000".equals(resp.getRspCode()) || null == resp.getArray() || resp.getArray().isEmpty()) {
            response.setResult("FAIL");
            response.setFailCode("SYSTEM_ERROR");
            response.setFailMsg(ErrorCode.getErrorMsg((String)"SYSTEM_ERROR"));
        } else {
            List infos = resp.getArray();
            ArrayList accountList = new ArrayList();
            DateTimeFormatter format = DateTimeFormat.forPattern((String)"yyyyMMdd");
            for (CustAcctInfoQueryDetail detail : infos) {
                TreeMap<String, String> account = new TreeMap<String, String>();
                account.put("accountId", detail.getCustAcctId());
                account.put("accountName", detail.getCustName());
                account.put("balance", detail.getTotalBalance());
                account.put("enableAmt", detail.getTotalTranOutAmount());
                DateTime dateTime = DateTime.parse((String)detail.getTranDate(), (DateTimeFormatter)format);
                account.put("modifyDate", dateTime.toString("yyyy-MM-dd"));
                accountList.add(account);
            }
            response.setResult("SUCCESS");
            response.setAccountList(accountList);
        }
        return response;
    }

    @Override
    public void validate(SpecAccountQueryRequest request) throws Exception {
    }
}

