/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.account;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.account.SuperAccountQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.account.SuperAccountQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.EPayAccountPartnerService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.SupAcctInfoQueryReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.query.SupAcctInfoQueryResp;
import com.dtyunxi.yundt.cube.center.payment.service.trade.TradeIdGenService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="superAccountQueryService")
public class SuperAccountQueryServiceImpl
extends ApiBaseService<SuperAccountQueryRequest> {
    @Resource
    private EPayAccountPartnerService ePayAccountPartnerService;
    @Resource
    private TradeIdGenService tradeIdGenService;
    @Resource
    protected PartnerConfigManager partnerConfigManager;

    @Override
    public BaseResponse _execute(SuperAccountQueryRequest request) throws Exception {
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getEPayPartnerconfig();
        SupAcctInfoQueryReq req = new SupAcctInfoQueryReq();
        req.setSupAcctId(partnerConfig.getPtAccount());
        req.setQydm(partnerConfig.getPtMerId());
        req.setThirdLogNo(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        SupAcctInfoQueryResp resp = this.ePayAccountPartnerService.querySupAccount(req);
        SuperAccountQueryResponse response = new SuperAccountQueryResponse();
        if ("000000".equals(resp.getRspCode())) {
            response.setResult("SUCCESS");
            response.setCurBalance(resp.getCurBalance());
            response.setLastBalance(resp.getLastBalance());
        } else {
            response.setResult("FAIL");
            response.setFailMsg("\u6e20\u9053\u7e41\u5fd9");
            response.setFailCode("SYSTEM_ERROR");
        }
        return response;
    }

    @Override
    public void validate(SuperAccountQueryRequest request) throws Exception {
    }

    public void setePayAccountPartnerService(EPayAccountPartnerService ePayAccountPartnerService) {
        this.ePayAccountPartnerService = ePayAccountPartnerService;
    }

    public void setTradeIdGenService(TradeIdGenService tradeIdGenService) {
        this.tradeIdGenService = tradeIdGenService;
    }

    public void setPartnerConfigManager(PartnerConfigManager partnerConfigManager) {
        this.partnerConfigManager = partnerConfigManager;
    }
}

