/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.account;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.account.AccountApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.account.VerifyExtractAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.account.VerifyExtractAccountResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.BaseRespDomain;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.account.CodeVerifyExtractAccReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.epay.domain.account.CodeVerifyExtractAccResp;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="verifyExtractAccountService")
public class VerifyExtractAccountServiceImpl
extends AccountApiBaseService<VerifyExtractAccountRequest> {
    @Override
    public BaseResponse _execute(VerifyExtractAccountRequest request) throws Exception {
        VerifyExtractAccountResponse response = new VerifyExtractAccountResponse();
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getEPayPartnerconfig();
        CodeVerifyExtractAccReq verifyRequest = new CodeVerifyExtractAccReq();
        if (StringUtils.isNotBlank((CharSequence)request.getVerifyCode())) {
            verifyRequest.setTranFunc("6067");
        } else {
            if (StringUtils.isBlank((CharSequence)request.getAmount())) {
                throw new ApiException("\u9274\u6743\u91d1\u989d(amount)\u5fc5\u4f20");
            }
            verifyRequest.setTranFunc("6064");
        }
        verifyRequest.setQydm(partnerConfig.getPtMerId());
        verifyRequest.setThirdLogNo(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        verifyRequest.setSupAcctId(partnerConfig.getPtAccount());
        verifyRequest.setThirdCustId(request.getUserId());
        verifyRequest.setCustAcctId(request.getPtUserId());
        verifyRequest.setAcctId(request.getBankAmount());
        verifyRequest.setMessageCode(request.getVerifyCode());
        verifyRequest.setTranAmount(request.getAmount());
        if (StringUtils.isNotBlank((CharSequence)request.getAmount())) {
            verifyRequest.setCustAcctName(request.getUserId());
            verifyRequest.setCcyCode("RMB");
        }
        verifyRequest.setReserve(request.getReserve());
        CodeVerifyExtractAccResp respDomain = this.ePayAccountPartnerService.verifyExtractAccountByCode(verifyRequest);
        this.packageApiResponse((BaseResponse)response, (BaseRespDomain)respDomain);
        return response;
    }

    private void setData(VerifyExtractAccountResponse response, CodeVerifyExtractAccResp respDomain) {
        if ("SUCCESS".equals(response.getResult())) {
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("Reserve", respDomain.getReserve());
            response.setData(temp);
        }
    }

    @Override
    public void validate(VerifyExtractAccountRequest request) throws Exception {
    }
}

