/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.bank;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.bank.AbstractBankCardService;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.bank.BindCardRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.bank.BindCardResponse;
import com.dtyunxi.yundt.cube.center.payment.service.constants.SafetyConstants;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.RequestVo;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.bank.BindCardReq;
import com.dtyunxi.yundt.cube.center.payment.service.trade.TradeIdGenService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="bindCardService")
public class BindCardServiceImpl
extends AbstractBankCardService<BindCardRequest> {
    @Resource
    private TradeIdGenService tradeIdGenService;

    @Override
    public BaseResponse _execute(BindCardRequest request) throws Exception {
        PartnerConfigEo payPartnerConfig = this.partnerConfigManager.getEWalletPartnerConfig();
        BindCardReq bindCardReq = new BindCardReq();
        bindCardReq.setMasterId(payPartnerConfig.getPtMerId());
        bindCardReq.setCustomerId(request.getUserId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        bindCardReq.setDateTime(sdf.format(new Date()));
        bindCardReq.setOrderId(this.tradeIdGenService.genTradeId(payPartnerConfig.getPtMerId()));
        bindCardReq.setDecryptKey(payPartnerConfig.getPtPubKey());
        bindCardReq.setEncryptKey(payPartnerConfig.getLcPrivKey());
        RequestVo requestVo = bindCardReq.bean2RequestVo();
        String html = this.createHtml(SafetyConstants.EWALLETCFG.getBindCard(), requestVo.getOrig(), requestVo.getSign(), request.getBackUrl(), request.getNotifyUrl());
        BindCardResponse response = new BindCardResponse();
        response.setResult("SUCCESS");
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("form", html);
        response.setData(map);
        return response;
    }

    private String createHtml(String url, String orig, String sign, String returnUrl, String NotifyUrl) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form method='post' action='").append(url).append("'>");
        sb.append("<input type='hidden' name='orig' value='").append(orig).append("'/>");
        sb.append("<input type='hidden' name='sign' value='").append(sign).append("'/>");
        if (StringUtils.isNotBlank((CharSequence)returnUrl)) {
            sb.append("<input type='hidden' name='returnurl' value='").append(returnUrl).append("'/>");
        }
        sb.append("<input type='hidden' name='NOTIFYURL' value='").append(NotifyUrl).append("'/>");
        sb.append("<input type='submit' value='\u7ed1\u5361'/>");
        sb.append("</form>");
        return sb.toString();
    }

    @Override
    public void validate(BindCardRequest request) throws Exception {
    }
}

