/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.bank;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.bank.AbstractBankCardService;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.bank.BindCardQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.bank.BindCardQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.bank.BindCardQueryReq;
import com.dtyunxi.yundt.cube.center.payment.service.partner.pingan.ewallet.domain.bank.BindCardQueryResp;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="queryBindCardService")
public class QueryBindCardServiceImpl
extends AbstractBankCardService<BindCardQueryRequest> {
    @Override
    public BaseResponse _execute(BindCardQueryRequest request) throws Exception {
        PartnerConfigEo payPartnerConfig = this.partnerConfigManager.getEWalletPartnerConfig();
        BindCardQueryReq req = new BindCardQueryReq();
        req.setMasterId(payPartnerConfig.getPtMerId());
        req.setCustomerId(request.getUserId());
        req.setEncryptKey(payPartnerConfig.getLcPrivKey());
        req.setDecryptKey(payPartnerConfig.getPtPubKey());
        BindCardQueryResp resp = this.eWalletPartnerService.queryBindCard(req);
        BindCardQueryResponse response = new BindCardQueryResponse();
        if (StringUtils.isNotBlank((CharSequence)resp.getErrorMsg())) {
            response.setResult("FAIL");
            response.setFailCode(resp.getErrorCode());
            response.setFailMsg(resp.getErrorMsg());
        } else {
            response.setResult("SUCCESS");
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            ArrayList list = new ArrayList();
            for (Map cardInfo : resp.getBindAccIcoll()) {
                LinkedHashMap temp = new LinkedHashMap();
                temp.put("bindId", cardInfo.get("OpenId"));
                temp.put("bankAccount", cardInfo.get("accNo"));
                list.add(temp);
            }
            data.put("list", JSON.toJSONString(list));
            response.setData(data);
        }
        return response;
    }

    @Override
    public void validate(BindCardQueryRequest request) throws Exception {
    }
}

