/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.center.account;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.center.account.CenterAccountApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.Constant;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.center.account.RechargeRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.center.account.RechargeResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.base.TradeBaseResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StoreEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="centerAccountRechargeService")
public class CenterAccountRechargeServiceImpl
extends CenterAccountApiBaseService<RechargeRequest> {
    @Resource
    ICreateTradeService createTradeService;
    @Resource
    protected PartnerConfigManager partnerConfigManager;

    @Override
    public BaseResponse _execute(RechargeRequest request) throws Exception {
        String host;
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        if (partnerConfig.getPartnerCode().equals("800")) {
            throw new Exception("\u5145\u503c\u4e0d\u80fd\u9009\u62e9\u8d26\u6237\u6e20\u9053\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6e20\u9053\uff01");
        }
        String string = host = StringUtils.isBlank((CharSequence)Constant.APPVO.getGatewayHost()) ? Constant.APPVO.getAppHost() : Constant.APPVO.getGatewayHost();
        if (request.getRequestType().equals("RECHARGE")) {
            request.setNotifyUrl(host + "/center/account/notify/recharge");
        } else if (request.getRequestType().equals("REIMBURSEMENT")) {
            request.setNotifyUrl(host + "/center/account/notify/reimbursement");
            request.setRemark6("1");
        }
        StoreEo store = (StoreEo)this.payStoreDas.selectByLogicKey((Object)request.getStoreId());
        request.doEncrypt(store.getApiSecret());
        RechargeResponse response = new RechargeResponse();
        TradeBaseResponse payOrders = new TradeBaseResponse();
        if (StringUtils.isBlank((CharSequence)partnerConfig.getEnterType())) {
            payOrders = this.createTradeService.createPayOrder((PayRequest)request);
        } else {
            PayEnterRequest requests = new PayEnterRequest();
            CubeBeanUtils.copyProperties((Object)requests, (Object)request, (String[])new String[0]);
            payOrders = this.createTradeService.createEnterOrder(requests);
        }
        response.setData(payOrders.getData());
        this.payResponse(response, payOrders.getFailCode(), payOrders.getFailMsg(), payOrders.getResult());
        return response;
    }

    @Override
    public void validate(RechargeRequest request) throws Exception {
    }

    public void payResponse(RechargeResponse response, String code, String message, String result) {
        response.setFailCode(code);
        response.setFailMsg(message);
        response.setResult(result);
    }
}

