/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.center.account;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.ITransactionApi;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.tran.RechargeReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.tran.RechargeRespDto;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.center.account.RechargeResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.center.account.ReimbursementRequest;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="centerAccountReimbursementServiceImpl")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class CenterAccountReimbursementServiceImpl
extends ApiBaseService<ReimbursementRequest> {
    @Resource
    ITransactionApi transactionApi;
    @Resource
    protected PayOrderDas payOrderDas;
    @Resource
    protected PayOrderAttachInfoDas payOrderAttachInfoDas;
    @Resource
    protected EnterpriseOrderDas enterpriseOrderDas;
    @Resource
    protected EnterpriseOrderAttachInfoDas enterpriseOrderAttachInfoDas;
    @Resource
    protected PartnerConfigManager partnerConfigManager;

    @Override
    public BaseResponse _execute(ReimbursementRequest request) throws Exception {
        try {
            PayOrderAttachInfoEo attach;
            PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
            if (StringUtils.isBlank((CharSequence)partnerConfig.getEnterType())) {
                PayOrderEo payOrderEo = this.payOrderDas.selectOrder(request.getTradeId(), request.getStoreId(), request.getStoreOrderId(), OrderStatus.SUCCESS.getStatus());
                if (payOrderEo == null) {
                    throw new Exception("\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
                }
                attach = PayOrderAttachInfoEo.newInstance();
                attach.setTradeId(payOrderEo.getTradeId());
                PayOrderAttachInfoEo payOrderAttachInfoEo = (PayOrderAttachInfoEo)this.payOrderAttachInfoDas.selectOne((BaseEo)attach);
                if (StringUtils.isBlank((CharSequence)payOrderAttachInfoEo.getRemark6())) {
                    throw new Exception("\u8be5\u8ba2\u5355\u4e0d\u662f\u8fd8\u6b3e\u8ba2\u5355");
                }
                if (!payOrderAttachInfoEo.getRemark6().equals("1")) {
                    throw new Exception("\u8be5\u8ba2\u5355\u5df2\u7ecf\u5ba1\u6279");
                }
                payOrderAttachInfoEo.setRemark6("0");
                this.payOrderAttachInfoDas.updateSelective((BaseEo)payOrderAttachInfoEo);
            } else {
                EnterpriseOrderEo enterpriseOrderEo = this.enterpriseOrderDas.selectOrder(request.getTradeId(), request.getStoreId(), request.getStoreOrderId());
                if (null == enterpriseOrderEo || !OrderStatus.SUCCESS.getStatus().equals(enterpriseOrderEo.getStatus())) {
                    throw new Exception("\u4f01\u4e1a\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
                }
                attach = EnterpriseOrderAttachInfoEo.newInstance();
                attach.setTradeId(enterpriseOrderEo.getTradeId());
                EnterpriseOrderAttachInfoEo enterpriseOrderAttachInfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachInfoDas.selectOne((BaseEo)attach);
                if (StringUtils.isBlank((CharSequence)enterpriseOrderAttachInfoEo.getRemark6())) {
                    throw new Exception("\u8be5\u8ba2\u5355\u4e0d\u662f\u8fd8\u6b3e\u8ba2\u5355");
                }
                if (!enterpriseOrderAttachInfoEo.getRemark6().equals("1")) {
                    throw new Exception("\u8be5\u8ba2\u5355\u5df2\u7ecf\u5ba1\u6279");
                }
                enterpriseOrderAttachInfoEo.setRemark6("0");
                this.enterpriseOrderAttachInfoDas.updateSelective((BaseEo)enterpriseOrderAttachInfoEo);
            }
            RechargeResponse response = new RechargeResponse();
            RechargeReqDto placeRequest = new RechargeReqDto();
            placeRequest.setAccountId(request.getAccountId());
            placeRequest.setTranType("RECHARGE");
            placeRequest.setTranAmt(request.getTranAmt());
            placeRequest.setTradeId(request.getTradeId());
            Map map1 = (Map)JSON.parseObject((String)JSON.toJSONString((Object)placeRequest), Map.class);
            RestResponse baseTranRespDtoRestResponse = this.transactionApi.doTransaction(placeRequest.getTranType(), map1);
            response.setData((Object)baseTranRespDtoRestResponse);
            response.setTradeId(((RechargeRespDto)baseTranRespDtoRestResponse.getData()).getTradeId());
            return response;
        }
        catch (Exception e) {
            throw new Exception("\u786e\u8ba4\u8fd8\u6b3e\u6570\u636e\u5f02\u5e38");
        }
    }

    @Override
    public void validate(ReimbursementRequest request) throws Exception {
    }
}

