/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.center.account;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.ITransactionApi;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.tran.WithDrawConfirmReqDto;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.Constant;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.center.account.WithdrawalRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.center.account.WithdrawalResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.base.TradeBaseResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.payment.service.trade.TradeIdGenService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StoreEo;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="centerAccountWithdrawalServiceImpl")
public class CenterAccountWithdrawalServiceImpl
extends ApiBaseService<WithdrawalRequest> {
    @Resource
    ICreateTradeService createTradeService;
    @Resource
    ITransactionApi transactionApi;
    @Resource
    private TradeIdGenService tradeIdGenService;
    @Resource
    protected PartnerConfigManager partnerConfigManager;

    @Override
    public BaseResponse _execute(WithdrawalRequest request) throws Exception {
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        if (partnerConfig.getPartnerCode().equals("800")) {
            throw new Exception("\u5145\u503c\u4e0d\u80fd\u9009\u62e9\u8d26\u6237\u6e20\u9053\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6e20\u9053\uff01");
        }
        WithDrawConfirmReqDto req = new WithDrawConfirmReqDto();
        CubeBeanUtils.copyProperties((Object)req, (Object)request, (String[])new String[0]);
        req.setSerialNo(request.getSerialNo());
        req.setVerifyCode(request.getVerifyCode());
        req.setTradeId(this.tradeIdGenService.genTradeId(TradeIdType.PAY));
        request.setRemark(req.getTradeId());
        req.setTranType("WITHDRAW");
        req.setWithDrawStep("VERIFY");
        req.setTranAmt(request.getOrderAmt());
        RestResponse baseTranRespDtoRestResponse = this.transactionApi.modifyTransaction(req.getTranType(), (Map)JSON.parseObject((String)JSON.toJSONString((Object)req), Map.class));
        if (!baseTranRespDtoRestResponse.getResultCode().equals("0")) {
            throw new Exception("\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        String host = StringUtils.isBlank((CharSequence)Constant.APPVO.getGatewayHost()) ? Constant.APPVO.getAppHost() : Constant.APPVO.getGatewayHost();
        request.setNotifyUrl(host + "/center/account/notify/withdrawal");
        StoreEo store = (StoreEo)this.payStoreDas.selectByLogicKey((Object)request.getStoreId());
        request.doEncrypt(store.getApiSecret());
        WithdrawalResponse response = new WithdrawalResponse();
        TradeBaseResponse payOrders = new TradeBaseResponse();
        if (StringUtils.isBlank((CharSequence)partnerConfig.getEnterType())) {
            payOrders = this.createTradeService.createPayOrder((PayRequest)request);
        } else {
            PayEnterRequest requests = new PayEnterRequest();
            CubeBeanUtils.copyProperties((Object)requests, (Object)request, (String[])new String[0]);
            payOrders = this.createTradeService.createEnterOrder(requests);
        }
        response.setData(payOrders.getData());
        this.payResponse(response, payOrders.getFailCode(), payOrders.getFailMsg(), payOrders.getResult());
        return response;
    }

    @Override
    public void validate(WithdrawalRequest request) throws Exception {
    }

    public void payResponse(WithdrawalResponse response, String code, String message, String result) {
        response.setFailCode(code);
        response.setFailMsg(message);
        response.setResult(result);
    }
}

