/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.service;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.PayAppVo;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AppDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AppPaytypeDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.AppEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.AppPaytypeEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StoreEo;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="requestValidateService")
public class RequestValidateService {
    private static Logger logger = LoggerFactory.getLogger(RequestValidateService.class);
    @Resource
    private StoreDas payStoreDas;
    @Resource
    private AppDas payAppsDas;
    @Resource
    private AppPaytypeDas appPaytypeDas;
    @Resource
    private PayAppVo payAppVo;

    public void validateBaseRequest(BaseRequest request) throws ApiException, VerifyException {
        Map requestMap = request.bean2Map();
        StoreEo store = (StoreEo)this.payStoreDas.selectByLogicKey((Object)request.getStoreId());
        if (null == store) {
            logger.error("\u5546\u6237\u4e0d\u5b58\u5728\uff0c\u4e0b\u5355\u5931\u8d25\u3002");
            throw new ApiException("INVALID_STORE_ID", ErrorCode.getErrorMsg((String)"INVALID_STORE_ID"));
        }
        AppEo payapps = (AppEo)this.payAppsDas.selectByLogicKey((Object)request.getAppId());
        if (null == payapps) {
            logger.error("\u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u4e0b\u5355\u5931\u8d25\u3002");
            throw new ApiException("INVALID_APP_ID", ErrorCode.getErrorMsg((String)"INVALID_APP_ID"));
        }
        StringBuffer sbPayType = new StringBuffer();
        StringBuffer sbPayPartner = new StringBuffer();
        if (requestMap.containsKey("payTypeId")) {
            AppPaytypeEo payTypeEo = new AppPaytypeEo();
            payTypeEo.setAppCode(payapps.getCode());
            payTypeEo.setPayType((String)requestMap.get("payTypeId"));
            payTypeEo.setTenantId(payapps.getTenantId());
            payTypeEo.setInstanceId(payapps.getInstanceId());
            List select = this.appPaytypeDas.select((BaseEo)payTypeEo);
            if (select.size() <= 0) {
                logger.error("\u5e94\u7528\u6ca1\u6709\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u6743\u9650\u3002");
                throw new ApiException("INVALID_APP_ID", ErrorCode.getErrorMsg((String)"INVALID_APP_ID"));
            }
            for (AppPaytypeEo pay : select) {
                sbPayType.append(pay.getPayType() + ",");
                sbPayPartner.append(pay.getPartnerCode() + ",");
            }
            if (StringUtils.isBlank((CharSequence)sbPayType.toString()) || !sbPayType.toString().contains((CharSequence)requestMap.get("payTypeId"))) {
                logger.error("\u652f\u4ed8\u65b9\u5f0f\u672a\u6388\u6743");
                throw new ApiException("SERVICE_UNAUTHORIZED", "\u652f\u4ed8\u65b9\u5f0f\u672a\u6388\u6743");
            }
        }
        if (requestMap.containsKey("payPartnerId") && (StringUtils.isBlank((CharSequence)sbPayPartner.toString()) || !sbPayPartner.toString().contains((CharSequence)requestMap.get("payPartnerId")))) {
            logger.error("\u652f\u4ed8\u6e20\u9053\u672a\u6388\u6743");
            throw new ApiException("SERVICE_UNAUTHORIZED", "\u652f\u4ed8\u65b9\u5f0f\u672a\u6388\u6743");
        }
        try {
            request.verifySign(store.getApiSecret());
        }
        catch (VerifyException e) {
            try {
                request.verifySign(this.payAppVo.getApiSecret());
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new VerifyException("\u7b7e\u540d\u4e0d\u4e00\u81f4");
            }
        }
    }
}

