/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.sms;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.sms.SmsCodeAbstractService;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.sms.AquireSmsCodeRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.sms.AquireSmsCodeResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.sms.base.SmsCodeBaseRequest;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.pingan.epay.EPayCapitalGatewayService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="aquireSmsCodeService")
public class AquireSmsCodeServiceImpl
extends SmsCodeAbstractService<AquireSmsCodeRequest> {
    @Resource
    private EPayCapitalGatewayService ePayCapitalGatewayService;

    @Override
    public BaseResponse _execute(AquireSmsCodeRequest request) throws Exception {
        AquireSmsCodeResponse response = new AquireSmsCodeResponse();
        BaseGatewayResult result = null;
        switch (SmsCodeAbstractService.TradeType.getTradeType(request.getVerifyType())) {
            case PAY: {
                PayOrderEo payOrderEo = PayOrderEo.newInstance();
                payOrderEo.setStoreCode(request.getStoreId());
                payOrderEo.setAppCode(request.getAppId());
                payOrderEo.setStatus(OrderStatus.ACCEPT.getStatus());
                PayOrderEo payOrder = (PayOrderEo)this.getOrder((SmsCodeBaseRequest)request, (BaseEo)payOrderEo, (AbstractBaseDas)this.payOrderDas);
                break;
            }
            case MODIFY_MOBILE: {
                break;
            }
            default: {
                EnterpriseOrderEo order = EnterpriseOrderEo.newInstance();
                order.setStoreCode(request.getStoreId());
                order.setAppCode(request.getAppId());
                order.setStatus(OrderStatus.ACCEPT.getStatus());
                EnterpriseOrderEo enterpriseOrder = (EnterpriseOrderEo)this.getOrder((SmsCodeBaseRequest)request, (BaseEo)order, (AbstractBaseDas)this.payEnterpriseOrderDas);
                result = this.ePayCapitalGatewayService.aquireSmsCode((Object)enterpriseOrder);
            }
        }
        this.packageApiResponse((BaseResponse)response, result);
        return response;
    }

    @Override
    public void validate(AquireSmsCodeRequest request) throws Exception {
        if ((request.getVerifyType().intValue() == SmsCodeAbstractService.TradeType.EXTRACT.getType() || request.getVerifyType().intValue() == SmsCodeAbstractService.TradeType.PAY.getType()) && StringUtils.isBlank((CharSequence)request.getStoreOrderId()) && StringUtils.isBlank((CharSequence)request.getTradeId())) {
            throw new ApiException("INVALID_PARAM", "tradeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getVerifyType().intValue() == SmsCodeAbstractService.TradeType.MODIFY_MOBILE.getType() && StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw new ApiException("INVALID_USER_ID", ErrorCode.getErrorMsg((String)"INVALID_USER_ID"));
        }
    }
}

