/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.sms;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.sms.base.SmsCodeBaseRequest;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public abstract class SmsCodeAbstractService<T extends SmsCodeBaseRequest>
extends ApiBaseService<T> {
    @Resource
    protected EnterpriseOrderDas payEnterpriseOrderDas;
    @Resource
    protected PayOrderDas payOrderDas;

    protected Object getOrder(SmsCodeBaseRequest request, BaseEo order, AbstractBaseDas baseDas) throws Exception {
        List payOrderList;
        Object payOrder = null;
        if (StringUtils.isNotBlank((CharSequence)request.getTradeId())) {
            payOrder = baseDas.selectByLogicKey((Object)request.getTradeId());
        }
        if (null == payOrder && null != (payOrderList = baseDas.select(order)) && !payOrderList.isEmpty()) {
            payOrder = payOrderList.get(0);
        }
        if (null == payOrder) {
            throw new ApiException("INVALID_TRADE_ID", ErrorCode.getErrorMsg((String)"INVALID_TRADE_ID"));
        }
        return payOrder;
    }

    protected static enum TradeType {
        MODIFY_MOBILE(2, "\u4fee\u6539\u624b\u673a\u53f7\u7801"),
        PAY(0, "\u652f\u4ed8"),
        EXTRACT(1, "\u63d0\u73b0\u6216\u4f1a\u5458\u652f\u4ed8");

        private int type;
        private String desc;

        private TradeType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public static TradeType getTradeType(int type) {
            for (TradeType tradeType : TradeType.values()) {
                if (tradeType.getType() != type) continue;
                return tradeType;
            }
            return PAY;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

