/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.sms;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.sms.SmsCodeAbstractService;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.EnterOrderType;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.account.VerifyExtractAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.sms.VerifySmsCodeRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.sms.VerifySmsCodeResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.sms.base.SmsCodeBaseRequest;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayServiceFactory;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StoreEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="verifySmsCodeService")
public class VerifySmsCodeServiceImpl
extends SmsCodeAbstractService<VerifySmsCodeRequest> {
    @Resource
    private GatewayServiceFactory gatewayServiceFactory;
    @Resource
    private EnterpriseOrderAttachInfoDas enterpriseOrderAttachinfoDas;
    @Resource
    private ApiBaseService verifyExtractAccountService;

    @Override
    public BaseResponse _execute(VerifySmsCodeRequest request) throws Exception {
        VerifySmsCodeResponse response = new VerifySmsCodeResponse();
        switch (SmsCodeAbstractService.TradeType.getTradeType(request.getVerifyType())) {
            case MODIFY_MOBILE: {
                VerifyExtractAccountRequest codeRequest = new VerifyExtractAccountRequest();
                codeRequest.setStoreId(request.getStoreId());
                codeRequest.setAppId(request.getAppId());
                codeRequest.setUserId(request.getUserId());
                codeRequest.setPtUserId(request.getPtUserId());
                codeRequest.setBankAmount(request.getBankAccount());
                codeRequest.setVerifyCode(request.getVerifyCode());
                StoreEo payStore = (StoreEo)this.payStoreDas.selectByLogicKey((Object)request.getStoreId());
                codeRequest.doEncrypt(payStore.getApiSecret());
                BaseResponse resp = this.verifyExtractAccountService.execute(codeRequest);
                BeanUtils.copyProperties((Object)resp, (Object)response);
                break;
            }
            case PAY: {
                PayOrderEo payOrder = (PayOrderEo)this.getOrder((SmsCodeBaseRequest)request, (BaseEo)PayOrderEo.newInstance(), (AbstractBaseDas)this.payOrderDas);
                GatewayService gatewayService = this.gatewayServiceFactory.createGatewayServiceByTradeId(payOrder.getTradeId());
                payOrder.setRemark(request.getVerifyCode());
                BaseGatewayResult result = gatewayService.createPayTrade((Object)payOrder);
                this.packageApiResponse((BaseResponse)response, result);
                response.setTradeId(payOrder.getTradeId());
                break;
            }
            default: {
                BaseGatewayResult result;
                EnterpriseOrderEo order = (EnterpriseOrderEo)this.getOrder((SmsCodeBaseRequest)request, (BaseEo)EnterpriseOrderEo.newInstance(), (AbstractBaseDas)this.payEnterpriseOrderDas);
                EnterpriseOrderAttachInfoEo exist = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachinfoDas.selectByLogicKey((Object)order.getTradeId());
                exist.setRemark(request.getVerifyCode());
                GatewayService gatewayService = this.gatewayServiceFactory.createGatewayServiceByTradeId(order.getTradeId());
                if (EnterOrderType.EXTRACT.getType().equals(order.getTranType())) {
                    exist.setRemark4("VR_CODE");
                    result = gatewayService.createEnterOrder((Object)order);
                } else {
                    result = gatewayService.createPayTrade((Object)order);
                }
                this.packageApiResponse((BaseResponse)response, result);
                response.setTradeId(order.getTradeId());
            }
        }
        return response;
    }

    @Override
    public void validate(VerifySmsCodeRequest request) throws Exception {
        int tradeType = request.getVerifyType();
        if ((SmsCodeAbstractService.TradeType.PAY.getType() == tradeType || SmsCodeAbstractService.TradeType.EXTRACT.getType() == tradeType) && StringUtils.isBlank((CharSequence)request.getTradeId()) && StringUtils.isBlank((CharSequence)request.getStoreOrderId())) {
            throw new ApiException("TRADE_ID_NOT_EMPTY", ErrorCode.getErrorMsg((String)"TRADE_ID_NOT_EMPTY"));
        }
        if (SmsCodeAbstractService.TradeType.MODIFY_MOBILE.getType() == tradeType && StringUtils.isBlank((CharSequence)request.getUserId())) {
            throw new ApiException("INVALID_PARAM", "\u7528\u6237\u6807\u8bc6userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

