/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create.AbstractCreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.CheckStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.NotifyStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.check.CheckOrderService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PartnerConfigDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.RefundOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

public abstract class AbstractCreateRefundTradeService
extends AbstractCreateTradeService<RefundRequest, RefundResponse, RefundOrderEo> {
    @Resource
    protected RefundOrderDas payRefundOrderDas;
    @Resource
    protected PayOrderDas payOrderDas;
    @Resource
    protected EnterpriseOrderDas payEnterpriseOrderDas;
    @Resource
    protected PartnerConfigDas payPartnerConfigDas;
    @Resource
    private CheckOrderService checkPayRefundOrderService;

    @Override
    public BaseResponse _execute(RefundRequest request) throws Exception {
        RefundOrderEo payRefundOrder = this.packageRefundOrder(request);
        this.parseRefundOrder(payRefundOrder, request);
        GatewayService gatewayService = this.getGatewayService(request);
        this.payRefundOrderDas.insert((BaseEo)payRefundOrder);
        BaseGatewayResult result = gatewayService.createRefundTrade((Object)payRefundOrder);
        RefundResponse response = new RefundResponse();
        response = this.packageResult(response, result);
        response.setRefundId(payRefundOrder.getRefundId());
        return response;
    }

    public abstract void parseRefundOrder(RefundOrderEo var1, RefundRequest var2) throws Exception;

    public abstract GatewayService getGatewayService(RefundRequest var1) throws Exception;

    public abstract BigDecimal getOrderAmt(RefundRequest var1) throws Exception;

    public abstract BigDecimal getTotalRefundAmt(RefundRequest var1) throws Exception;

    @Override
    public void validateRequest(RefundRequest request) throws Exception {
        BigDecimal orderAmt = this.getOrderAmt(request);
        BigDecimal totalRefundAmt = this.getTotalRefundAmt(request);
        if (totalRefundAmt.compareTo(orderAmt) > -1) {
            this.logger.error("\u7d2f\u8ba1\u9000\u6b3e\u91d1\u989d\u5df2\u7ecf\u5927\u4e8e\u8ba2\u5355\u91d1\u989d,\u4e0d\u5141\u8bb8\u9000\u6b3e\uff0c\u7d2f\u8ba1\u9000\u6b3e\u91d1\u989d\uff0ctotalAmt=" + totalRefundAmt.toString() + "\u5f53\u524d\u9700\u8981\u9000\u6b3e\u91d1\u989d\uff0crefundAmt=" + request.getRefundAmt() + "\u8ba2\u5355\u91d1\u989d orderAmt=" + orderAmt);
            throw new ApiException("FORBIDEN_REFUND", "\u7d2f\u8ba1\u9000\u6b3e\u91d1\u989d\u5df2\u7ecf\u5927\u4e8e\u6216\u7b49\u4e8e\u8ba2\u5355\u91d1\u989d");
        }
    }

    @Override
    public List<RefundOrderEo> getOrderList(RefundRequest request) {
        return this.payRefundOrderDas.selectByStoreRefundId(request.getStoreId(), request.getStoreRefundId());
    }

    @Override
    public String getPrimaryKey(RefundOrderEo order) {
        return order.getRefundId();
    }

    private RefundOrderEo packageRefundOrder(RefundRequest request) throws Exception {
        RefundOrderEo refundOrder = RefundOrderEo.newInstance();
        refundOrder.setStoreCode(request.getStoreId());
        refundOrder.setAppCode(request.getAppId());
        refundOrder.setUserId(request.getUserId());
        refundOrder.setPtUserId(request.getPtUserId());
        refundOrder.setUserName(request.getUserName());
        refundOrder.setNotifyUrl(request.getNotifyUrl());
        refundOrder.setStatus(OrderStatus.PROCESS.getStatus());
        refundOrder.setCheckStatus(CheckStatus.PROCESS.getStatus());
        refundOrder.setNotifyStatus(NotifyStatus.NONE.getStatus());
        refundOrder.setBody(request.getAppName());
        refundOrder.setMobile(request.getMobile());
        refundOrder.setAttachInfo(request.getAttachInfo());
        refundOrder.setTradeId(request.getTradeId());
        refundOrder.setAmount(request.getRefundAmt());
        refundOrder.setStoreRefundId(request.getStoreRefundId());
        refundOrder.setBody(request.getReason());
        refundOrder.setRefundId(this.tradeIdGenService.genTradeId(TradeIdType.REFUND));
        refundOrder.setStatus(OrderStatus.PROCESS.getStatus());
        refundOrder.setCheckStatus(CheckStatus.PROCESS.getStatus());
        refundOrder.setRefundTime(new Date());
        refundOrder.setIp(request.getIp());
        refundOrder.setImei(request.getImei());
        refundOrder.setImsi(request.getImsi());
        refundOrder.setMac(request.getMac());
        refundOrder.setPayRequest(request.toString());
        refundOrder.setAttachInfo(request.getAttachInfo());
        refundOrder.setAccountId(request.getAccountId());
        return refundOrder;
    }

    @Override
    public String checkAndGetOrderStatus(String refundId) throws Exception {
        RefundOrderEo payRefundOrder = (RefundOrderEo)this.payRefundOrderDas.selectByLogicKey((Object)refundId);
        CheckResult checkResult = this.checkPayRefundOrderService.checkOrder(payRefundOrder.getRefundId());
        if (checkResult.getResult() != 1) {
            this.logger.error("\u6e20\u9053\u6838\u5bf9\u4e0d\u4e00\u81f4\uff0c\u540c\u4e00\u4e2astoreOrderId\u4e0d\u5141\u8bb8\u521b\u5efa\u652f\u4ed8\u8ba2\u5355");
            throw new ApiException("ORDER_EXISTS", "\u8ba2\u5355\u5df2\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u518d\u91cd\u8bd5");
        }
        return ((RefundOrderEo)this.payRefundOrderDas.selectByLogicKey((Object)refundId)).getStatus();
    }
}

