/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.Constant;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.ClosePtOrderType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.SubmitType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.CheckStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.base.TradeBaseRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.base.TradeBaseResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayFactory;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayServiceFactory;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.TradeIdGenService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AppDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.AppEo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

public abstract class AbstractCreateTradeService<M extends TradeBaseRequest, R extends TradeBaseResponse, T>
extends ApiBaseService<M> {
    private static final String HTTPS_URL_PREFIX = "https://";
    private static final String HTTP_URL_PREFIX = "http://";
    @Resource
    protected TradeIdGenService tradeIdGenService;
    @Resource
    protected GatewayServiceFactory gatewayServiceFactory;
    @Resource
    protected GatewayFactory gatewayFactory;
    @Resource
    protected PartnerConfigManager partnerConfigManager;
    @Resource
    private AppDas payAppsDas;

    protected void validateSameStoreOrderId(M request, String tradeId, String status, String checkStatus) throws Exception {
        AppEo payApps = (AppEo)this.payAppsDas.selectByLogicKey((Object)request.getAppId());
        if (!OrderStatus.isFinishStatus((String)status)) {
            status = this.checkAndGetOrderStatus(tradeId);
            if (OrderStatus.isSuccStatus((String)status)) {
                throw new ApiException("ORDER_SUCCESS", ErrorCode.getErrorMsg((String)"ORDER_SUCCESS"));
            }
            if (!OrderStatus.isFinishStatus((String)status)) {
                if (ClosePtOrderType.AUTO_CLOSE.getType().equals(payApps.getIsAutoClosePtOrder()) && request instanceof PayRequest) {
                    this.closeOrder(tradeId);
                }
                if (SubmitType.DISALLOW_RESUBMIT.getType().equals(payApps.getIsAllowResubmit())) {
                    throw new ApiException("ORDER_EXISTS", ErrorCode.getErrorMsg((String)"ORDER_EXISTS"));
                }
                this.logger.warn("\u539f\u8ba2\u5355\u672a\u5173\u95ed\uff0c \u751f\u6210\u65b0\u7684\u4ea4\u6613\u8ba2\u5355");
            }
        } else if (!CheckStatus.isSuccStatus((String)checkStatus)) {
            this.logger.info("\u8ba2\u5355\u672a\u6838\u5b9e\uff0c\u9700\u8981\u8fdb\u884c\u8ba2\u5355\u6838\u5bf9\u3002");
            if (!OrderStatus.isFailStatus((String)this.checkAndGetOrderStatus(tradeId))) {
                if (SubmitType.DISALLOW_RESUBMIT.getType().equals(payApps.getIsAllowResubmit())) {
                    throw new ApiException("ORDER_EXISTS", ErrorCode.getErrorMsg((String)"ORDER_EXISTS"));
                }
                this.logger.warn("\u539f\u8ba2\u5355\u672a\u5173\u95ed\uff0c \u751f\u6210\u65b0\u7684\u4ea4\u6613\u8ba2\u5355");
            }
        }
    }

    @Override
    public void validate(M request) throws Exception {
        this.validateUrl(request.getNotifyUrl(), "INVALID_NOTIFY_URL");
        this.validateRequest(request);
        this.validateSameStoreOrderId(request);
    }

    protected void validateUrl(String url, String errorCode) throws Exception {
        if (!url.startsWith(HTTPS_URL_PREFIX) && !url.startsWith(HTTP_URL_PREFIX)) {
            this.logger.error("URL\u5730\u5740\u4e0d\u5408\u6cd5\uff0curl:" + url);
            throw new ApiException(errorCode, ErrorCode.getErrorMsg((String)errorCode));
        }
    }

    public void validateSameStoreOrderId(M request) throws Exception {
        JSONObject jsonObject;
        AppEo payApps = (AppEo)this.payAppsDas.selectByLogicKey((Object)request.getAppId());
        List<T> orders = this.getOrderList(request);
        ArrayList<T> checkOrders = new ArrayList<T>();
        for (Object order : orders) {
            jsonObject = JSONObject.parseObject((String)JSON.toJSONString(order));
            if (OrderStatus.isSuccStatus((String)jsonObject.getString("status"))) {
                throw new ApiException("ORDER_SUCCESS", ErrorCode.getErrorMsg((String)"ORDER_SUCCESS"));
            }
            if (Constant.IS_CLOSE_ORDER.equals(payApps.getIsCloseOrder()) && SubmitType.ALLOW_RESUBMIT.getType().equals(payApps.getIsAllowResubmit())) continue;
            checkOrders.add(order);
        }
        for (Object order : checkOrders) {
            jsonObject = JSONObject.parseObject((String)JSON.toJSONString(order));
            this.validateSameStoreOrderId(request, this.getPrimaryKey(order), jsonObject.getString("status"), jsonObject.getString("checkStatus"));
        }
    }

    public BaseGatewayResult closeOrder(String tradeId) throws Exception {
        return BaseGatewayResult.SUCCESS;
    }

    public abstract void validateRequest(M var1) throws Exception;

    public abstract List<T> getOrderList(M var1);

    public abstract String getPrimaryKey(T var1);

    public abstract String checkAndGetOrderStatus(String var1) throws Exception;

    protected R packageResult(R response, BaseGatewayResult result) {
        if (result.isDoneSucc()) {
            if (result.isPaySuccess()) {
                response.setResult("SUCCESS");
            } else {
                response.setResult("ACCEPT");
                if (!result.getData().isEmpty()) {
                    response.setData((Object)result.getData());
                }
            }
        } else {
            response.setFailCode(result.getErrorCode());
            response.setFailMsg(result.getErrorMsg());
            response.setResult("FAIL");
        }
        return response;
    }
}

