/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.CloseRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.CloseResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayServiceFactory;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="closePayOrderTradeService")
public class ClosePayOrderTradeServiceImpl
extends ApiBaseService<CloseRequest> {
    @Resource
    private PayOrderDas payOrderDas;
    @Resource
    private GatewayServiceFactory gatewayServiceFactory;

    @Override
    public BaseResponse _execute(CloseRequest request) throws Exception {
        CloseResponse response = new CloseResponse();
        PayOrderEo payOrder = this.payOrderDas.selectOrder(request.getTradeId(), request.getStoreId(), request.getStoreOrderId());
        if (null == payOrder) {
            throw new ApiException("INVALID_PARAM", "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        GatewayService service = this.gatewayServiceFactory.createGatewayServiceByTradeId(payOrder.getTradeId());
        BaseGatewayResult result = service.closePayTrade((Object)payOrder);
        response.setResult(result.isDoneSucc() ? "SUCCESS" : "FAIL");
        return response;
    }

    @Override
    public void validate(CloseRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getTradeId()) && StringUtils.isBlank((CharSequence)request.getStoreId())) {
            throw new ApiException("INVALID_PARAM", "tradeId \u548c storeOrderId \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

