/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create.AbstractCreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.check.CheckOrderService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import java.util.List;
import javax.annotation.Resource;

public abstract class CreateEnterOrderTradeAbstract
extends AbstractCreateTradeService<PayEnterRequest, PayEnterResponse, EnterpriseOrderEo> {
    @Resource
    protected EnterpriseOrderDas payEnterpriseOrderDas;
    @Resource
    protected EnterpriseOrderAttachInfoDas enterpriseOrderAttachinfoDas;
    @Resource
    protected CheckOrderService checkPayEnterOrderService;

    @Override
    public String checkAndGetOrderStatus(String tradeId) throws Exception {
        EnterpriseOrderEo order = (EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId);
        CheckResult checkResult = this.checkPayEnterOrderService.checkOrder(order.getTradeId());
        if (checkResult.getResult() != 1) {
            this.logger.error("\u6e20\u9053\u6838\u5bf9\u4e0d\u4e00\u81f4\uff0c\u540c\u4e00\u4e2astoreOrderId\u4e0d\u5141\u8bb8\u521b\u5efa\u4f01\u4e1a\u8ba2\u5355");
            throw new ApiException("ORDER_EXISTS", "\u8ba2\u5355\u5df2\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u518d\u91cd\u8bd5");
        }
        return ((EnterpriseOrderEo)this.payEnterpriseOrderDas.selectByLogicKey((Object)tradeId)).getStatus();
    }

    @Override
    public BaseResponse _execute(PayEnterRequest request) throws Exception {
        EnterpriseOrderEo order = this.packageOrder(request);
        List<PayEnterResponse.PayResult> payResults = this.saveSubOrder(request, order);
        GatewayService gatewayService = this.gatewayServiceFactory.createGatewayService(order.getGatewayCode());
        BaseGatewayResult result = gatewayService.createEnterOrder((Object)order);
        PayEnterResponse response = new PayEnterResponse();
        response = this.packageResult(response, result);
        if (result.isDoneSucc()) {
            response.setTradeId(order.getTradeId());
            response.setMobile(request.getMobile());
            response.setPayResult(payResults);
        }
        return response;
    }

    @Override
    public void validateRequest(PayEnterRequest request) throws Exception {
        this.validateRequestOrder(request);
    }

    @Override
    public List<EnterpriseOrderEo> getOrderList(PayEnterRequest request) {
        return this.payEnterpriseOrderDas.selectByStoreOrderId(request.getStoreId(), request.getStoreOrderId());
    }

    @Override
    public String getPrimaryKey(EnterpriseOrderEo order) {
        return order.getTradeId();
    }

    public abstract EnterpriseOrderEo packageOrder(PayEnterRequest var1) throws Exception;

    public abstract void validateRequestOrder(PayEnterRequest var1) throws Exception;

    public abstract List<PayEnterResponse.PayResult> saveSubOrder(PayEnterRequest var1, EnterpriseOrderEo var2) throws Exception;
}

