/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create.CreateEnterOrderTradeAbstract;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.EnterOrderType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.PayTypes;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.CheckStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.NotifyStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterResponse;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.GatewayEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="createEnterOrderTradeService")
public class CreateEnterOrderTradeServiceImpl
extends CreateEnterOrderTradeAbstract {
    protected static Map<String, EnterOrderType> orderTypeMapper = new HashMap<String, EnterOrderType>();

    @Override
    @Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
    public EnterpriseOrderEo packageOrder(PayEnterRequest request) throws Exception {
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        GatewayEo payGateway = this.gatewayFactory.fetchGateway(request.getPayTypeId(), partnerConfig.getPartnerCode());
        EnterpriseOrderEo order = EnterpriseOrderEo.newInstance();
        order.setStoreCode(request.getStoreId());
        order.setAppCode(request.getAppId());
        order.setUserId(request.getUserId());
        order.setPtUserId(request.getPtUserId());
        order.setUserName(request.getUserName());
        order.setNotifyUrl(request.getNotifyUrl());
        order.setStatus(OrderStatus.PROCESS.getStatus());
        order.setCheckStatus(CheckStatus.PROCESS.getStatus());
        order.setNotifyStatus(NotifyStatus.NONE.getStatus());
        order.setBody(request.getAppName());
        order.setMobile(request.getMobile());
        order.setAttachInfo(request.getAttachInfo());
        order.setTradeId(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        order.setStoreOrderId(request.getStoreOrderId());
        order.setAmount(request.getOrderAmt());
        order.setFee(request.getFeeAmt());
        order.setPayType(request.getPayTypeId());
        order.setOrderTime(new Date());
        order.setTranType(orderTypeMapper.get(request.getPayTypeId()).getType());
        order.setGatewayCode(payGateway.getCode());
        order.setPartnerConfigCode(partnerConfig.getCode());
        order.setBankCode(request.getBankCode());
        order.setUserName(request.getUserName());
        order.setPartnerAccount(request.getBankAccount());
        order.setPtUserId(request.getPtUserId());
        order.setAccountId(request.getAccountId());
        this.payEnterpriseOrderDas.insert((BaseEo)order);
        EnterpriseOrderAttachInfoEo attachInfoEo = EnterpriseOrderAttachInfoEo.newInstance();
        attachInfoEo.setTradeId(order.getTradeId());
        attachInfoEo.setImei(request.getImei());
        attachInfoEo.setIp(request.getIp());
        attachInfoEo.setImsi(request.getImsi());
        attachInfoEo.setMac(request.getMac());
        attachInfoEo.setRequestInfo(request.toString());
        this.parseCapitalOrder(request, attachInfoEo);
        this.enterpriseOrderAttachinfoDas.insert((BaseEo)attachInfoEo);
        return order;
    }

    @Override
    public void validateRequestOrder(PayEnterRequest request) throws Exception {
        if ((orderTypeMapper.get(request.getPayTypeId()) == EnterOrderType.TRANSFER || orderTypeMapper.get(request.getPayTypeId()) == EnterOrderType.GATHERING) && (StringUtils.isBlank((CharSequence)request.getUserName()) || StringUtils.isBlank((CharSequence)request.getBankAccount()))) {
            throw new ApiException("INVALID_PARAM", "\u4ee3\u4ed8\u6216\u4ee3\u6536\u5fc5\u987b\u4f20\u9012accountName \u548c bankAccount");
        }
        if (orderTypeMapper.get(request.getPayTypeId()) == EnterOrderType.EXTRACT && null == request.getBankAccount()) {
            throw new ApiException("INVALID_PARAM", "payTypeId\u4e3a401\u65f6\u5019\uff0c\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void parseCapitalOrder(PayEnterRequest request, EnterpriseOrderAttachInfoEo attachInfoEo) throws Exception {
        Object[] capitalTypes = new EnterOrderType[]{EnterOrderType.ALLOT, EnterOrderType.EXTRACT, EnterOrderType.PAY, EnterOrderType.RECORD};
        if (ArrayUtils.contains((Object[])capitalTypes, (Object)orderTypeMapper.get(request.getPayTypeId())) && EnterOrderType.EXTRACT.equals((Object)orderTypeMapper.get(request.getPayTypeId()))) {
            EnterpriseOrderAttachInfoEo attachinfoEo = EnterpriseOrderAttachInfoEo.newInstance();
            attachinfoEo.setTradeId(attachInfoEo.getTradeId());
            attachinfoEo.setRemark3(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
            attachinfoEo.setRemark4("AQ_SMS");
        }
    }

    @Override
    public List<PayEnterResponse.PayResult> saveSubOrder(PayEnterRequest request, EnterpriseOrderEo parentOrder) throws Exception {
        ArrayList<PayEnterResponse.PayResult> payResults = new ArrayList<PayEnterResponse.PayResult>();
        List payInfos = request.getPayInfo();
        if (CollectionUtils.isNotEmpty((Collection)payInfos)) {
            for (PayEnterRequest.PayInfo payInfo : payInfos) {
                EnterpriseOrderEo subOrder = EnterpriseOrderEo.newInstance();
                BeanUtils.copyProperties((Object)parentOrder, (Object)subOrder);
                subOrder.setTradeId(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
                subOrder.setParentTradeId(parentOrder.getTradeId());
                subOrder.setStoreOrderId(payInfo.getStoreOrderId());
                subOrder.setAmount(payInfo.getOrderAmt());
                subOrder.setFee(payInfo.getFeeAmt());
                this.payEnterpriseOrderDas.insert((BaseEo)subOrder);
                EnterpriseOrderAttachInfoEo attachinfoEo = EnterpriseOrderAttachInfoEo.newInstance();
                attachinfoEo.setTradeId(subOrder.getTradeId());
                attachinfoEo.setRemark1(payInfo.getUserId());
                attachinfoEo.setRemark2(payInfo.getPtUserId());
                attachinfoEo.setRemark4(payInfo.getUserName());
                this.enterpriseOrderAttachinfoDas.insert((BaseEo)attachinfoEo);
                PayEnterResponse.PayResult payResult = new PayEnterResponse.PayResult();
                payResult.setStoreOrderId(request.getStoreOrderId());
                payResult.setTradeId(subOrder.getTradeId());
                payResult.setPtUserId(payInfo.getPtUserId());
                payResults.add(payResult);
            }
            if (CollectionUtils.isNotEmpty((Collection)request.getPayInfo()) && request.getPayInfo().size() > 1) {
                EnterpriseOrderAttachInfoEo attachinfoEo = EnterpriseOrderAttachInfoEo.newInstance();
                attachinfoEo.setTradeId(parentOrder.getTradeId());
                attachinfoEo.setRemark3("PARENT_ORDER");
                this.enterpriseOrderAttachinfoDas.insert((BaseEo)attachinfoEo);
            }
        }
        return payResults;
    }

    static {
        orderTypeMapper.put(PayTypes.TRANSFER.getPayTypeId(), EnterOrderType.TRANSFER);
        orderTypeMapper.put(PayTypes.TRANSFERS.getPayTypeId(), EnterOrderType.TRANSFER);
        orderTypeMapper.put(PayTypes.GATHERING.getPayTypeId(), EnterOrderType.GATHERING);
        orderTypeMapper.put(PayTypes.GATHERINGS.getPayTypeId(), EnterOrderType.GATHERING);
        orderTypeMapper.put(PayTypes.ALLOT.getPayTypeId(), EnterOrderType.RECORD);
        orderTypeMapper.put(PayTypes.EXTRACT.getPayTypeId(), EnterOrderType.EXTRACT);
        orderTypeMapper.put(PayTypes.PAY.getPayTypeId(), EnterOrderType.PAY);
        orderTypeMapper.put(PayTypes.ALLOT_PAY.getPayTypeId(), EnterOrderType.ALLOT);
    }
}

