/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create.AbstractCreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.EnterOrderType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.CheckStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.NotifyStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.EnterpriseTransferRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.EnterpriseTransferResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.check.CheckOrderService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.GatewayEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="createEnterpriseTransferOrderService")
public class CreateEnterpriseTransferOrderServiceImpl
extends AbstractCreateTradeService<EnterpriseTransferRequest, EnterpriseTransferResponse, EnterpriseOrderEo> {
    @Resource
    private EnterpriseOrderDas enterpriseOrderDas;
    @Resource
    private CheckOrderService checkPayOrderService;

    @Override
    public void validateRequest(EnterpriseTransferRequest request) throws Exception {
    }

    @Override
    public List<EnterpriseOrderEo> getOrderList(EnterpriseTransferRequest request) {
        return this.enterpriseOrderDas.selectByStoreOrderId(request.getStoreId(), request.getStoreOrderId());
    }

    @Override
    public String getPrimaryKey(EnterpriseOrderEo order) {
        return order.getTradeId();
    }

    @Override
    public String checkAndGetOrderStatus(String tradeId) throws Exception {
        EnterpriseOrderEo enterpriseOrder = (EnterpriseOrderEo)this.enterpriseOrderDas.selectByLogicKey((Object)tradeId);
        CheckResult checkResult = this.checkPayOrderService.checkOrder(enterpriseOrder.getTradeId());
        if (checkResult.getResult() != 1) {
            this.logger.error("\u6e20\u9053\u6838\u5bf9\u4e0d\u4e00\u81f4");
            return OrderStatus.ACCEPT.getStatus();
        }
        return ((EnterpriseOrderEo)this.enterpriseOrderDas.selectByLogicKey((Object)tradeId)).getStatus();
    }

    @Override
    public BaseResponse _execute(EnterpriseTransferRequest request) throws Exception {
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        GatewayEo payGateway = this.gatewayFactory.fetchGateway(request.getPayTypeId(), partnerConfig.getPartnerCode());
        EnterpriseOrderEo order = this.packEnterpriseTransferOrder(request, partnerConfig, payGateway);
        GatewayService gatewayService = this.gatewayServiceFactory.createGatewayService(order.getGatewayCode());
        BaseGatewayResult result = gatewayService.createEnterpriseTransferOrder((Object)order);
        EnterpriseTransferResponse response = new EnterpriseTransferResponse();
        response = this.packageResult(response, result);
        response.setTradeId(order.getTradeId());
        response.setStoreOrderId(order.getStoreOrderId());
        response.setData((Object)JSON.toJSONString((Object)result.getData()));
        return response;
    }

    private EnterpriseOrderEo packEnterpriseTransferOrder(EnterpriseTransferRequest request, PartnerConfigEo partnerConfig, GatewayEo payGateway) throws Exception {
        EnterpriseOrderEo enterpriseOrderEo = EnterpriseOrderEo.newInstance();
        enterpriseOrderEo.setStoreCode(request.getStoreId());
        enterpriseOrderEo.setAppCode(request.getAppId());
        enterpriseOrderEo.setUserId(request.getUserId());
        enterpriseOrderEo.setPtUserId(request.getPtUserId());
        enterpriseOrderEo.setNotifyUrl(request.getNotifyUrl());
        enterpriseOrderEo.setStatus(OrderStatus.PROCESS.getStatus());
        enterpriseOrderEo.setCheckStatus(CheckStatus.PROCESS.getStatus());
        enterpriseOrderEo.setNotifyStatus(NotifyStatus.NONE.getStatus());
        enterpriseOrderEo.setBody(request.getAppName());
        enterpriseOrderEo.setMobile(request.getMobile());
        enterpriseOrderEo.setAttachInfo(request.getAttachInfo());
        enterpriseOrderEo.setTradeId(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        enterpriseOrderEo.setStoreOrderId(request.getStoreOrderId());
        enterpriseOrderEo.setAmount(request.getOrderAmt());
        enterpriseOrderEo.setFee(request.getFeeAmt());
        enterpriseOrderEo.setPayType(request.getPayTypeId());
        Date now = new Date();
        enterpriseOrderEo.setOrderTime(now);
        enterpriseOrderEo.setAcceptTime(now);
        enterpriseOrderEo.setTranType(EnterOrderType.TRANSFER.getType());
        enterpriseOrderEo.setGatewayCode(payGateway.getCode());
        enterpriseOrderEo.setPartnerConfigCode(partnerConfig.getCode());
        enterpriseOrderEo.setBankCode(request.getBankCode());
        enterpriseOrderEo.setBankAccount(request.getBankAccount());
        enterpriseOrderEo.setUserName(request.getUserName());
        enterpriseOrderEo.setPartnerAccount(request.getBankAccount());
        enterpriseOrderEo.setAccountId(request.getAccountId());
        enterpriseOrderEo.setPayee(request.getOpenid());
        enterpriseOrderEo.setRemark(request.getRemark());
        enterpriseOrderEo.setInstanceId(request.getInstanceId());
        enterpriseOrderEo.setTenantId(request.getTenantId());
        this.enterpriseOrderDas.insert((BaseEo)enterpriseOrderEo);
        return enterpriseOrderEo;
    }
}

