/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create.CreateEnterOrderTradeAbstract;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.EnterOrderType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.CheckStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.NotifyStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayEnterResponse;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.GatewayEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="createNewEnterOrderTradeService")
public class CreateNewEnterOrderTradeServiceImpl
extends CreateEnterOrderTradeAbstract {
    @Override
    @Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
    public EnterpriseOrderEo packageOrder(PayEnterRequest request) throws Exception {
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        GatewayEo payGateway = this.gatewayFactory.fetchGateway(request.getPayTypeId(), partnerConfig.getPartnerCode());
        if (StringUtils.isBlank((CharSequence)partnerConfig.getEnterType())) {
            throw new Exception(request.getPayTypeId() + "\u4e0d\u662f\u4f01\u4e1a\u652f\u4ed8\uff01");
        }
        EnterpriseOrderEo order = EnterpriseOrderEo.newInstance();
        order.setStoreCode(request.getStoreId());
        order.setAppCode(request.getAppId());
        order.setUserId(request.getUserId());
        order.setPtUserId(request.getPtUserId());
        order.setUserName(request.getUserName());
        order.setNotifyUrl(request.getNotifyUrl());
        order.setStatus(OrderStatus.PROCESS.getStatus());
        order.setCheckStatus(CheckStatus.PROCESS.getStatus());
        order.setNotifyStatus(NotifyStatus.NONE.getStatus());
        order.setBody(request.getAppName());
        order.setMobile(request.getMobile());
        order.setAttachInfo(request.getAttachInfo());
        order.setStoreOrderId(request.getStoreOrderId());
        order.setFee(request.getFeeAmt());
        order.setPayType(request.getPayTypeId());
        order.setOrderTime(new Date());
        order.setTranType(partnerConfig.getEnterType());
        order.setGatewayCode(payGateway.getCode());
        order.setPartnerConfigCode(partnerConfig.getCode());
        order.setBankCode(request.getBankCode());
        order.setUserName(request.getUserName());
        order.setPartnerAccount(request.getBankAccount());
        order.setPtUserId(request.getPtUserId());
        order.setAmount(request.getOrderAmt());
        order.setPartnerCode(payGateway.getPartnerCode());
        order.setPartnerAccount(request.getPartnerAccount());
        order.setTradeId(request.getRemark());
        order.setAccountId(request.getAccountId());
        if (partnerConfig.getPartnerCode().equals("201")) {
            order.setTradeId(this.tradeIdGenService.genTradeId());
        } else {
            order.setTradeId(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getPayInfo())) {
            if (partnerConfig.getPartnerCode().equals("201")) {
                order.setParentTradeId(this.tradeIdGenService.genTradeId());
            } else {
                order.setParentTradeId(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
            }
            order.setAmount(new BigDecimal(0));
            order.setTradeId(order.getParentTradeId());
        } else {
            EnterpriseOrderAttachInfoEo attachInfoEo = EnterpriseOrderAttachInfoEo.newInstance();
            attachInfoEo.setTradeId(order.getTradeId());
            attachInfoEo.setImei(request.getImei());
            attachInfoEo.setIp(request.getIp());
            attachInfoEo.setImsi(request.getImsi());
            attachInfoEo.setMac(request.getMac());
            attachInfoEo.setRequestInfo(request.toString());
            this.parseCapitalOrder(request, attachInfoEo);
            this.enterpriseOrderAttachinfoDas.insert((BaseEo)attachInfoEo);
        }
        this.payEnterpriseOrderDas.insert((BaseEo)order);
        return order;
    }

    @Override
    public void validateRequestOrder(PayEnterRequest request) throws Exception {
    }

    protected void parseCapitalOrder(PayEnterRequest request, EnterpriseOrderAttachInfoEo attachInfoEo) throws Exception {
        Object[] capitalTypes = new EnterOrderType[]{EnterOrderType.ALLOT, EnterOrderType.EXTRACT, EnterOrderType.PAY, EnterOrderType.RECORD};
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        if (ArrayUtils.contains((Object[])capitalTypes, (Object)partnerConfig.getEnterType()) && EnterOrderType.EXTRACT.equals((Object)partnerConfig.getEnterType())) {
            EnterpriseOrderAttachInfoEo attachinfoEo = EnterpriseOrderAttachInfoEo.newInstance();
            attachinfoEo.setTradeId(attachInfoEo.getTradeId());
            attachinfoEo.setRemark3(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
            attachinfoEo.setRemark4("AQ_SMS");
        }
    }

    @Override
    public List<PayEnterResponse.PayResult> saveSubOrder(PayEnterRequest request, EnterpriseOrderEo parentOrder) throws Exception {
        ArrayList<PayEnterResponse.PayResult> payResults = new ArrayList<PayEnterResponse.PayResult>();
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        List payInfos = request.getPayInfo();
        if (CollectionUtils.isNotEmpty((Collection)payInfos)) {
            for (PayEnterRequest.PayInfo payInfo : payInfos) {
                EnterpriseOrderEo subOrder = EnterpriseOrderEo.newInstance();
                BeanUtils.copyProperties((Object)parentOrder, (Object)subOrder);
                subOrder.setId(null);
                if (partnerConfig.getPartnerCode().equals("201")) {
                    subOrder.setTradeId(this.tradeIdGenService.genTradeId());
                } else {
                    subOrder.setTradeId(this.tradeIdGenService.genTradeId(TradeIdType.ENTERTRADE));
                }
                subOrder.setParentTradeId(parentOrder.getParentTradeId());
                if (!StringUtils.isBlank((CharSequence)payInfo.getBackUrl())) {
                    subOrder.setCallbackUrl(payInfo.getBackUrl());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getNotifyUrl())) {
                    subOrder.setNotifyUrl(payInfo.getNotifyUrl());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getTerminal())) {
                    subOrder.setTerminal(payInfo.getTerminal());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getAccountId())) {
                    subOrder.setAccountId(payInfo.getAccountId());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getBindId())) {
                    subOrder.setBindId(payInfo.getBindId());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getStoreOrderId())) {
                    subOrder.setStoreOrderId(payInfo.getStoreOrderId());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getPtUserId())) {
                    subOrder.setPtUserId(payInfo.getPtUserId());
                }
                if (payInfo.getOrderAmt() != null) {
                    subOrder.setAmount(payInfo.getOrderAmt());
                }
                if (payInfo.getFeeAmt() != null) {
                    subOrder.setFee(payInfo.getFeeAmt());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getBankAccount())) {
                    subOrder.setBankAccount(payInfo.getBankAccount());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getUserId())) {
                    subOrder.setUserId(payInfo.getUserId());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getRemark())) {
                    subOrder.setRemark(payInfo.getRemark());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getBankCode())) {
                    subOrder.setBankCode(payInfo.getBankCode());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getBankType())) {
                    subOrder.setBankType(payInfo.getBankType());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getAttachInfo())) {
                    subOrder.setAttachInfo(payInfo.getAttachInfo());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getUserName())) {
                    subOrder.setUserName(payInfo.getUserName());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getMobile())) {
                    subOrder.setMobile(payInfo.getMobile());
                }
                this.payEnterpriseOrderDas.insert((BaseEo)subOrder);
                EnterpriseOrderAttachInfoEo attachinfoEo = EnterpriseOrderAttachInfoEo.newInstance();
                attachinfoEo.setTradeId(subOrder.getTradeId());
                attachinfoEo.setRemark1(payInfo.getUserId());
                attachinfoEo.setRemark4(payInfo.getUserName());
                attachinfoEo.setRemark3(parentOrder.getParentTradeId());
                attachinfoEo.setImei(request.getImei());
                attachinfoEo.setIp(request.getIp());
                attachinfoEo.setImsi(request.getImsi());
                attachinfoEo.setMac(request.getMac());
                this.enterpriseOrderAttachinfoDas.insert((BaseEo)attachinfoEo);
                PayEnterResponse.PayResult payResult = new PayEnterResponse.PayResult();
                payResult.setStoreOrderId(request.getStoreOrderId());
                payResult.setTradeId(subOrder.getTradeId());
                payResults.add(payResult);
            }
            if (CollectionUtils.isNotEmpty((Collection)request.getPayInfo()) && request.getPayInfo().size() >= 1) {
                EnterpriseOrderAttachInfoEo attachinfoEo = EnterpriseOrderAttachInfoEo.newInstance();
                attachinfoEo.setTradeId(parentOrder.getParentTradeId());
                attachinfoEo.setRemark3("PARENT_ORDER");
                attachinfoEo.setImei(request.getImei());
                attachinfoEo.setIp(request.getIp());
                attachinfoEo.setImsi(request.getImsi());
                attachinfoEo.setMac(request.getMac());
                attachinfoEo.setRequestInfo(request.toString());
                this.enterpriseOrderAttachinfoDas.insert((BaseEo)attachinfoEo);
            }
        }
        return payResults;
    }
}

