/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create.AbstractCreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.constant.Constant;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.CheckStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.NotifyStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.TradeIdGenService;
import com.dtyunxi.yundt.cube.center.payment.service.trade.check.CheckOrderService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.GatewayEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="createPayOrderTradeService")
public class CreatePayOrderTradeServiceImpl
extends AbstractCreateTradeService<PayRequest, PayResponse, PayOrderEo> {
    @Resource
    private PayOrderDas payOrderDas;
    @Resource
    private PayOrderAttachInfoDas payOrderAttachInfoDas;
    @Resource
    private CheckOrderService checkPayOrderService;
    @Resource
    private TradeIdGenService tradeIdGenService;

    @Override
    public BaseResponse _execute(PayRequest request) throws Exception {
        PayResponse response = new PayResponse();
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getStoreId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        GatewayEo payGateway = this.gatewayFactory.fetchGateway(request.getPayTypeId(), partnerConfig.getPartnerCode());
        PayOrderEo order = this.packagePayOrder(request, partnerConfig, payGateway);
        List<PayResponse.PayResult> payResults = this.saveSubOrder(request, order, payGateway);
        GatewayService gatewayService = this.gatewayServiceFactory.createGatewayService(order.getGatewayCode());
        BaseGatewayResult result = gatewayService.createPayTrade((Object)order);
        response = this.packageResult(response, result);
        response.setTradeId(order.getTradeId());
        response.setPayResult(payResults);
        return response;
    }

    @Override
    public BaseGatewayResult closeOrder(String tradeId) throws Exception {
        GatewayService gatewayService = this.gatewayServiceFactory.createGatewayServiceByTradeId(tradeId);
        PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId);
        return gatewayService.closePayTrade((Object)payOrder);
    }

    @Override
    public void validateRequest(PayRequest request) throws Exception {
        if (new BigDecimal("999999.99").compareTo(request.getOrderAmt()) < -1) {
            throw new ApiException("INVALID_ORDER_AMT", "\u8ba2\u5355\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7999999.99");
        }
    }

    @Override
    public List<PayOrderEo> getOrderList(PayRequest request) {
        return this.payOrderDas.selectByStoreOrderId(request.getStoreId(), request.getStoreOrderId());
    }

    @Override
    public String getPrimaryKey(PayOrderEo order) {
        return order.getTradeId();
    }

    private PayOrderEo packagePayOrder(PayRequest request, PartnerConfigEo partnerConfig, GatewayEo payGateway) throws Exception {
        PayOrderEo payOrder = PayOrderEo.newInstance();
        payOrder = this.payOrderDas.selectByStoreOrderIdAndGateway(request.getStoreId(), request.getStoreOrderId(), payGateway.getCode());
        if (null != payOrder) {
            return payOrder;
        }
        payOrder = PayOrderEo.newInstance();
        payOrder.setStoreCode(request.getStoreId());
        payOrder.setAppCode(request.getAppId());
        payOrder.setUserId(request.getUserId());
        payOrder.setPtUserId(request.getPtUserId());
        payOrder.setUserName(request.getUserName());
        payOrder.setNotifyUrl(request.getNotifyUrl());
        payOrder.setStatus(OrderStatus.PROCESS.getStatus());
        payOrder.setCheckStatus(CheckStatus.PROCESS.getStatus());
        payOrder.setNotifyStatus(NotifyStatus.NONE.getStatus());
        payOrder.setBody(request.getAppName());
        payOrder.setMobile(request.getMobile());
        payOrder.setAttachInfo(request.getAttachInfo());
        payOrder.setAmount(request.getOrderAmt());
        payOrder.setStoreOrderId(request.getStoreOrderId());
        payOrder.setPayType(request.getPayTypeId());
        payOrder.setStatus(OrderStatus.PROCESS.getStatus());
        payOrder.setCheckStatus(CheckStatus.PROCESS.getStatus());
        payOrder.setOrderTime(DateUtils.ceiling((Date)new Date(), (int)13));
        payOrder.setTradeId(this.tradeIdGenService.genTradeId(TradeIdType.PAY));
        payOrder.setGatewayCode(payGateway.getCode());
        payOrder.setPartnerConfigCode(partnerConfig.getCode());
        payOrder.setCallbackUrl(request.getBackUrl());
        payOrder.setRemark(request.getRemark());
        payOrder.setGwStatus(OrderStatus.PROCESS.getStatus());
        payOrder.setFee(request.getFeeAmt());
        payOrder.setPartnerCode(payGateway.getPartnerCode());
        payOrder.setEmail(request.getEmail());
        payOrder.setPartnerAccount(request.getPartnerAccount());
        Integer expireTime = null == request.getExpireTime() ? partnerConfig.getExpireTime() : request.getExpireTime();
        payOrder.setExpireTime(expireTime);
        payOrder.setTerminal(request.getTerminal());
        payOrder.setAccountId(request.getAccountId());
        if (CollectionUtils.isNotEmpty((Collection)request.getPayInfo())) {
            payOrder.setParentTradeId(payOrder.getTradeId());
        } else {
            PayOrderAttachInfoEo attachInfoEo = PayOrderAttachInfoEo.newInstance();
            attachInfoEo.setPayRequest(request.toString());
            attachInfoEo.setTradeId(payOrder.getTradeId());
            attachInfoEo.setRemark6(request.getRemark6());
            attachInfoEo.setImei(request.getImei());
            attachInfoEo.setIp(request.getIp());
            attachInfoEo.setMac(request.getMac());
            attachInfoEo.setImsi(request.getImsi());
            this.payOrderAttachInfoDas.insert((BaseEo)attachInfoEo);
        }
        payOrder.setExtension(request.getExtension());
        this.payOrderDas.insert((BaseEo)payOrder);
        return payOrder;
    }

    public List<PayResponse.PayResult> saveSubOrder(PayRequest request, PayOrderEo parentOrder, GatewayEo payGateway) throws Exception {
        ArrayList<PayResponse.PayResult> payResults = new ArrayList<PayResponse.PayResult>();
        List payInfos = request.getPayInfo();
        PayOrderEo payOrder = PayOrderEo.newInstance();
        if (CollectionUtils.isNotEmpty((Collection)payInfos)) {
            ArrayList payOrderEoList = Lists.newArrayList();
            ArrayList payOrderAttachInfoEoList = Lists.newArrayList();
            for (PayRequest.PayInfo payInfo : payInfos) {
                PayOrderEo subOrder = PayOrderEo.newInstance();
                if (Constant.isSpecifiedAppId((String)request.getAppId())) {
                    subOrder = this.payOrderDas.selectByStoreOrderIdAndGateway(request.getStoreId(), request.getStoreOrderId(), payGateway.getCode());
                    if (null != payOrder) continue;
                }
                BeanUtils.copyProperties((Object)parentOrder, (Object)subOrder);
                subOrder.setId(null);
                subOrder.setTradeId(this.tradeIdGenService.genTradeId(TradeIdType.PAY));
                subOrder.setParentTradeId(parentOrder.getParentTradeId());
                subOrder.setAmount(new BigDecimal(0));
                if (!StringUtils.isBlank((CharSequence)payInfo.getBackUrl())) {
                    subOrder.setCallbackUrl(payInfo.getBackUrl());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getNotifyUrl())) {
                    subOrder.setNotifyUrl(payInfo.getNotifyUrl());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getTerminal())) {
                    subOrder.setTerminal(payInfo.getTerminal());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getAccountId())) {
                    subOrder.setAccountId(payInfo.getAccountId());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getEmail())) {
                    subOrder.setEmail(payInfo.getEmail());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getCardType())) {
                    subOrder.setCardType(payInfo.getCardType());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getBindId())) {
                    subOrder.setBindId(payInfo.getBindId());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getStoreOrderId())) {
                    subOrder.setStoreOrderId(payInfo.getStoreOrderId());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getPtUserId())) {
                    subOrder.setPtUserId(payInfo.getPtUserId());
                }
                if (payInfo.getOrderAmt() != null) {
                    subOrder.setAmount(payInfo.getOrderAmt());
                }
                if (payInfo.getFeeAmt() != null) {
                    subOrder.setFee(payInfo.getFeeAmt());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getBankAccount())) {
                    subOrder.setBankAccount(payInfo.getBankAccount());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getUserId())) {
                    subOrder.setUserId(payInfo.getUserId());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getRemark())) {
                    subOrder.setRemark(payInfo.getRemark());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getBankCode())) {
                    subOrder.setBankCode(payInfo.getBankCode());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getBankType())) {
                    subOrder.setBankType(payInfo.getBankType());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getAttachInfo())) {
                    subOrder.setAttachInfo(payInfo.getAttachInfo());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getUserName())) {
                    subOrder.setUserName(payInfo.getUserName());
                }
                if (!StringUtils.isBlank((CharSequence)payInfo.getMobile())) {
                    subOrder.setMobile(payInfo.getMobile());
                }
                payOrderEoList.add(subOrder);
                PayOrderAttachInfoEo attachinfoEo = PayOrderAttachInfoEo.newInstance();
                attachinfoEo.setTradeId(subOrder.getTradeId());
                attachinfoEo.setRemark1(payInfo.getUserId());
                attachinfoEo.setRemark6(request.getRemark6());
                attachinfoEo.setRemark4(payInfo.getUserName());
                attachinfoEo.setRemark3(parentOrder.getParentTradeId());
                attachinfoEo.setImei(request.getImei());
                attachinfoEo.setIp(request.getIp());
                attachinfoEo.setImsi(request.getImsi());
                attachinfoEo.setMac(request.getMac());
                payOrderAttachInfoEoList.add(attachinfoEo);
                PayResponse.PayResult payResult = new PayResponse.PayResult();
                payResult.setStoreOrderId(request.getStoreOrderId());
                payResult.setTradeId(subOrder.getTradeId());
                payResults.add(payResult);
            }
            if (CollectionUtils.isNotEmpty((Collection)payOrderEoList)) {
                this.payOrderDas.insertBatch((List)payOrderEoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)payOrderAttachInfoEoList)) {
                this.payOrderAttachInfoDas.insertBatch((List)payOrderAttachInfoEoList);
            }
            PayOrderAttachInfoEo attachinfoEo = PayOrderAttachInfoEo.newInstance();
            attachinfoEo.setTradeId(parentOrder.getParentTradeId());
            attachinfoEo.setRemark3("PARENT_ORDER");
            attachinfoEo.setImei(request.getImei());
            attachinfoEo.setIp(request.getIp());
            attachinfoEo.setImsi(request.getImsi());
            attachinfoEo.setMac(request.getMac());
            attachinfoEo.setPayRequest(request.toString());
            this.payOrderAttachInfoDas.insert((BaseEo)attachinfoEo);
        }
        return payResults;
    }

    @Override
    public String checkAndGetOrderStatus(String tradeId) throws Exception {
        PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId);
        CheckResult checkResult = this.checkPayOrderService.checkOrder(payOrder.getTradeId());
        if (checkResult.getResult() != 1) {
            this.logger.error("\u6e20\u9053\u6838\u5bf9\u4e0d\u4e00\u81f4");
            return OrderStatus.ACCEPT.getStatus();
        }
        return ((PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId)).getStatus();
    }
}

