/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create.AbstractCreateRefundTradeService;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.PayGateways;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.mapper.RefundOrderMapper;
import java.math.BigDecimal;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="createRefundPayEnterOrderService")
public class CreateRefundPayEnterOrderServiceImpl
extends AbstractCreateRefundTradeService {
    @Override
    public void parseRefundOrder(RefundOrderEo refundOrder, RefundRequest request) throws Exception {
        EnterpriseOrderEo payOrder = this.getPayTradeOrder(request);
        refundOrder.setPartnerConfigCode(payOrder.getPartnerConfigCode());
        refundOrder.setPartnerCode(payOrder.getPartnerCode());
        refundOrder.setPartnerAccount(payOrder.getPartnerAccount());
        refundOrder.setTradeId(payOrder.getTradeId());
        refundOrder.setPayType(payOrder.getPayType());
        refundOrder.setGatewayCode(payOrder.getGatewayCode());
    }

    @Override
    public GatewayService getGatewayService(RefundRequest request) throws Exception {
        EnterpriseOrderEo payOrder = this.getPayTradeOrder(request);
        return this.gatewayServiceFactory.createGatewayService(payOrder.getGatewayCode());
    }

    private EnterpriseOrderEo getPayTradeOrder(RefundRequest request) throws Exception {
        EnterpriseOrderEo payOrder = this.payEnterpriseOrderDas.selectOrder(request.getTradeId(), request.getStoreId(), request.getStoreOrderId());
        if (PayGateways.PINGAN_EPAY_PAY.getGatewayId().equals(payOrder.getGatewayCode()) ? !payOrder.getStatus().equals(OrderStatus.ACCEPT.getStatus()) && !payOrder.getStatus().equals(OrderStatus.SUCCESS.getStatus()) : null == payOrder || !payOrder.getStatus().equals(OrderStatus.SUCCESS.getStatus())) {
            throw new ApiException("INVALID_ORDER_ID", ErrorCode.getErrorMsg((String)"INVALID_ORDER_ID"));
        }
        return payOrder;
    }

    @Override
    public BigDecimal getOrderAmt(RefundRequest request) throws Exception {
        EnterpriseOrderEo payOrder = this.getPayTradeOrder(request);
        if (null == payOrder) {
            this.logger.error("\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728\uff0ctradeId" + request.getTradeId());
            throw new ApiException("INVALID_ORDER_ID", ErrorCode.getErrorMsg((String)"INVALID_ORDER_ID"));
        }
        return payOrder.getAmount();
    }

    @Override
    public BigDecimal getTotalRefundAmt(RefundRequest request) throws Exception {
        EnterpriseOrderEo payEnterpriseOrder = this.getPayTradeOrder(request);
        Map refundSumary = ((RefundOrderMapper)this.payRefundOrderDas.getMapper()).selectRefundAmt(payEnterpriseOrder.getTradeId(), OrderStatus.SUCCESS.getStatus());
        if (null == refundSumary || null == refundSumary.get("totalAmount")) {
            return new BigDecimal("0.00");
        }
        return (BigDecimal)refundSumary.get("totalAmount");
    }
}

