/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.create.AbstractCreateRefundTradeService;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.mapper.RefundOrderMapper;
import java.math.BigDecimal;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="createRefundPayOrderTradeService")
public class CreateRefundPayOrderTradeServiceImpl
extends AbstractCreateRefundTradeService {
    @Override
    public void parseRefundOrder(RefundOrderEo refundOrder, RefundRequest request) throws Exception {
        PayOrderEo payOrder = this.getPayTradeOrder(request);
        PartnerConfigEo payPartnerConfig = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payOrder.getPartnerConfigCode());
        refundOrder.setPartnerConfigCode(payOrder.getPartnerConfigCode());
        refundOrder.setTradeId(payOrder.getTradeId());
        refundOrder.setPayType(payOrder.getPayType());
        refundOrder.setPartnerCode(payOrder.getPartnerCode());
        refundOrder.setTradeId(payOrder.getTradeId());
        refundOrder.setGatewayCode(payOrder.getGatewayCode());
        refundOrder.setRemark5(payOrder.getPartnerOrderId());
        refundOrder.setPartnerOrderId(this.tradeIdGenService.genTradeId(payPartnerConfig.getPtMerId()));
        refundOrder.setRemark1(this.tradeIdGenService.genTradeId(payPartnerConfig.getPtMerId()));
    }

    @Override
    public GatewayService getGatewayService(RefundRequest request) throws Exception {
        PayOrderEo payOrder = this.getPayTradeOrder(request);
        return this.gatewayServiceFactory.createGatewayService(payOrder.getGatewayCode());
    }

    @Override
    public BigDecimal getOrderAmt(RefundRequest request) throws Exception {
        PayOrderEo payOrder = this.getPayTradeOrder(request);
        if (null == payOrder) {
            this.logger.error("\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728\uff0ctradeId" + request.getTradeId());
            throw new ApiException("INVALID_ORDER_ID", ErrorCode.getErrorMsg((String)"INVALID_ORDER_ID"));
        }
        if (!OrderStatus.isSuccStatus((String)payOrder.getStatus())) {
            this.logger.error("\u8ba2\u5355\u72b6\u6001\u4e3a" + payOrder.getStatus() + ", \u4e0d\u662f\u6210\u529f\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u9000\u6b3e");
            throw new ApiException("FORBIDEN_REFUND", "\u8ba2\u5355\u4e0d\u662f\u6210\u529f\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u9000\u6b3e");
        }
        return payOrder.getAmount();
    }

    @Override
    public BigDecimal getTotalRefundAmt(RefundRequest request) throws Exception {
        PayOrderEo payOrder = this.getPayTradeOrder(request);
        Map refundSumary = ((RefundOrderMapper)this.payRefundOrderDas.getMapper()).selectRefundAmt(payOrder.getTradeId(), OrderStatus.SUCCESS.getStatus());
        if (null == refundSumary || null == refundSumary.get("totalAmount")) {
            return new BigDecimal("0.00");
        }
        return (BigDecimal)refundSumary.get("totalAmount");
    }

    private PayOrderEo getPayTradeOrder(RefundRequest request) throws Exception {
        PayOrderEo payOrder = this.payOrderDas.selectOrder(request.getTradeId(), request.getStoreId(), request.getStoreOrderId(), OrderStatus.SUCCESS.getStatus());
        if (null == payOrder) {
            throw new ApiException("INVALID_ORDER_ID", ErrorCode.getErrorMsg((String)"INVALID_ORDER_ID"));
        }
        if (!StringUtils.isEmpty((Object)payOrder.getParentTradeId()) && !payOrder.getTradeId().equals(payOrder.getParentTradeId())) {
            throw new ApiException("INVALID_REFUND_SUBORDER", ErrorCode.getErrorMsg((String)"INVALID_REFUND_SUBORDER"));
        }
        return payOrder;
    }
}

