/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.notify;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.ApiBaseService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PartnerNotifyRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PartnerNotifyResponse;
import com.dtyunxi.yundt.cube.center.payment.service.message.MessageServiceHelper;
import com.dtyunxi.yundt.cube.center.payment.service.trade.notify.HandleNotifyService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="notifyPartnerTradeService")
public class NotifyPartnerTradeServiceImpl
extends ApiBaseService<PartnerNotifyRequest> {
    @Resource
    private HandleNotifyService handleNotifyService;
    @Resource
    private MessageServiceHelper messageServiceHelper;
    @Resource
    private PayOrderDas payOrderDas;

    @Override
    public BaseResponse _execute(PartnerNotifyRequest request) throws Exception {
        PartnerNotifyResponse resp = new PartnerNotifyResponse();
        String result = "";
        try {
            result = this.handleNotifyService.handlePartnerNotify(request.getNotifyId(), request.getNotifyData());
        }
        catch (Exception e) {
            this.messageServiceHelper.sendMessage4PartnerErr("\u5904\u7406\u6e20\u9053\u901a\u77e5\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u539f\u56e0\uff1a\n" + e.getMessage());
            throw e;
        }
        resp.setResult(result);
        if (TradeIdType.verifyIdType((String)request.getNotifyId(), (TradeIdType)TradeIdType.PAY)) {
            PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)request.getNotifyId());
            resp.setBackUrl(null != payOrder ? payOrder.getCallbackUrl() : null);
        }
        return resp;
    }

    @Override
    public void validate(PartnerNotifyRequest request) throws Exception {
    }

    public void setHandleNotifyService(HandleNotifyService handleNotifyService) {
        this.handleNotifyService = handleNotifyService;
    }

    public void setMessageServiceHelper(MessageServiceHelper messageServiceHelper) {
        this.messageServiceHelper = messageServiceHelper;
    }
}

