/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.query;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.query.AbstractQueryTradeService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.query.PayEnterOrderQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.query.PayEnterOrderQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.query.base.QueryBaseResponse;
import com.dtyunxi.yundt.cube.center.payment.service.trade.query.OrderQueryService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="queryPayEnterOrderTradeService")
public class QueryPayEnterOrderTradeServiceImpl
extends AbstractQueryTradeService<PayEnterOrderQueryRequest, EnterpriseOrderEo> {
    @Resource
    private OrderQueryService payEnterOrderQueryService;
    @Resource
    private EnterpriseOrderAttachInfoDas enterpriseOrderAttachinfoDas;

    @Override
    public BaseResponse _execute(PayEnterOrderQueryRequest request) throws Exception {
        return this.doQueryOrder(this.payEnterOrderQueryService, request.getTradeId(), request.getStoreId(), request.getStoreOrderId(), request.getForceQuery());
    }

    @Override
    public void validate(PayEnterOrderQueryRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getStoreOrderId()) && StringUtils.isBlank((CharSequence)request.getTradeId())) {
            throw new ApiException("INVALID_ORDER_ID", "storeOrderId\u6216\u8005tradeId\uff0c\u4e8c\u8005\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    public PayEnterOrderQueryResponse packageResponse(EnterpriseOrderEo payOrder) {
        EnterpriseOrderAttachInfoEo attachinfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachinfoDas.selectByLogicKey((Object)payOrder.getTradeId());
        PayEnterOrderQueryResponse response = new PayEnterOrderQueryResponse(payOrder.getTradeId(), payOrder.getStoreOrderId(), payOrder.getAmount().toString(), payOrder.getStatus(), payOrder.getUserId());
        this.parseQueryResponse((QueryBaseResponse)response, payOrder.getOrderTime(), payOrder.getFinishTime(), payOrder.getCheckStatus());
        if (!OrderStatus.isFinishStatus((String)payOrder.getStatus())) {
            response.setOrderStatus(OrderStatus.PROCESS.getStatus());
        } else {
            response.setOrderStatus(payOrder.getStatus());
        }
        response.setFeeAmt(null == payOrder.getFee() ? "0.00" : payOrder.getFee().toString());
        response.setFailCode(payOrder.getErrorCode());
        response.setFailMsg(payOrder.getErrorMsg());
        response.setPartnerOrderId(payOrder.getPartnerOrderId());
        return response;
    }

    public void setPayEnterOrderQueryService(OrderQueryService payEnterOrderQueryService) {
        this.payEnterOrderQueryService = payEnterOrderQueryService;
    }
}

