/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.query;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.query.AbstractQueryTradeService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.query.PayOrderQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.query.PayOrderQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.query.base.QueryBaseResponse;
import com.dtyunxi.yundt.cube.center.payment.service.trade.query.OrderQueryService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="queryPayOrderTradeService")
public class QueryPayOrderTradeServiceImpl
extends AbstractQueryTradeService<PayOrderQueryRequest, PayOrderEo> {
    @Resource
    private OrderQueryService payOrderQueryService;
    @Resource
    private PayOrderAttachInfoDas payOrderAttachInfoDas;

    @Override
    public BaseResponse _execute(PayOrderQueryRequest request) throws Exception {
        return this.doQueryOrder(this.payOrderQueryService, request.getTradeId(), request.getStoreId(), request.getStoreOrderId(), request.getForceQuery());
    }

    @Override
    public void validate(PayOrderQueryRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getStoreOrderId()) && StringUtils.isBlank((CharSequence)request.getTradeId())) {
            throw new ApiException("INVALID_ORDER_ID", "storeOrderId\u6216\u8005tradeId\uff0c\u4e8c\u8005\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    public PayOrderQueryResponse packageResponse(PayOrderEo payOrder) {
        PayOrderQueryResponse response = new PayOrderQueryResponse(payOrder.getTradeId(), payOrder.getStoreOrderId(), payOrder.getAmount().toString(), payOrder.getStatus(), payOrder.getUserId());
        this.parseQueryResponse((QueryBaseResponse)response, payOrder.getOrderTime(), payOrder.getFinishTime(), payOrder.getCheckStatus());
        if (!OrderStatus.isFinishStatus((String)payOrder.getStatus())) {
            response.setOrderStatus(OrderStatus.PROCESS.getStatus());
        } else {
            response.setOrderStatus(payOrder.getStatus());
        }
        response.setAttachInfo(payOrder.getAttachInfo());
        response.setPartnerOrderId(payOrder.getPartnerOrderId());
        response.setFailCode(payOrder.getErrorCode());
        response.setFailMsg(payOrder.getErrorMsg());
        return response;
    }
}

