/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.query;

import com.dtyunxi.yundt.cube.center.payment.apiimpl.trade.query.AbstractQueryTradeService;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.query.PayRefundOrderQueryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.query.PayRefundOrderQueryResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.query.base.QueryBaseResponse;
import com.dtyunxi.yundt.cube.center.payment.service.trade.query.OrderQueryService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="queryPayRefundOrderTradeService")
public class QueryRefundOrderTradeServiceImpl
extends AbstractQueryTradeService<PayRefundOrderQueryRequest, RefundOrderEo> {
    @Resource
    private OrderQueryService payRefundOrderQueryService;

    @Override
    public BaseResponse _execute(PayRefundOrderQueryRequest request) throws Exception {
        return this.doQueryOrder(this.payRefundOrderQueryService, request.getRefundId(), request.getStoreId(), request.getStoreRefundId(), request.getForceQuery());
    }

    @Override
    public void validate(PayRefundOrderQueryRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getStoreRefundId()) && StringUtils.isBlank((CharSequence)request.getRefundId())) {
            throw new ApiException("INVALID_ORDER_ID", "storeRefundId\u6216\u8005refundId\uff0c\u4e8c\u8005\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    @Override
    public QueryBaseResponse packageResponse(RefundOrderEo rfOrder) {
        PayRefundOrderQueryResponse response = new PayRefundOrderQueryResponse(rfOrder.getTradeId(), rfOrder.getRefundId(), rfOrder.getStoreRefundId(), rfOrder.getAmount().toString(), rfOrder.getStatus(), rfOrder.getUserId());
        this.parseQueryResponse((QueryBaseResponse)response, rfOrder.getRefundTime(), rfOrder.getFinishTime(), rfOrder.getCheckStatus());
        if (!OrderStatus.isFinishStatus((String)rfOrder.getStatus())) {
            response.setRefundStatus(OrderStatus.PROCESS.getStatus());
        } else {
            response.setRefundStatus(rfOrder.getStatus());
        }
        response.setFailCode(rfOrder.getErrorCode());
        response.setFailMsg(rfOrder.getErrorMsg());
        response.setAttachInfo(rfOrder.getAttachInfo());
        response.setPartnerOrderId(rfOrder.getPartnerOrderId());
        return response;
    }
}

