/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.dto.request.BankAccountReqDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.BankAccountRespDto;
import com.dtyunxi.yundt.cube.center.payment.service.IBankAccountService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.BankAccountDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.BankAccountEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BankAccountServiceImpl
implements IBankAccountService {
    @Resource
    private BankAccountDas bankAccountDas;

    @Override
    public Long addBankAccount(BankAccountReqDto addReqDto) {
        BankAccountEo bankAccountEo = new BankAccountEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)bankAccountEo);
        this.bankAccountDas.insert((BaseEo)bankAccountEo);
        return bankAccountEo.getId();
    }

    @Override
    public void modifyBankAccount(BankAccountReqDto modifyReqDto) {
        BankAccountEo bankAccountEo = new BankAccountEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)bankAccountEo);
        this.bankAccountDas.updateSelective((BaseEo)bankAccountEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBankAccount(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.bankAccountDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BankAccountRespDto queryById(Long id) {
        BankAccountEo bankAccountEo = (BankAccountEo)this.bankAccountDas.selectByPrimaryKey(id);
        BankAccountRespDto bankAccountRespDto = new BankAccountRespDto();
        DtoHelper.eo2Dto((BaseEo)bankAccountEo, (BaseVo)bankAccountRespDto);
        return bankAccountRespDto;
    }

    @Override
    public PageInfo<BankAccountRespDto> queryByPage(Integer pageNum, Integer pageSize) {
        BankAccountReqDto bankAccountReqDto = (BankAccountReqDto)JSON.parseObject((String)"", BankAccountReqDto.class);
        BankAccountEo bankAccountEo = new BankAccountEo();
        DtoHelper.dto2Eo((BaseVo)bankAccountReqDto, (BaseEo)bankAccountEo);
        PageInfo eoPageInfo = this.bankAccountDas.selectPage((BaseEo)bankAccountEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<Object> dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BankAccountRespDto.class);
        dtoList = dtoList.stream().sorted(Comparator.comparing(BankAccountRespDto::getSort)).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

