/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.payment.dto.config.AliPayPartnerConfigRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.BasePayPartnerConfigRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.WxPayPartnerConfigRequest;
import com.dtyunxi.yundt.cube.center.payment.event.CertUpdateEvent;
import com.dtyunxi.yundt.cube.center.payment.service.IPartnerConfigService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PartnerConfigDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.WxCertificateDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.WxCertificateEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="partnerConfigService")
public class PartnerConfigServiceImpl
implements IPartnerConfigService,
ApplicationEventPublisherAware {
    @Autowired
    private PartnerConfigDas partnerConfigDas;
    @Autowired
    private WxCertificateDas wxCertificateDas;
    private Logger logger = LoggerFactory.getLogger(PartnerConfigServiceImpl.class);
    ApplicationEventPublisher applicationEventPublisher;

    @Override
    @Transactional
    public void updateWxConfig(WxPayPartnerConfigRequest wxPayPartnerConfigRequest) {
        PartnerConfigEo partnerConfigEo1 = this.getEoByDb((BasePayPartnerConfigRequest)wxPayPartnerConfigRequest);
        boolean update = true;
        if (partnerConfigEo1 == null) {
            partnerConfigEo1 = this.getEo((BasePayPartnerConfigRequest)wxPayPartnerConfigRequest);
            update = false;
        }
        partnerConfigEo1.setPtMerId(wxPayPartnerConfigRequest.getMerId());
        partnerConfigEo1.setPtAccount(wxPayPartnerConfigRequest.getAppId());
        partnerConfigEo1.setLcPrivKey(wxPayPartnerConfigRequest.getCertificate());
        partnerConfigEo1.setPtPubKey(wxPayPartnerConfigRequest.getApiSecret());
        partnerConfigEo1.setPtQueryKey(wxPayPartnerConfigRequest.getApiSecret());
        partnerConfigEo1.setLcPubKey(wxPayPartnerConfigRequest.getAppSecret());
        if (update) {
            this.partnerConfigDas.update((BaseEo)partnerConfigEo1);
        } else {
            String code = String.format("icommerce_wx_s%_s%", partnerConfigEo1.getPartnerCode(), partnerConfigEo1.getPayType());
            partnerConfigEo1.setCode(code);
            this.partnerConfigDas.insert((BaseEo)partnerConfigEo1);
        }
        if (wxPayPartnerConfigRequest.getCertificateId() != null) {
            this.logger.info("\u542f\u7528\u8bc1\u4e66\u914d\u7f6e\uff0c\u8bc1\u4e66ID\uff1a{}", (Object)wxPayPartnerConfigRequest.getCertificateId());
            this.enableCert(partnerConfigEo1.getId(), wxPayPartnerConfigRequest.getCertificateId(), partnerConfigEo1.getPtMerId());
        }
    }

    private void enableCert(Long configId, Long certId, String merId) {
        WxCertificateEo query = new WxCertificateEo();
        query.setPartnerConfigId(configId);
        ArrayList<SqlFilter> filterList = new ArrayList<SqlFilter>();
        ArrayList<Integer> drList = new ArrayList<Integer>();
        drList.add(0);
        drList.add(1);
        filterList.add(SqlFilter.in((String)"dr", drList));
        query.setSqlFilters(filterList);
        List certificateEoList = this.wxCertificateDas.select((BaseEo)query);
        if (CollectionUtils.isEmpty((Collection)certificateEoList)) {
            return;
        }
        this.logger.info("\u8be5\u652f\u4ed8\u65b9\u5f0f\u4e0b\u6240\u62e5\u6709\u7684\u652f\u4ed8\u65b9\u5f0f:{}", (Object)JSON.toJSONString((Object)certificateEoList));
        certificateEoList.forEach(e -> {
            if (e.getId().longValue() == certId.longValue()) {
                if (e.getStatus() == 0) {
                    e.setStatus(Integer.valueOf(1));
                    this.logger.info("\u542f\u7528\u652f\u4ed8\u8bc1\u4e66id:{}", (Object)e.getId());
                    this.wxCertificateDas.update((BaseEo)e);
                    CertUpdateEvent certUpdateEvent = new CertUpdateEvent((Object)this, merId);
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)certUpdateEvent);
                }
            } else {
                e.setStatus(Integer.valueOf(0));
                this.logger.info("\u7981\u7528\u652f\u4ed8\u8bc1\u4e66id:{}", (Object)e.getId());
                this.wxCertificateDas.update((BaseEo)e);
            }
        });
    }

    private PartnerConfigEo getEoByDb(BasePayPartnerConfigRequest basePayPartnerConfigRequest) {
        PartnerConfigEo partnerConfigEo = this.getEo(basePayPartnerConfigRequest);
        return (PartnerConfigEo)this.partnerConfigDas.selectOne((BaseEo)partnerConfigEo);
    }

    private PartnerConfigEo getEo(BasePayPartnerConfigRequest basePayPartnerConfigRequest) {
        PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
        partnerConfigEo.setId(basePayPartnerConfigRequest.getId());
        return partnerConfigEo;
    }

    @Override
    public void updateAliConfig(AliPayPartnerConfigRequest aliPayPartnerConfigRequest) {
        PartnerConfigEo partnerConfigEo1 = this.getEoByDb((BasePayPartnerConfigRequest)aliPayPartnerConfigRequest);
        boolean update = true;
        if (partnerConfigEo1 == null) {
            partnerConfigEo1 = this.getEo((BasePayPartnerConfigRequest)aliPayPartnerConfigRequest);
            update = false;
        }
        partnerConfigEo1.setPtMerId(aliPayPartnerConfigRequest.getMerId());
        partnerConfigEo1.setPtAccount(aliPayPartnerConfigRequest.getAppId());
        partnerConfigEo1.setLcPrivKey(aliPayPartnerConfigRequest.getMerchantPrivateKey());
        partnerConfigEo1.setPtPubKey(aliPayPartnerConfigRequest.getMerchantPublicKey());
        if (update) {
            this.partnerConfigDas.update((BaseEo)partnerConfigEo1);
        } else {
            String code = String.format("icommerce_alipay_s%_s%", partnerConfigEo1.getPartnerCode(), partnerConfigEo1.getPayType());
            partnerConfigEo1.setCode(code);
            this.partnerConfigDas.insert((BaseEo)partnerConfigEo1);
        }
    }

    @Override
    public void updateConfig(String id, String status) {
        PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
        partnerConfigEo.setId(Long.valueOf(id));
        partnerConfigEo.setStatus(status);
        this.partnerConfigDas.updateSelective((BaseEo)partnerConfigEo);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

