/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorConfigCode;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.Status;
import com.dtyunxi.yundt.cube.center.payment.dto.config.AppAuthRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.AppRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.PayAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.PayCategoryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.PayGateWayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.PayPartnerRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.PayTypeRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryAppAuthRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryAppRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryPayCategoryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryPayGateWayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryPayPartnerRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryPayTypeRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryStoreRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.StoreRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdateAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdateAppAuthRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdateAppRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdatePayCategoryRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdatePayGateWayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdatePayPartnerRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdatePayTypeRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdateStoreRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.request.PayConfigQueryReqDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.AppPaytypeRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.AppRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.BankAccountRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.CategoryRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.GatewayRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.PartnerConfigRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.PartnerRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.PayConfigQueryRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.PaytypeRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.StoreRespDto;
import com.dtyunxi.yundt.cube.center.payment.service.IBankAccountService;
import com.dtyunxi.yundt.cube.center.payment.service.IPayCenterConfigService;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AppDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AppPaytypeDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.CategoryDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.GatewayDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PartnerConfigDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PartnerDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PaytypeDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.WxCertificateDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.AppEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.AppPaytypeEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.CategoryEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.GatewayEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PaytypeEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StdPartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StdPaytypeEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StdWxCertificateEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.WxCertificateEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payCenterConfigService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class PayCenterConfigServiceImpl
implements IPayCenterConfigService {
    private static final String WX_PARTNER_CODE = "102";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private AppDas appDas;
    @Resource
    private StoreDas storeDas;
    @Resource
    private PaytypeDas paytypeDas;
    @Resource
    private CategoryDas categoryDas;
    @Resource
    private PartnerDas partnerDas;
    @Resource
    private PartnerConfigDas partnerConfigDas;
    @Resource
    private AppPaytypeDas appPaytypeDas;
    @Resource
    private GatewayDas gatewayDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private WxCertificateDas wxCertificateDas;
    @Resource
    private IBankAccountService bankAccountService;

    @Override
    public Long createStore(StoreRequest storeRequest) throws Exception {
        Boolean success = this.cacheService.add(storeRequest.getCode(), (Object)"1", 5);
        if (!success.booleanValue()) {
            this.logger.info("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u5546\u6237");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        StoreEo storeEo = StoreEo.newInstance();
        storeEo.setCode(storeRequest.getCode());
        int count = this.storeDas.count((BaseEo)storeEo);
        if (count > 0) {
            this.logger.error("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u5546\u6237");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        DtoHelper.dto2Eo((BaseVo)storeRequest, (BaseEo)storeEo);
        this.storeDas.insert((BaseEo)storeEo);
        return storeEo.getId();
    }

    @Override
    public Long createApp(String code, AppRequest appRequest) throws Exception {
        StoreEo storeEo = (StoreEo)this.storeDas.selectByLogicKey((Object)code);
        if (storeEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5546\u6237\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_STORE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_STORE"));
        }
        Boolean success = this.cacheService.add(appRequest.getCode(), (Object)"1", 5);
        if (!success.booleanValue()) {
            this.logger.info("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u5e94\u7528");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        AppEo app = AppEo.newInstance();
        app.setCode(appRequest.getCode());
        int count = this.appDas.count((BaseEo)app);
        if (count > 0) {
            this.logger.error("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u5e94\u7528");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        DtoHelper.dto2Eo((BaseVo)appRequest, (BaseEo)app);
        app.setStoreCode(code);
        app.setStatus(Status.ENABLED.getStatus());
        this.appDas.insert((BaseEo)app);
        return app.getId();
    }

    @Override
    public Long createPayCategory(PayCategoryRequest payCategoryRequest) throws Exception {
        Boolean success = this.cacheService.add(payCategoryRequest.getCode(), (Object)"1", 5);
        if (!success.booleanValue()) {
            this.logger.info("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u652f\u4ed8\u7c7b\u522b");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        CategoryEo categoryEo = CategoryEo.newInstance();
        categoryEo.setCode(payCategoryRequest.getCode());
        int count = this.categoryDas.count((BaseEo)categoryEo);
        if (count > 0) {
            this.logger.error("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u652f\u4ed8\u7c7b\u522b");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        DtoHelper.dto2Eo((BaseVo)payCategoryRequest, (BaseEo)categoryEo);
        this.categoryDas.insert((BaseEo)categoryEo);
        return categoryEo.getId();
    }

    @Override
    public Long createPayType(String code, PayTypeRequest payTypeRequest) throws Exception {
        CategoryEo categoryEo = (CategoryEo)this.categoryDas.selectByLogicKey((Object)code);
        if (categoryEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u7c7b\u522b\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_CATEGORY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_CATEGORY"));
        }
        Boolean success = this.cacheService.add(payTypeRequest.getCode(), (Object)"1", 5);
        if (!success.booleanValue()) {
            this.logger.info("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u652f\u4ed8\u65b9\u5f0f");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        PaytypeEo paytypeEo = PaytypeEo.newInstance();
        paytypeEo.setCode(payTypeRequest.getCode());
        int count = this.paytypeDas.count((BaseEo)paytypeEo);
        if (count > 0) {
            this.logger.error("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u652f\u4ed8\u65b9\u5f0f");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        DtoHelper.dto2Eo((BaseVo)payTypeRequest, (BaseEo)paytypeEo);
        paytypeEo.setCatagoryCode(code);
        this.paytypeDas.insert((BaseEo)paytypeEo);
        return paytypeEo.getId();
    }

    @Override
    public Long createPayPartner(PayPartnerRequest payPartnerRequest) throws Exception {
        Boolean success = this.cacheService.add(payPartnerRequest.getCode(), (Object)"1", 5);
        if (!success.booleanValue()) {
            this.logger.info("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u652f\u4ed8\u6e20\u9053");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        PartnerEo partnerEo = PartnerEo.newInstance();
        partnerEo.setCode(payPartnerRequest.getCode());
        int count = this.partnerDas.count((BaseEo)partnerEo);
        if (count > 0) {
            this.logger.error("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u652f\u4ed8\u6e20\u9053");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        DtoHelper.dto2Eo((BaseVo)payPartnerRequest, (BaseEo)partnerEo);
        this.partnerDas.insert((BaseEo)partnerEo);
        return partnerEo.getId();
    }

    @Override
    public Long createPayGateWay(PayGateWayRequest payGateWayRequest) throws Exception {
        PaytypeEo paytypeEo = (PaytypeEo)this.paytypeDas.selectByLogicKey((Object)payGateWayRequest.getPayType());
        if (paytypeEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYTYPE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYTYPE"));
        }
        PartnerEo partnerEo = (PartnerEo)this.partnerDas.selectByLogicKey((Object)payGateWayRequest.getPartnerCode());
        if (partnerEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u6e20\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYPARTNER", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYPARTNER"));
        }
        Boolean success = this.cacheService.add(payGateWayRequest.getPayType() + payGateWayRequest.getPartnerCode(), (Object)"1", 5);
        if (!success.booleanValue()) {
            this.logger.info("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u652f\u4ed8\u901a\u9053");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        GatewayEo gatewayEo = GatewayEo.newInstance();
        gatewayEo.setPayType(payGateWayRequest.getPayType());
        gatewayEo.setPartnerCode(payGateWayRequest.getPartnerCode());
        int count = this.gatewayDas.count((BaseEo)gatewayEo);
        if (count > 0) {
            this.logger.error("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u652f\u4ed8\u901a\u9053");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        DtoHelper.dto2Eo((BaseVo)payGateWayRequest, (BaseEo)gatewayEo);
        gatewayEo.setPayType(payGateWayRequest.getPayType());
        gatewayEo.setPartnerCode(payGateWayRequest.getPartnerCode());
        gatewayEo.setCode(payGateWayRequest.getPayType() + payGateWayRequest.getPartnerCode() + "0");
        gatewayEo.setName(paytypeEo.getName() + "+" + partnerEo.getName() + "-API");
        this.gatewayDas.insert((BaseEo)gatewayEo);
        return gatewayEo.getId();
    }

    @Override
    public Long createPayAccount(PayAccountRequest payAccountRequest) throws Exception {
        AppEo appEo = AppEo.newInstance();
        appEo.setStoreCode(payAccountRequest.getStoreCode());
        appEo.setCode(payAccountRequest.getAppCode());
        AppEo appEo1 = (AppEo)this.appDas.selectOne((BaseEo)appEo);
        if (appEo1 == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5e94\u7528\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_APP", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_APP"));
        }
        PaytypeEo paytypeEo = (PaytypeEo)this.paytypeDas.selectByLogicKey((Object)payAccountRequest.getPayType());
        if (paytypeEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYTYPE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYTYPE"));
        }
        PartnerEo partnerEo = (PartnerEo)this.partnerDas.selectByLogicKey((Object)payAccountRequest.getPartnerCode());
        if (partnerEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u6e20\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYPARTNER", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYPARTNER"));
        }
        GatewayEo gateway = GatewayEo.newInstance();
        gateway.setPayType(payAccountRequest.getPayType());
        gateway.setPartnerCode(payAccountRequest.getPartnerCode());
        GatewayEo gatewayEo = (GatewayEo)this.gatewayDas.selectOne((BaseEo)gateway);
        if (gatewayEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u901a\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYGATEWAY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYGATEWAY"));
        }
        Boolean success = this.cacheService.add(payAccountRequest.getPayType() + payAccountRequest.getPartnerCode() + payAccountRequest.getAppCode() + payAccountRequest.getStoreCode(), (Object)"1", 5);
        if (!success.booleanValue()) {
            this.logger.info("\u4e0d\u5141\u8bb8\u521b\u5efa\u591a\u4e2a\u76f8\u540c\u6536\u6b3e\u8d26\u53f7");
            throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
        }
        PartnerConfigEo query = PartnerConfigEo.newInstance();
        query.setPartnerCode(payAccountRequest.getPartnerCode());
        query.setAppCode(payAccountRequest.getAppCode());
        query.setPayType(payAccountRequest.getPayType());
        int count = this.partnerConfigDas.count((BaseEo)query);
        PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)payAccountRequest, (BaseEo)partnerConfigEo);
        partnerConfigEo.setCode(payAccountRequest.getPartnerCode() + "-" + payAccountRequest.getPayType() + "-" + payAccountRequest.getAppCode() + "-" + (count + 1));
        partnerConfigEo.setStatus(Status.ENABLED.getStatus());
        this.partnerConfigDas.insert((BaseEo)partnerConfigEo);
        return partnerConfigEo.getId();
    }

    @Override
    public Long createAppAuth(AppAuthRequest appAuthRequest) throws Exception {
        AppEo appEo = (AppEo)this.appDas.selectByLogicKey((Object)appAuthRequest.getAppCode());
        if (appEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5e94\u7528\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_APP", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_APP"));
        }
        PaytypeEo paytypeEo = (PaytypeEo)this.paytypeDas.selectByLogicKey((Object)appAuthRequest.getPayType());
        if (paytypeEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYTYPE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYTYPE"));
        }
        PartnerEo partnerEo = (PartnerEo)this.partnerDas.selectByLogicKey((Object)appAuthRequest.getPartnerCode());
        if (partnerEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u6e20\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYPARTNER", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYPARTNER"));
        }
        GatewayEo gateway = GatewayEo.newInstance();
        gateway.setPayType(appAuthRequest.getPayType());
        gateway.setPartnerCode(appAuthRequest.getPartnerCode());
        GatewayEo gatewayEo = (GatewayEo)this.gatewayDas.selectOne((BaseEo)gateway);
        if (gatewayEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u901a\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYGATEWAY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYGATEWAY"));
        }
        AppPaytypeEo appPaytypeEo = AppPaytypeEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)appAuthRequest, (BaseEo)appPaytypeEo);
        this.appPaytypeDas.insert((BaseEo)appPaytypeEo);
        return appPaytypeEo.getId();
    }

    @Override
    public void updateStore(Long id, UpdateStoreRequest storeRequest) throws Exception {
        StoreEo storeEo = (StoreEo)this.storeDas.selectByPrimaryKey(id);
        if (storeEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5546\u6237\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_STORE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_STORE"));
        }
        if (!storeEo.getCode().equals(storeRequest.getCode())) {
            Boolean success = this.cacheService.add(storeRequest.getCode(), (Object)"1", 5);
            if (!success.booleanValue()) {
                this.logger.info("\u5546\u6237\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            StoreEo temp = StoreEo.newInstance();
            temp.setCode(storeRequest.getCode());
            int count = this.storeDas.count((BaseEo)temp);
            if (count > 0) {
                this.logger.error("\u5546\u6237\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            AppEo appEo = AppEo.newInstance();
            appEo.setStoreCode(storeEo.getCode());
            List appList = this.appDas.select((BaseEo)appEo);
            for (AppEo app : appList) {
                app.setStoreCode(storeRequest.getCode());
                this.appDas.update((BaseEo)app);
            }
            PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
            partnerConfigEo.setStoreCode(storeEo.getCode());
            List partnerConfigList = this.partnerConfigDas.select((BaseEo)partnerConfigEo);
            for (PartnerConfigEo app : partnerConfigList) {
                app.setStoreCode(storeRequest.getCode());
                this.partnerConfigDas.update((BaseEo)app);
            }
        }
        StoreEo updateEo = StoreEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)storeRequest, (BaseEo)updateEo);
        updateEo.setId(id);
        this.storeDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updateApp(Long id, UpdateAppRequest appRequest) throws Exception {
        StoreEo storeEo;
        AppEo appEo = (AppEo)this.appDas.selectByPrimaryKey(id);
        if (appEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5e94\u7528\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_APP", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_APP"));
        }
        if (!StringUtils.isBlank((CharSequence)appRequest.getStoreCode()) && (storeEo = (StoreEo)this.storeDas.selectByLogicKey((Object)appRequest.getStoreCode())) == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5546\u6237\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_STORE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_STORE"));
        }
        if (!appEo.getStoreCode().equals(appRequest.getStoreCode()) || !appEo.getCode().equals(appRequest.getCode())) {
            if (!appEo.getCode().equals(appRequest.getCode())) {
                Boolean success = this.cacheService.add(appRequest.getCode(), (Object)"1", 5);
                if (!success.booleanValue()) {
                    this.logger.info("\u5e94\u7528\u5df2\u5b58\u5728");
                    throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
                }
                AppEo temp = AppEo.newInstance();
                temp.setCode(appRequest.getCode());
                int count = this.appDas.count((BaseEo)temp);
                if (count > 0) {
                    this.logger.error("\u5e94\u7528\u5df2\u5b58\u5728");
                    throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
                }
                AppPaytypeEo appPayType = AppPaytypeEo.newInstance();
                appPayType.setAppCode(appEo.getCode());
                List appPaytypeEoList = this.appPaytypeDas.select((BaseEo)appPayType);
                if (CollectionUtils.isNotEmpty((Collection)appPaytypeEoList)) {
                    for (AppPaytypeEo appPaytypeEo : appPaytypeEoList) {
                        appPaytypeEo.setAppCode(appRequest.getCode());
                        this.appPaytypeDas.update((BaseEo)appPaytypeEo);
                    }
                }
            }
            PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
            partnerConfigEo.setStoreCode(appEo.getStoreCode());
            partnerConfigEo.setAppCode(appEo.getCode());
            List partnerConfigList = this.partnerConfigDas.select((BaseEo)partnerConfigEo);
            if (CollectionUtils.isNotEmpty((Collection)partnerConfigList)) {
                for (PartnerConfigEo partnerConfig : partnerConfigList) {
                    partnerConfig.setStoreCode(appRequest.getStoreCode());
                    partnerConfig.setAppCode(appRequest.getCode());
                    partnerConfig.setCode(partnerConfig.getPartnerCode() + "-" + appRequest.getCode() + "-" + partnerConfig.getCode().substring(partnerConfig.getCode().lastIndexOf("-") + 1));
                    this.partnerConfigDas.update((BaseEo)partnerConfig);
                }
            }
        }
        AppEo updateEo = AppEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)appRequest, (BaseEo)updateEo);
        updateEo.setId(id);
        this.appDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updatePayCategory(Long id, UpdatePayCategoryRequest payCategoryRequest) throws Exception {
        CategoryEo categoryEo = (CategoryEo)this.categoryDas.selectByPrimaryKey(id);
        if (categoryEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u7c7b\u522b\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_CATEGORY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_CATEGORY"));
        }
        if (!categoryEo.getCode().equals(payCategoryRequest.getCode())) {
            Boolean success = this.cacheService.add(payCategoryRequest.getCode(), (Object)"1", 5);
            if (!success.booleanValue()) {
                this.logger.info("\u652f\u4ed8\u7c7b\u522b\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            CategoryEo temp = CategoryEo.newInstance();
            temp.setCode(payCategoryRequest.getCode());
            int count = this.categoryDas.count((BaseEo)temp);
            if (count > 0) {
                this.logger.error("\u652f\u4ed8\u7c7b\u522b\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            PaytypeEo paytypeEo = PaytypeEo.newInstance();
            paytypeEo.setCatagoryCode(categoryEo.getCode());
            List paytypeEoList = this.paytypeDas.select((BaseEo)paytypeEo);
            for (PaytypeEo paytype : paytypeEoList) {
                paytype.setCatagoryCode(payCategoryRequest.getCode());
                this.paytypeDas.update((BaseEo)paytype);
            }
        }
        CategoryEo updateEo = CategoryEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)payCategoryRequest, (BaseEo)updateEo);
        updateEo.setId(id);
        this.categoryDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updatePayType(Long id, UpdatePayTypeRequest payTypeRequest) throws Exception {
        CategoryEo categoryEo;
        PaytypeEo paytypeEo = (PaytypeEo)this.paytypeDas.selectByPrimaryKey(id);
        if (paytypeEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYTYPE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYTYPE"));
        }
        if (!StringUtils.isBlank((CharSequence)payTypeRequest.getCatagoryCode()) && (categoryEo = (CategoryEo)this.categoryDas.selectByLogicKey((Object)payTypeRequest.getCatagoryCode())) == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u7c7b\u522b\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_CATEGORY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_CATEGORY"));
        }
        if (!paytypeEo.getCode().equals(payTypeRequest.getCode())) {
            Boolean success = this.cacheService.add(payTypeRequest.getCode(), (Object)"1", 5);
            if (!success.booleanValue()) {
                this.logger.info("\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            PaytypeEo temp = PaytypeEo.newInstance();
            temp.setCode(payTypeRequest.getCode());
            int count = this.paytypeDas.count((BaseEo)temp);
            if (count > 0) {
                this.logger.error("\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
            partnerConfigEo.setPayType(paytypeEo.getCode());
            List partnerConfigEoList = this.partnerConfigDas.select((BaseEo)partnerConfigEo);
            if (CollectionUtils.isNotEmpty((Collection)partnerConfigEoList)) {
                for (PartnerConfigEo partnerConfig : partnerConfigEoList) {
                    partnerConfig.setPayType(payTypeRequest.getCode());
                    this.partnerConfigDas.update((BaseEo)partnerConfig);
                }
            }
            GatewayEo gatewayEo = GatewayEo.newInstance();
            gatewayEo.setPayType(paytypeEo.getCode());
            List gatewayEoList = this.gatewayDas.select((BaseEo)gatewayEo);
            if (CollectionUtils.isNotEmpty((Collection)gatewayEoList)) {
                for (GatewayEo gateway : gatewayEoList) {
                    gateway.setPayType(payTypeRequest.getCode());
                    gateway.setCode(payTypeRequest.getCode() + gateway.getPartnerCode() + "0");
                    PartnerEo partnerEo = (PartnerEo)this.partnerDas.selectByLogicKey((Object)gateway.getPartnerCode());
                    gateway.setName((StringUtils.isEmpty((CharSequence)payTypeRequest.getName()) ? paytypeEo.getName() : payTypeRequest.getName()) + "+" + partnerEo.getName() + "-API");
                    this.gatewayDas.update((BaseEo)gateway);
                }
            }
            AppPaytypeEo appPaytypeEo = AppPaytypeEo.newInstance();
            appPaytypeEo.setPayType(paytypeEo.getCode());
            List appPaytypeEoList = this.appPaytypeDas.select((BaseEo)appPaytypeEo);
            for (AppPaytypeEo appPaytype : appPaytypeEoList) {
                appPaytype.setPayType(payTypeRequest.getCode());
                this.appPaytypeDas.update((BaseEo)appPaytype);
            }
        }
        PaytypeEo updateEo = PaytypeEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)payTypeRequest, (BaseEo)updateEo);
        updateEo.setId(id);
        this.paytypeDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updatePayPartner(Long id, UpdatePayPartnerRequest payPartnerRequest) throws Exception {
        PartnerEo partnerEo = (PartnerEo)this.partnerDas.selectByPrimaryKey(id);
        if (partnerEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u6e20\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYPARTNER", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYPARTNER"));
        }
        if (!partnerEo.getCode().equals(payPartnerRequest.getCode())) {
            Boolean success = this.cacheService.add(payPartnerRequest.getCode(), (Object)"1", 5);
            if (!success.booleanValue()) {
                this.logger.info("\u652f\u4ed8\u6e20\u9053\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            PartnerEo temp = PartnerEo.newInstance();
            temp.setCode(payPartnerRequest.getCode());
            int count = this.partnerDas.count((BaseEo)temp);
            if (count > 0) {
                this.logger.error("\u652f\u4ed8\u6e20\u9053\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
            partnerConfigEo.setPartnerCode(partnerEo.getCode());
            List partnerConfigEoList = this.partnerConfigDas.select((BaseEo)partnerConfigEo);
            if (CollectionUtils.isNotEmpty((Collection)partnerConfigEoList)) {
                for (PartnerConfigEo partnerConfig : partnerConfigEoList) {
                    partnerConfig.setPartnerCode(payPartnerRequest.getCode());
                    partnerConfig.setCode(payPartnerRequest.getCode() + "-" + partnerConfig.getAppCode() + "-" + partnerConfig.getCode().substring(partnerConfig.getCode().lastIndexOf("-") + 1));
                    this.partnerConfigDas.update((BaseEo)partnerConfig);
                }
            }
            GatewayEo gatewayEo = GatewayEo.newInstance();
            gatewayEo.setPartnerCode(partnerEo.getCode());
            List gatewayEoList = this.gatewayDas.select((BaseEo)gatewayEo);
            if (CollectionUtils.isNotEmpty((Collection)gatewayEoList)) {
                for (GatewayEo gateway : gatewayEoList) {
                    gateway.setPartnerCode(payPartnerRequest.getCode());
                    gateway.setCode(gateway.getPayType() + payPartnerRequest.getCode() + "0");
                    gateway.setName(gateway.getName().substring(0, gateway.getName().indexOf("+")) + "+" + (StringUtils.isEmpty((CharSequence)payPartnerRequest.getName()) ? partnerEo.getName() : payPartnerRequest.getName()) + "-API");
                    this.gatewayDas.update((BaseEo)gateway);
                }
            }
            AppPaytypeEo apppaytypeEo = AppPaytypeEo.newInstance();
            apppaytypeEo.setPartnerCode(partnerEo.getCode());
            List appPaytypeEoList = this.appPaytypeDas.select((BaseEo)apppaytypeEo);
            if (CollectionUtils.isNotEmpty((Collection)appPaytypeEoList)) {
                for (AppPaytypeEo appPaytypeEo : appPaytypeEoList) {
                    appPaytypeEo.setPartnerCode(payPartnerRequest.getCode());
                    this.appPaytypeDas.update((BaseEo)appPaytypeEo);
                }
            }
        }
        PartnerEo updateEo = PartnerEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)payPartnerRequest, (BaseEo)updateEo);
        updateEo.setId(id);
        this.partnerDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updatePayGateWay(Long id, UpdatePayGateWayRequest payGateWayRequest) throws Exception {
        GatewayEo gatewayEo = (GatewayEo)this.gatewayDas.selectByPrimaryKey(id);
        if (gatewayEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u901a\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYGATEWAY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYGATEWAY"));
        }
        GatewayEo updateEo = GatewayEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)payGateWayRequest, (BaseEo)updateEo);
        updateEo.setId(id);
        if (!gatewayEo.getPayType().equals(payGateWayRequest.getPayType()) || !gatewayEo.getPartnerCode().equals(payGateWayRequest.getPartnerCode())) {
            PaytypeEo paytypeEo = (PaytypeEo)this.paytypeDas.selectByLogicKey((Object)payGateWayRequest.getPayType());
            if (paytypeEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYTYPE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYTYPE"));
            }
            PartnerEo partnerEo = (PartnerEo)this.partnerDas.selectByLogicKey((Object)payGateWayRequest.getPartnerCode());
            if (partnerEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u6e20\u9053\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYPARTNER", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYPARTNER"));
            }
            updateEo.setCode(payGateWayRequest.getPayType() + payGateWayRequest.getPartnerCode() + "0");
            updateEo.setName(paytypeEo.getName() + "+" + partnerEo.getName() + "-API");
            Boolean success = this.cacheService.add(updateEo.getCode(), (Object)"1", 5);
            if (!success.booleanValue()) {
                this.logger.info("\u652f\u4ed8\u901a\u9053\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            PartnerEo temp = PartnerEo.newInstance();
            temp.setCode(updateEo.getCode());
            int count = this.partnerDas.count((BaseEo)temp);
            if (count > 0) {
                this.logger.error("\u652f\u4ed8\u901a\u9053\u5df2\u5b58\u5728");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
        }
        this.gatewayDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updatePayAccount(Long id, UpdateAccountRequest payAccountRequest) throws Exception {
        PartnerEo partnerEo;
        PaytypeEo paytypeEo;
        PartnerConfigEo partnerConfigEo = (PartnerConfigEo)this.partnerConfigDas.selectByPrimaryKey(id);
        if (partnerConfigEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u6536\u6b3e\u8d26\u53f7\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYACCOUNT", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYACCOUNT"));
        }
        PartnerConfigEo updateEo = PartnerConfigEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)payAccountRequest, (BaseEo)updateEo);
        updateEo.setId(id);
        if (!partnerConfigEo.getStoreCode().equals(payAccountRequest.getStoreCode()) || !partnerConfigEo.getAppCode().equals(payAccountRequest.getAppCode())) {
            AppEo appEo = AppEo.newInstance();
            appEo.setStoreCode(payAccountRequest.getStoreCode());
            appEo.setCode(payAccountRequest.getAppCode());
            AppEo appEo1 = (AppEo)this.appDas.selectOne((BaseEo)appEo);
            if (appEo1 == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5546\u6237\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_STORE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_STORE"));
            }
        }
        if (!partnerConfigEo.getPayType().equals(payAccountRequest.getPayType()) && (paytypeEo = (PaytypeEo)this.paytypeDas.selectByLogicKey((Object)payAccountRequest.getPayType())) == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYTYPE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYTYPE"));
        }
        if (!partnerConfigEo.getPartnerCode().equals(payAccountRequest.getPartnerCode()) && (partnerEo = (PartnerEo)this.partnerDas.selectByLogicKey((Object)payAccountRequest.getPartnerCode())) == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u6e20\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYPARTNER", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYPARTNER"));
        }
        if (payAccountRequest.getStatus() != null && Status.getDescByStatus((String)payAccountRequest.getStatus()) == null) {
            throw new ApiException("INVALID_PARAM", ErrorConfigCode.getErrorMsg((String)"INVALID_PARAM"));
        }
        if (StringUtils.isEmpty((CharSequence)payAccountRequest.getPayType()) && StringUtils.isNotEmpty((CharSequence)payAccountRequest.getPartnerCode()) || StringUtils.isNotEmpty((CharSequence)payAccountRequest.getPayType()) && StringUtils.isEmpty((CharSequence)payAccountRequest.getPartnerCode())) {
            throw new ApiException("INVALID_PARAM", ErrorConfigCode.getErrorMsg((String)"INVALID_PARAM"));
        }
        if (!partnerConfigEo.getPartnerCode().equals(payAccountRequest.getPartnerCode()) || !partnerConfigEo.getAppCode().equals(payAccountRequest.getAppCode())) {
            Boolean success = this.cacheService.add(payAccountRequest.getPartnerCode() + payAccountRequest.getAppCode(), (Object)"1", 5);
            if (!success.booleanValue()) {
                this.logger.info("\u6536\u6b3e\u8d26\u53f7\u91cd\u590d");
                throw new ApiException("EXISTING", ErrorConfigCode.getErrorMsg((String)"EXISTING"));
            }
            GatewayEo gateway = GatewayEo.newInstance();
            gateway.setPayType(payAccountRequest.getPayType());
            gateway.setPartnerCode(payAccountRequest.getPartnerCode());
            GatewayEo gatewayEo = (GatewayEo)this.gatewayDas.selectOne((BaseEo)gateway);
            if (gatewayEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u901a\u9053\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYGATEWAY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYGATEWAY"));
            }
            PartnerConfigEo query = PartnerConfigEo.newInstance();
            query.setPartnerCode(payAccountRequest.getPartnerCode());
            query.setAppCode(payAccountRequest.getAppCode());
            query.setPayType(payAccountRequest.getPayType());
            int count = this.partnerConfigDas.count((BaseEo)query);
            updateEo.setCode(payAccountRequest.getPartnerCode() + "-" + payAccountRequest.getPayType() + "-" + payAccountRequest.getAppCode() + "-" + (count + 1));
        }
        this.partnerConfigDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void updateAppAuth(Long id, UpdateAppAuthRequest appAuthRequest) throws Exception {
        PartnerEo partnerEo;
        PaytypeEo paytypeEo1;
        AppEo appEo;
        AppPaytypeEo appPaytypeEo = (AppPaytypeEo)this.appPaytypeDas.selectByPrimaryKey(id);
        if (appPaytypeEo == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5e94\u7528\u6388\u6743\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYAUTH", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYAUTH"));
        }
        if (!appPaytypeEo.getAppCode().equals(appAuthRequest.getAppCode()) && (appEo = (AppEo)this.appDas.selectByLogicKey((Object)appAuthRequest.getAppCode())) == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5e94\u7528\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_APP", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_APP"));
        }
        if (!appPaytypeEo.getPayType().equals(appAuthRequest.getPayType()) && (paytypeEo1 = (PaytypeEo)this.paytypeDas.selectByLogicKey((Object)appAuthRequest.getPayType())) == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYTYPE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYTYPE"));
        }
        if (!appPaytypeEo.getPartnerCode().equals(appAuthRequest.getPartnerCode()) && (partnerEo = (PartnerEo)this.partnerDas.selectByLogicKey((Object)appAuthRequest.getPartnerCode())) == null) {
            this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u6e20\u9053\u7684\u4fe1\u606f");
            throw new ApiException("NOT_FOUND_PAYPARTNER", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYPARTNER"));
        }
        if (!appPaytypeEo.getPartnerCode().equals(appAuthRequest.getPartnerCode()) || !appPaytypeEo.getPayType().equals(appAuthRequest.getPayType())) {
            GatewayEo gateway = GatewayEo.newInstance();
            gateway.setPayType(appPaytypeEo.getPayType());
            gateway.setPartnerCode(appPaytypeEo.getPartnerCode());
            GatewayEo gatewayEo = (GatewayEo)this.gatewayDas.selectOne((BaseEo)gateway);
            if (gatewayEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u901a\u9053\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYGATEWAY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYGATEWAY"));
            }
        }
        AppPaytypeEo updateEo = AppPaytypeEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)appAuthRequest, (BaseEo)updateEo);
        updateEo.setId(id);
        this.appPaytypeDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void deleteStore(Long[] ids) throws Exception {
        for (Long id : ids) {
            StoreEo storeEo = (StoreEo)this.storeDas.selectByPrimaryKey(id);
            if (storeEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5546\u6237\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_STORE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_STORE"));
            }
            AppEo app = AppEo.newInstance();
            app.setStoreCode(storeEo.getCode());
            List applist = this.appDas.select((BaseEo)app);
            if (applist.size() >= 1) {
                for (AppEo apps : applist) {
                    AppEo appe = AppEo.newInstance();
                    appe.setCode(apps.getCode());
                    List appliste = this.appDas.select((BaseEo)appe);
                    if (appliste.size() != 1) continue;
                    AppPaytypeEo appPaytype = AppPaytypeEo.newInstance();
                    appPaytype.setAppCode(appe.getCode());
                    this.appPaytypeDas.delete((BaseEo)appPaytype);
                }
                this.appDas.delete((BaseEo)app);
            }
            PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
            partnerConfigEo.setStoreCode(storeEo.getCode());
            this.partnerConfigDas.delete((BaseEo)partnerConfigEo);
            this.storeDas.delete((BaseEo)storeEo);
        }
    }

    @Override
    public void deleteApp(Long[] ids) throws Exception {
        for (Long id : ids) {
            AppEo appEo = (AppEo)this.appDas.selectByPrimaryKey(id);
            if (appEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5e94\u7528\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_APP", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_APP"));
            }
            AppEo appe = AppEo.newInstance();
            appe.setCode(appEo.getCode());
            List appliste = this.appDas.select((BaseEo)appe);
            if (appliste.size() == 1) {
                AppPaytypeEo appPaytype = AppPaytypeEo.newInstance();
                appPaytype.setAppCode(appEo.getCode());
                this.appPaytypeDas.delete((BaseEo)appPaytype);
                PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
                partnerConfigEo.setAppCode(appEo.getCode());
                this.partnerConfigDas.delete((BaseEo)partnerConfigEo);
            }
            this.appDas.deleteById(id);
        }
    }

    @Override
    public void deletePayCategory(Long[] ids) throws Exception {
        for (Long id : ids) {
            CategoryEo categoryEo = (CategoryEo)this.categoryDas.selectByPrimaryKey(id);
            if (categoryEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u7c7b\u522b\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_CATEGORY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_CATEGORY"));
            }
            PaytypeEo paytypeEo = PaytypeEo.newInstance();
            paytypeEo.setCatagoryCode(categoryEo.getCode());
            List paytypelist = this.paytypeDas.select((BaseEo)paytypeEo);
            for (PaytypeEo paytype : paytypelist) {
                PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
                partnerConfigEo.setPayType(paytype.getCode());
                List partnerlist = this.partnerConfigDas.select((BaseEo)partnerConfigEo);
                for (PartnerConfigEo partnet : partnerlist) {
                    this.partnerConfigDas.deleteById(partnet.getId());
                }
                GatewayEo gatewayEo = GatewayEo.newInstance();
                gatewayEo.setPayType(paytype.getCode());
                List gatewaylist = this.gatewayDas.select((BaseEo)gatewayEo);
                for (GatewayEo list : gatewaylist) {
                    this.gatewayDas.deleteById(list.getId());
                }
                AppPaytypeEo appPaytypeEo = AppPaytypeEo.newInstance();
                appPaytypeEo.setPayType(paytype.getCode());
                List apppaytypelist = this.appPaytypeDas.select((BaseEo)appPaytypeEo);
                for (AppPaytypeEo list : apppaytypelist) {
                    this.appPaytypeDas.deleteById(list.getId());
                }
                this.paytypeDas.deleteById(paytype.getId());
            }
            this.categoryDas.deleteById(id);
        }
    }

    @Override
    public void deletePayType(Long[] ids) throws Exception {
        for (Long id : ids) {
            PaytypeEo paytypeEo = (PaytypeEo)this.paytypeDas.selectByPrimaryKey(id);
            if (paytypeEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYTYPE", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYTYPE"));
            }
            PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
            partnerConfigEo.setPayType(paytypeEo.getCode());
            List partnerlist = this.partnerConfigDas.select((BaseEo)partnerConfigEo);
            for (PartnerConfigEo partnet : partnerlist) {
                this.partnerConfigDas.deleteById(partnet.getId());
            }
            GatewayEo gatewayEo = GatewayEo.newInstance();
            gatewayEo.setPayType(paytypeEo.getCode());
            List gatewaylist = this.gatewayDas.select((BaseEo)gatewayEo);
            for (GatewayEo list : gatewaylist) {
                this.gatewayDas.deleteById(list.getId());
            }
            AppPaytypeEo appPaytypeEo = AppPaytypeEo.newInstance();
            appPaytypeEo.setPayType(paytypeEo.getCode());
            List apppaytypelist = this.appPaytypeDas.select((BaseEo)appPaytypeEo);
            for (AppPaytypeEo list : apppaytypelist) {
                this.appPaytypeDas.deleteById(list.getId());
            }
            this.paytypeDas.deleteById(id);
        }
    }

    @Override
    public void deletePayPartner(Long[] ids) throws Exception {
        for (Long id : ids) {
            PartnerEo partnerEo = (PartnerEo)this.partnerDas.selectByPrimaryKey(id);
            if (partnerEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u6e20\u9053\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYPARTNER", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYPARTNER"));
            }
            PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
            partnerConfigEo.setPartnerCode(partnerEo.getCode());
            List partnerlist = this.partnerConfigDas.select((BaseEo)partnerConfigEo);
            for (PartnerConfigEo partnet : partnerlist) {
                this.partnerConfigDas.deleteById(partnet.getId());
            }
            GatewayEo gatewayEo = GatewayEo.newInstance();
            gatewayEo.setPartnerCode(partnerEo.getCode());
            List gatewaylist = this.gatewayDas.select((BaseEo)gatewayEo);
            for (GatewayEo list : gatewaylist) {
                this.gatewayDas.deleteById(list.getId());
            }
            AppPaytypeEo appPaytypeEo = AppPaytypeEo.newInstance();
            appPaytypeEo.setPartnerCode(partnerEo.getCode());
            List apppaytypelist = this.appPaytypeDas.select((BaseEo)appPaytypeEo);
            for (AppPaytypeEo list : apppaytypelist) {
                this.appPaytypeDas.deleteById(list.getId());
            }
            this.partnerDas.deleteById(id);
        }
    }

    @Override
    public void deletePayGateWay(Long[] ids) throws Exception {
        for (Long id : ids) {
            GatewayEo gatewayEo = (GatewayEo)this.gatewayDas.selectByPrimaryKey(id);
            if (gatewayEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u652f\u4ed8\u901a\u9053\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYGATEWAY", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYGATEWAY"));
            }
            this.gatewayDas.deleteById(id);
        }
    }

    @Override
    public void deletePayAccount(Long[] ids) throws Exception {
        for (Long id : ids) {
            PartnerConfigEo partnerConfigEo = (PartnerConfigEo)this.partnerConfigDas.selectByPrimaryKey(id);
            if (partnerConfigEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u6536\u6b3e\u8d26\u53f7\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYACCOUNT", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYACCOUNT"));
            }
            this.partnerConfigDas.deleteById(id);
        }
    }

    @Override
    public void deleteAppAuth(Long[] ids) throws Exception {
        for (Long id : ids) {
            AppPaytypeEo appPaytypeEo = (AppPaytypeEo)this.appPaytypeDas.selectByPrimaryKey(id);
            if (appPaytypeEo == null) {
                this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u5e94\u7528\u6388\u6743\u7684\u4fe1\u606f");
                throw new ApiException("NOT_FOUND_PAYAUTH", ErrorConfigCode.getErrorMsg((String)"NOT_FOUND_PAYAUTH"));
            }
            this.appPaytypeDas.deleteById(id);
        }
    }

    @Override
    public List<StoreRespDto> queryStore(QueryStoreRequest appRequest) {
        StoreEo storeEo = StoreEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)appRequest, (BaseEo)storeEo);
        List appEos = this.storeDas.select((BaseEo)storeEo);
        ArrayList<StoreRespDto> appdto = new ArrayList<StoreRespDto>();
        DtoHelper.eoList2DtoList((Collection)appEos, appdto, StoreRespDto.class);
        return appdto;
    }

    @Override
    public List<AppRespDto> queryApp(QueryAppRequest queryAppRequest) {
        AppEo appEo = AppEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryAppRequest, (BaseEo)appEo);
        List select = this.appDas.select((BaseEo)appEo);
        ArrayList<AppRespDto> appdto = new ArrayList<AppRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, appdto, AppRespDto.class);
        return appdto;
    }

    @Override
    public AppRespDto queryAppById(Long id) {
        AppEo appEo = (AppEo)this.appDas.selectByPrimaryKey(id);
        AppRespDto appdto = new AppRespDto();
        DtoHelper.eo2Dto((BaseEo)appEo, (BaseVo)appdto);
        return appdto;
    }

    @Override
    public List<CategoryRespDto> queryPayCategory(QueryPayCategoryRequest queryPayCategoryRequest) {
        CategoryEo categoryEo = CategoryEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryPayCategoryRequest, (BaseEo)categoryEo);
        List catelist = this.categoryDas.select((BaseEo)categoryEo);
        ArrayList<CategoryRespDto> categorydto = new ArrayList<CategoryRespDto>();
        DtoHelper.eoList2DtoList((Collection)catelist, categorydto, CategoryRespDto.class);
        return categorydto;
    }

    @Override
    public CategoryRespDto queryPayCategoryById(Long id) {
        CategoryEo categoryEo = (CategoryEo)this.categoryDas.selectByPrimaryKey(id);
        CategoryRespDto appdto = new CategoryRespDto();
        DtoHelper.eo2Dto((BaseEo)categoryEo, (BaseVo)appdto);
        return appdto;
    }

    @Override
    public List<PaytypeRespDto> queryPayType(QueryPayTypeRequest queryPayTypeRequest) {
        PaytypeEo appEo = PaytypeEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryPayTypeRequest, (BaseEo)appEo);
        List select = this.paytypeDas.select((BaseEo)appEo);
        ArrayList<PaytypeRespDto> appdto = new ArrayList<PaytypeRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, appdto, PaytypeRespDto.class);
        return appdto;
    }

    @Override
    public PaytypeRespDto queryPayTypeById(Long id) {
        PaytypeEo paytypeEo = (PaytypeEo)this.paytypeDas.selectByPrimaryKey(id);
        PaytypeRespDto appdto = new PaytypeRespDto();
        DtoHelper.eo2Dto((BaseEo)paytypeEo, (BaseVo)appdto);
        return appdto;
    }

    @Override
    public List<PartnerRespDto> queryPayPartner(QueryPayPartnerRequest queryPayPartnerRequest) {
        PartnerEo appEo = PartnerEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryPayPartnerRequest, (BaseEo)appEo);
        List select = this.partnerDas.select((BaseEo)appEo);
        ArrayList<PartnerRespDto> appdto = new ArrayList<PartnerRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, appdto, PartnerRespDto.class);
        return appdto;
    }

    @Override
    public PartnerRespDto queryPayPartnerById(Long id) {
        PartnerEo paytypeEo = (PartnerEo)this.partnerDas.selectByPrimaryKey(id);
        PartnerRespDto appdto = new PartnerRespDto();
        DtoHelper.eo2Dto((BaseEo)paytypeEo, (BaseVo)appdto);
        return appdto;
    }

    @Override
    public List<GatewayRespDto> queryPayGateWay(QueryPayGateWayRequest queryPayGateWayRequest) {
        GatewayEo appEo = GatewayEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryPayGateWayRequest, (BaseEo)appEo);
        List select = this.gatewayDas.select((BaseEo)appEo);
        ArrayList<GatewayRespDto> appdto = new ArrayList<GatewayRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, appdto, GatewayRespDto.class);
        return appdto;
    }

    @Override
    public GatewayRespDto queryPayGateWayById(Long id) {
        GatewayEo paytypeEo = (GatewayEo)this.gatewayDas.selectByPrimaryKey(id);
        GatewayRespDto appdto = new GatewayRespDto();
        DtoHelper.eo2Dto((BaseEo)paytypeEo, (BaseVo)appdto);
        return appdto;
    }

    @Override
    public StoreRespDto queryStoreById(Long id) {
        StoreEo storeEo = (StoreEo)this.storeDas.selectByPrimaryKey(id);
        StoreRespDto appdto = new StoreRespDto();
        DtoHelper.eo2Dto((BaseEo)storeEo, (BaseVo)appdto);
        return appdto;
    }

    @Override
    public List<PartnerConfigRespDto> queryPayAccountByNoStatus(QueryAccountRequest queryAccountRequest) {
        queryAccountRequest.setStatus("");
        return this.queryPayAccount(queryAccountRequest);
    }

    @Override
    public List<PartnerConfigRespDto> queryPayAccount(QueryAccountRequest queryAccountRequest) {
        PartnerConfigEo partnerConfigEo = PartnerConfigEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryAccountRequest, (BaseEo)partnerConfigEo);
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)queryAccountRequest.getPartnerCode()) && queryAccountRequest.getPartnerCode().indexOf(",") > 0) {
            List<String> list = Arrays.asList(queryAccountRequest.getPartnerCode().split(","));
            filters.add(SqlFilter.in((String)"partnerCode", list));
            partnerConfigEo.setPartnerCode(null);
        }
        if (CollectionUtils.isNotEmpty(filters)) {
            partnerConfigEo.setSqlFilters(filters);
        }
        List partnerConfigEos = this.partnerConfigDas.select((BaseEo)partnerConfigEo);
        ArrayList<PartnerConfigRespDto> partnerConfigRespDto = new ArrayList<PartnerConfigRespDto>();
        DtoHelper.eoList2DtoList((Collection)partnerConfigEos, partnerConfigRespDto, PartnerConfigRespDto.class);
        if (CollectionUtils.isNotEmpty((Collection)partnerConfigEos)) {
            List payTypeList = partnerConfigEos.stream().map(StdPartnerConfigEo::getPayType).collect(Collectors.toList());
            PaytypeEo paytypeEo = PaytypeEo.newInstance();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"code", payTypeList));
            paytypeEo.setSqlFilters(sqlFilters);
            List paytypeEoList = this.paytypeDas.select((BaseEo)paytypeEo);
            if (CollectionUtils.isNotEmpty((Collection)paytypeEoList)) {
                Map<String, String> payNameMap = paytypeEoList.stream().collect(Collectors.toMap(StdPaytypeEo::getCode, StdPaytypeEo::getName));
                partnerConfigRespDto.forEach(partnerConfigRespDto1 -> {
                    if (payNameMap.containsKey(partnerConfigRespDto1.getPayType())) {
                        partnerConfigRespDto1.setPayName((String)payNameMap.get(partnerConfigRespDto1.getPayType()));
                    }
                });
            }
        }
        this.setCertFileName(partnerConfigRespDto);
        return partnerConfigRespDto;
    }

    private void setCertFileName(List<PartnerConfigRespDto> partnerConfigRespDtoList) {
        if (CollectionUtils.isEmpty(partnerConfigRespDtoList)) {
            return;
        }
        List ids = partnerConfigRespDtoList.stream().filter(e -> WX_PARTNER_CODE.equals(e.getPartnerCode())).map(BaseRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        WxCertificateEo wxCertificateEo = WxCertificateEo.newInstance();
        ArrayList<SqlFilter> filterList = new ArrayList<SqlFilter>();
        filterList.add(SqlFilter.in((String)"partnerConfigId", ids));
        wxCertificateEo.setStatus(Integer.valueOf(1));
        List wxCertificateEoList = this.wxCertificateDas.select((BaseEo)wxCertificateEo);
        if (CollectionUtils.isEmpty((Collection)wxCertificateEoList)) {
            return;
        }
        Map<Long, String> fileNameMap = wxCertificateEoList.stream().collect(Collectors.toMap(StdWxCertificateEo::getPartnerConfigId, StdWxCertificateEo::getFileName));
        if (fileNameMap == null || fileNameMap.isEmpty()) {
            return;
        }
        partnerConfigRespDtoList.forEach(e -> {
            if (fileNameMap.containsKey(e.getId())) {
                e.setLcPrivKey((String)fileNameMap.get(e.getId()));
            }
        });
    }

    @Override
    public PartnerConfigRespDto queryPayAccountById(Long id) {
        PartnerConfigEo partnerConfigEo = (PartnerConfigEo)this.partnerConfigDas.selectByPrimaryKey(id);
        PartnerConfigRespDto appdto = new PartnerConfigRespDto();
        ArrayList<PartnerConfigRespDto> list = new ArrayList<PartnerConfigRespDto>();
        list.add(appdto);
        this.setCertFileName(list);
        DtoHelper.eo2Dto((BaseEo)partnerConfigEo, (BaseVo)appdto);
        return appdto;
    }

    @Override
    public List<AppPaytypeRespDto> queryAppAuth(QueryAppAuthRequest queryAppAuthRequest) {
        AppPaytypeEo appPaytypeEo = AppPaytypeEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryAppAuthRequest, (BaseEo)appPaytypeEo);
        List appPaytypeEos = this.appPaytypeDas.select((BaseEo)appPaytypeEo);
        ArrayList<AppPaytypeRespDto> appPaytypeDto = new ArrayList<AppPaytypeRespDto>();
        DtoHelper.eoList2DtoList((Collection)appPaytypeEos, appPaytypeDto, AppPaytypeRespDto.class);
        return appPaytypeDto;
    }

    @Override
    public AppPaytypeRespDto queryAppAuthById(Long id) {
        AppPaytypeEo appPaytypeEo = (AppPaytypeEo)this.appPaytypeDas.selectByPrimaryKey(id);
        AppPaytypeRespDto appPaytypeDto = new AppPaytypeRespDto();
        DtoHelper.eo2Dto((BaseEo)appPaytypeEo, (BaseVo)appPaytypeDto);
        return appPaytypeDto;
    }

    @Override
    public PayConfigQueryRespDto queryPayList(PayConfigQueryReqDto payConfigQueryReqDto) {
        if (Objects.isNull(payConfigQueryReqDto)) {
            return null;
        }
        PayConfigQueryRespDto payConfigQueryRespDto = new PayConfigQueryRespDto();
        QueryAccountRequest queryAccountRequest = payConfigQueryReqDto.getQueryAccountRequest();
        List<PartnerConfigRespDto> partnerConfigRespDtos = this.queryPayAccount(queryAccountRequest);
        payConfigQueryRespDto.setOnlinePayList(partnerConfigRespDtos);
        PageInfo<BankAccountRespDto> bankAccountRespDtoPageInfo = this.bankAccountService.queryByPage(1, 1);
        payConfigQueryRespDto.setOfflineState(Objects.nonNull(bankAccountRespDtoPageInfo) && bankAccountRespDtoPageInfo.getList().size() > 0);
        return payConfigQueryRespDto;
    }
}

