/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.settlement.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PayOrderDas
extends AbstractBaseDas<PayOrderEo, String> {
    public PayOrderEo selectOrder(String tradeId, String storeId, String storeOrderId) {
        PayOrderEo payOrder = null;
        if (StringUtils.isNotBlank((CharSequence)tradeId)) {
            payOrder = (PayOrderEo)this.selectByLogicKey(tradeId);
        } else {
            List<PayOrderEo> payOrders = this.selectByStoreOrderId(storeId, storeOrderId);
            if (!payOrders.isEmpty()) {
                payOrder = payOrders.get(0);
            }
        }
        return payOrder;
    }

    public List<PayOrderEo> selectByStoreOrderId(String storeId, String storeOrderId) {
        PayOrderEo example = PayOrderEo.newInstance();
        example.setStoreCode(storeId);
        example.setStoreOrderId(storeOrderId);
        return this.select((BaseEo)example);
    }

    public PayOrderEo selectOrder(String tradeId, String storeId, String storeOrderId, String status) {
        PayOrderEo payOrder = this.selectOrder(tradeId, storeId, storeOrderId);
        if (null != payOrder && payOrder.getStatus().equals(status)) {
            return payOrder;
        }
        return null;
    }

    public List<PayOrderEo> selectByParentTradeId(String parentTradeId) {
        PayOrderEo example = PayOrderEo.newInstance();
        example.setParentTradeId(parentTradeId);
        return this.select((BaseEo)example);
    }

    public PayOrderEo selectByStoreOrderIdAndGateway(String storeId, String storeOrderId, String gatewayId) {
        PayOrderEo payOrder = PayOrderEo.newInstance();
        payOrder.setStoreOrderId(storeOrderId);
        payOrder.setStoreCode(storeId);
        payOrder.setGatewayCode(gatewayId);
        return (PayOrderEo)this.selectOne((BaseEo)payOrder);
    }

    public void updateSubOrder(String parentTradeId, String status, String gwStatus) {
        PayOrderEo example = PayOrderEo.newInstance();
        example.setStatus(status);
        example.setGwStatus(gwStatus);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.ne((String)"trade_id", (Object)parentTradeId));
        sqlFilters.add(SqlFilter.eq((String)"parent_trade_id", (Object)parentTradeId));
        example.setSqlFilters(sqlFilters);
        this.updateSelectiveSqlFilter((BaseEo)example);
    }
}

