/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception;

import org.springframework.util.StringUtils;

public class ProExceptionCode {
    public static final String SYSTEM_ERR_CODE = "010001";
    public static final String PARAMS_ERR_CODE = "010002";
    public static final String REQUEST_ERR_CODE = "010003";
    public static final String UNKNOWN_ERR_CODE = "010004";
    public static final String RECORD_NOT_EXIST_CODE = "11002";
    public static final String ENGINE_CONFIG_ERR_CODE = "020001";
    public static final String STOCK_EMPTY_CODE = "6010";
    public static final String PARAMETER_ERROR_CODE = "10002";
    public static final String TEMPLATE_NAME_EXISTS_CODE = "11003";
    public static final String TEMPLATE_CODE_EXISTS_CODE = "11004";
    public static final String ACTIVITY_TEMPLATE_CODE_CAN_NOT_BE_NULL_CODE = "11005";
    public static final String ACTIVITY_TEMPLATE_CODE_NOT_EXISTS_CODE = "11006";
    public static final String COUPON_CODE_EXISTS_CODE = "11007";
    public static final String ACTIVITY_NAME_EXISTS_CODE = "11008";
    public static final String ACTIVITY_ALREADY_AUDIT_CODE = "11009";
    public static final String ACTIVITY_STATUS_NOT_ALLOW_DELETE_CODE = "11010";
    public static final String ORDER_ITEM_NOT_ALLOW_EMPTY = "11011";
    public static final String NOT_ELIGIBLE_TO_JOIN = "11012";
    public static final ProExceptionCode SYSTEM_ERR = new ProExceptionCode("010001", "\u7cfb\u7edf\u5f02\u5e38");
    public static final ProExceptionCode PARAMS_ERR = new ProExceptionCode("010002", "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1a{}");
    public static final ProExceptionCode REQUEST_ERR = new ProExceptionCode("010003", "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a{}");
    public static final ProExceptionCode UNKNOWN_ERR = new ProExceptionCode("010004", "\u672a\u77e5\u5f02\u5e38");
    public static final ProExceptionCode RECORD_NOT_EXIST = new ProExceptionCode("11002", "\u8bb0\u5f55\u4e0d\u5b58\u5728\uff1a{}");
    public static final ProExceptionCode ENGINE_CONFIG_ERR = new ProExceptionCode("020001", "\u5f15\u64ce\u914d\u7f6e\u5f02\u5e38\uff1a{}");
    public static final ProExceptionCode STOCK_EMPTY = new ProExceptionCode("6010", "\u5e93\u5b58\u4e0d\u8db3");
    public static final ProExceptionCode PARAMETER_ERROR = new ProExceptionCode("10002", "{}");
    public static final ProExceptionCode TEMPLATE_NAME_EXISTS = new ProExceptionCode("11003", "\u6d3b\u52a8\u6a21\u7248\u540d\u79f0\u5df2\u5b58\u5728");
    public static final ProExceptionCode TEMPLATE_CODE_EXISTS = new ProExceptionCode("11004", "\u6d3b\u52a8\u6a21\u7248\u7f16\u7801\u5df2\u5b58\u5728");
    public static final ProExceptionCode ACTIVITY_TEMPLATE_CODE_CAN_NOT_BE_NULL = new ProExceptionCode("11005", "\u6d3b\u52a8\u6a21\u7248\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
    public static final ProExceptionCode ACTIVITY_TEMPLATE_CODE_NOT_EXISTS = new ProExceptionCode("11006", "\u6d3b\u52a8\u6a21\u7248\u7f16\u7801\u4e0d\u5b58\u5728");
    public static final ProExceptionCode COUPON_CODE_EXISTS = new ProExceptionCode("11007", "\u4f18\u60e0\u5238\u7f16\u7801\u5df2\u5b58\u5728");
    public static final ProExceptionCode ACTIVITY_NAME_EXISTS = new ProExceptionCode("11008", "\u6d3b\u52a8\u540d\u79f0\u5df2\u5b58\u5728");
    public static final ProExceptionCode ACTIVITY_ALREADY_AUDIT = new ProExceptionCode("11009", "\u6d3b\u52a8\u5df2\u5ba1\u6838");
    public static final ProExceptionCode ACTIVITY_STATUS_NOT_ALLOW_DELETE = new ProExceptionCode("11010", "\u6fc0\u6d3b\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664\u6d3b\u52a8");
    public static final ProExceptionCode ORDER_ITEM_NOT_ALLOW_EMPTY_ERR = new ProExceptionCode("11011", "\u4e0b\u5355\u8ba2\u5355\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
    private String code;
    private String message;

    public ProExceptionCode(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ProExceptionCode format(String ... args) {
        ProExceptionCode code = new ProExceptionCode(this.code, this.message);
        if (args != null) {
            String message = this.message;
            for (String arg : args) {
                message = message.replaceFirst("\\{\\}", arg);
            }
            code.setMessage(message);
        }
        return code;
    }

    public String toString() {
        return "ProExceptionCode{code='" + this.code + '\'' + ", message='" + this.message + '\'' + '}';
    }

    public static ProExceptionCode valueOf(String resultCode) {
        if (StringUtils.isEmpty((Object)resultCode)) {
            return UNKNOWN_ERR;
        }
        switch (resultCode) {
            case "010001": {
                return SYSTEM_ERR;
            }
            case "010002": {
                return PARAMS_ERR;
            }
            case "010003": {
                return REQUEST_ERR;
            }
            case "010004": {
                return UNKNOWN_ERR;
            }
            case "11002": {
                return RECORD_NOT_EXIST;
            }
            case "020001": {
                return ENGINE_CONFIG_ERR;
            }
            case "6010": {
                return STOCK_EMPTY;
            }
            case "10002": {
                return PARAMETER_ERROR;
            }
            case "11003": {
                return TEMPLATE_NAME_EXISTS;
            }
            case "11004": {
                return TEMPLATE_CODE_EXISTS;
            }
            case "11005": {
                return ACTIVITY_TEMPLATE_CODE_CAN_NOT_BE_NULL;
            }
            case "11006": {
                return ACTIVITY_TEMPLATE_CODE_NOT_EXISTS;
            }
            case "11007": {
                return COUPON_CODE_EXISTS;
            }
            case "11008": {
                return ACTIVITY_NAME_EXISTS;
            }
            case "11009": {
                return ACTIVITY_ALREADY_AUDIT;
            }
            case "11010": {
                return ACTIVITY_STATUS_NOT_ALLOW_DELETE;
            }
        }
        return SYSTEM_ERR;
    }
}

