/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.CouponRangeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateCreateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateDelayReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateUpdateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.TaskCustomerCouponTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRelationService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IConditionCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.config.CouponConfig;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponItemMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.TaskCustomerCouponTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponItemMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.TaskCustomerCouponTemplateEo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponTemplateExtServiceImpl
implements ICouponTemplateExtService {
    @Autowired
    private CouponTemplateDas couponTemplateDas;
    @Autowired
    private IActivityService activityService;
    @Autowired
    private IActivityExtService activityExtService;
    @Autowired
    private CouponItemMappingDas couponItemMappingDas;
    @Autowired
    private IConditionService conditionService;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private ICouponTemplateStockService couponTemplateStockService;
    @Autowired
    private CouponConfig couponConfig;
    @Autowired
    private IConditionCacheService conditionCacheService;
    @Autowired
    private ICouponTemplateCacheService couponTemplateCacheService;
    @Resource
    private IActivityRelationService activityRelationService;
    @Resource
    private TaskCustomerCouponTemplateDas taskCustomerCouponTemplateDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CouponTemplateEo addCouponTemplate(CouponTemplateCreateExtReqDto couponCreateReqExtDto) {
        ActivityCreateReqDto activityDto = this.createActivityCreateReqDto(couponCreateReqExtDto);
        long activityId = this.activityService.createActivityByOneStep(activityDto);
        CouponTemplateEo couponTemplate = this.createCouponTemplate(couponCreateReqExtDto, activityId);
        this.createCouponItemMapping(couponCreateReqExtDto.getActivityItems(), couponTemplate.getId());
        return couponTemplate;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCouponTemplateById(Long id, CouponTemplateCreateExtReqDto couponCreateReqExtDto) {
        CouponTemplateEo eo = (CouponTemplateEo)this.couponTemplateDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u8be5\u4f18\u60e0\u5238\u6a21\u677fid\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728"}).format(new String[]{"" + id}));
        }
        ActivityCreateReqDto activityDto = this.createActivityCreateReqDto(couponCreateReqExtDto);
        activityDto.getActivityDto().setId(eo.getActivityId());
        this.activityService.modifyActivityByOneStep(eo.getActivityId(), activityDto);
        this.modifyCouponTemplate(couponCreateReqExtDto, eo.getActivityId(), id);
        this.conditionCacheService.deleteConditionListCache(eo.getActivityId());
        this.couponTemplateCacheService.deleteCouponTemplateListCache(id);
        this.couponTemplateDas.removeLogicCache((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editCouponTemplate(CouponTemplateUpdateExtReqDto couponTemplateUpdateExtReqDto) {
        Long couponTemplateId = couponTemplateUpdateExtReqDto.getId();
        CouponTemplateEo couponTemplateEo = this.validateCouponTemplateExist(couponTemplateId);
        if (!couponTemplateEo.getCouponTemplateStatus().equals(CouponTemplateStatusEnum.ACTIVATE.getStatus())) {
            throw new ProBizException("\u6a21\u677f\u72b6\u6001\u672a\u542f\u7528");
        }
        if (!couponTemplateEo.getValidityType().equals(couponTemplateUpdateExtReqDto.getValidityType())) {
            throw new ProBizException(CouponTemplateErrorEnum.OUPON_TEMPLATE_VALIDITY_TYPE_NO_CHANGE.getMsg());
        }
        Long activityId = couponTemplateEo.getActivityId();
        ActivityRespDto activityRespDto = this.activityService.getActivity(couponTemplateEo.getActivityId());
        CouponTemplateEo couponTempateUpdate = new CouponTemplateEo();
        couponTempateUpdate.setId(couponTemplateId);
        couponTempateUpdate.setRemark(couponTemplateUpdateExtReqDto.getRemark());
        couponTempateUpdate.setRuleExplain(couponTemplateUpdateExtReqDto.getRuleExplain());
        couponTempateUpdate.setValidityType(couponTemplateUpdateExtReqDto.getValidityType());
        CouponValidityTypeEnum couponValidityTypeEnum = CouponValidityTypeEnum.findEnum((Integer)couponTemplateUpdateExtReqDto.getValidityType());
        if (couponValidityTypeEnum == CouponValidityTypeEnum.FIXED_DATE) {
            couponTempateUpdate.setEffectiveTime(couponTemplateUpdateExtReqDto.getEffectiveTime());
            couponTempateUpdate.setInvalidTime(couponTemplateUpdateExtReqDto.getInvalidTime());
            ActivityEo activityUpdate = new ActivityEo();
            activityUpdate.setId(activityId);
            activityUpdate.setBeginTime(couponTemplateUpdateExtReqDto.getEffectiveTime());
            activityUpdate.setEndTime(couponTemplateUpdateExtReqDto.getInvalidTime());
            this.activityExtService.updateSelective(activityUpdate);
        } else if (couponValidityTypeEnum == CouponValidityTypeEnum.DYNAMIC_DATE) {
            couponTempateUpdate.setDynamicDate(couponTemplateUpdateExtReqDto.getDynamicDate());
        }
        if (couponTemplateUpdateExtReqDto.getShopType() != null) {
            couponTempateUpdate.setShopType(couponTemplateUpdateExtReqDto.getShopType());
        }
        this.couponTemplateDas.updateSelective((BaseEo)couponTempateUpdate);
        activityRespDto.getConditionDtos().forEach(condition -> {
            ConditionReqDto conditionUpdate = new ConditionReqDto();
            conditionUpdate.setId(condition.getId());
            if (condition.getConditionTemplateId().equals(this.couponConfig.getShopConditionTemplateId()) && (couponTemplateUpdateExtReqDto.getShopRangeType() != null || CollectionUtils.isNotEmpty((Collection)couponTemplateUpdateExtReqDto.getShopList()))) {
                HashMap<String, Object> shopConditionMap = new HashMap<String, Object>();
                shopConditionMap.put("CouponShopCondition.shopRangeType", couponTemplateUpdateExtReqDto.getShopRangeType());
                shopConditionMap.put("CouponShopCondition.shopIds", couponTemplateUpdateExtReqDto.getShopList());
                conditionUpdate.setConditionParams(JSON.toJSONString(shopConditionMap));
            } else if (condition.getConditionTemplateId().equals(this.couponConfig.getItemCondtionTemplateId()) && CollectionUtils.isNotEmpty((Collection)couponTemplateUpdateExtReqDto.getItemList())) {
                HashMap<String, List> itemConditionMap = new HashMap<String, List>();
                itemConditionMap.put("CouponItemsCondition.items", couponTemplateUpdateExtReqDto.getItemList());
                conditionUpdate.setConditionParams(JSON.toJSONString(itemConditionMap));
            } else if (condition.getConditionTemplateId().equals(this.couponConfig.getCategoryConditionTemplateId()) && CollectionUtils.isNotEmpty((Collection)couponTemplateUpdateExtReqDto.getCatalogIds())) {
                HashMap catalogMap = Maps.newHashMap();
                catalogMap.put("CouponCategoryCondition.categories", couponTemplateUpdateExtReqDto.getCatalogIds());
                conditionUpdate.setConditionParams(JSON.toJSONString((Object)catalogMap));
            } else if (condition.getConditionTemplateId().equals(this.couponConfig.getBrandCondtionTemplateId()) && CollectionUtils.isNotEmpty((Collection)couponTemplateUpdateExtReqDto.getBrandList())) {
                HashMap brandMap = Maps.newHashMap();
                brandMap.put("CouponBrandCondition.brands", couponTemplateUpdateExtReqDto.getBrandList());
                conditionUpdate.setConditionParams(JSON.toJSONString((Object)brandMap));
            } else if (condition.getConditionTemplateId().equals(this.couponConfig.getCouponMoneyOffTemplateId()) && couponTemplateUpdateExtReqDto.getCouponMoneyOffDto() != null) {
                HashMap moneyMap = Maps.newHashMap();
                moneyMap.put("CouponMoneyOffCondition.type", couponTemplateEo.getCouponRange());
                moneyMap.put("CouponMoneyOffCondition.condition", couponTemplateUpdateExtReqDto.getCouponMoneyOffDto());
                conditionUpdate.setConditionParams(JSON.toJSONString((Object)moneyMap));
            }
            this.conditionService.modifyCondition(conditionUpdate);
            this.conditionCacheService.deleteConditionListCache(activityId);
        });
        this.couponTemplateCacheService.deleteCouponTemplateListCache(couponTemplateId);
        this.couponTemplateDas.removeLogicCache((BaseEo)couponTemplateEo);
    }

    private ActivityCreateReqDto createActivityCreateReqDto(CouponTemplateCreateExtReqDto couponCreateReqExtDto) {
        ActivityCreateReqDto activityDto = new ActivityCreateReqDto();
        ActivityDto acDto = new ActivityDto();
        acDto.setOriginalActivityId(couponCreateReqExtDto.getOriginalActivityId());
        acDto.setActivityName(couponCreateReqExtDto.getCouponName());
        acDto.setActivityStatusEnum(couponCreateReqExtDto.getActivityStatusEnum());
        acDto.setActivityTemplateId(couponCreateReqExtDto.getActivityTemplateId());
        acDto.setAuditStatusEnum(couponCreateReqExtDto.getAuditStatusEnum());
        acDto.setTag(couponCreateReqExtDto.getTag());
        acDto.setBeginTime(new Date());
        Integer years = 3;
        acDto.setEndTime(DateUtil.addYear((Date)new Date(), (int)years));
        acDto.setExecExpression(couponCreateReqExtDto.getExecExpression());
        acDto.setRemark(couponCreateReqExtDto.getRemark());
        acDto.setInstanceId(couponCreateReqExtDto.getInstanceId());
        acDto.setTenantId(couponCreateReqExtDto.getTenantId());
        acDto.setSellerId(couponCreateReqExtDto.getSellerId());
        acDto.setShopId(couponCreateReqExtDto.getShopId());
        acDto.setActivityCode(couponCreateReqExtDto.getCouponCode());
        acDto.setOrganizationId(couponCreateReqExtDto.getOrganizationId());
        acDto.setOrganizationName(couponCreateReqExtDto.getOrganizationName());
        acDto.setSelectType(couponCreateReqExtDto.getSelectType());
        acDto.setSelectCustomer(couponCreateReqExtDto.getSelectCustomer());
        activityDto.setActivityDto(acDto);
        activityDto.setActions(couponCreateReqExtDto.getActions());
        activityDto.setConditions(couponCreateReqExtDto.getConditions());
        activityDto.setActivityRelations(couponCreateReqExtDto.getActivityRelations());
        BizActivityType bizType = this.getBizActivityType(couponCreateReqExtDto);
        activityDto.setBizActivityType(bizType);
        return activityDto;
    }

    private BizActivityType getBizActivityType(CouponTemplateCreateExtReqDto couponCreateReqExtDto) {
        if (CouponCategoryEnum.EXTRACT.getCategory().equals(couponCreateReqExtDto.getCouponCategory())) {
            return BizActivityType.EXCHANGE_COUPON_ACTIVITY;
        }
        if (CouponRangeEnum.SELLER.getKey().equals(couponCreateReqExtDto.getCouponRange())) {
            return BizActivityType.SHOP_COUPON_ACTIVITY;
        }
        if (Objects.nonNull(couponCreateReqExtDto.getActivityTemplateId()) && couponCreateReqExtDto.getActivityTemplateId().equals(BizActivityType.COUPON_TOB_ACTIVITY.getId())) {
            return BizActivityType.COUPON_TOB_ACTIVITY;
        }
        return BizActivityType.COUPON_ACTIVITY;
    }

    private CouponTemplateEo createCouponTemplate(CouponTemplateCreateExtReqDto couponCreateReqExtDto, Long activityId) {
        CouponTemplateEo couponTemplateEo = new CouponTemplateEo();
        couponTemplateEo.setCouponCode(couponCreateReqExtDto.getCouponCode());
        if (this.couponTemplateDas.count((BaseEo)couponTemplateEo) > 0) {
            throw new ProBusinessRuntimeException(ProExceptionCode.COUPON_CODE_EXISTS);
        }
        DtoHelper.dto2Eo((BaseVo)couponCreateReqExtDto, (BaseEo)couponTemplateEo);
        couponTemplateEo.setRemainingQuantity(couponCreateReqExtDto.getTotalIssueQuantity());
        couponTemplateEo.setInstanceId(couponCreateReqExtDto.getInstanceId());
        couponTemplateEo.setTenantId(couponCreateReqExtDto.getTenantId());
        couponTemplateEo.setAmount(couponCreateReqExtDto.getAmount());
        couponTemplateEo.setActivityId(activityId);
        couponTemplateEo.setInvalidTime(couponCreateReqExtDto.getInvalidTime());
        couponTemplateEo.setEffectiveTime(couponCreateReqExtDto.getEffectiveTime());
        couponTemplateEo.setStatus(EnableStatusEnum.ENABLE.getKey());
        if (couponCreateReqExtDto.getExtFields() != null) {
            couponTemplateEo.setExtension(JacksonUtil.toJson((Object)couponCreateReqExtDto.getExtFields()));
        }
        this.couponTemplateDas.insert((BaseEo)couponTemplateEo);
        return couponTemplateEo;
    }

    private void modifyCouponTemplate(CouponTemplateCreateExtReqDto couponCreateReqExtDto, Long activityId, Long id) {
        CouponTemplateEo couponTemplateEo = new CouponTemplateEo();
        couponTemplateEo.setCouponCode(couponCreateReqExtDto.getCouponCode());
        couponTemplateEo = (CouponTemplateEo)this.couponTemplateDas.selectOne((BaseEo)couponTemplateEo);
        if (Objects.nonNull(couponTemplateEo) && !couponTemplateEo.getId().equals(id)) {
            throw new ProBusinessRuntimeException(ProExceptionCode.COUPON_CODE_EXISTS);
        }
        DtoHelper.dto2Eo((BaseVo)couponCreateReqExtDto, (BaseEo)couponTemplateEo);
        couponTemplateEo.setRemainingQuantity(couponCreateReqExtDto.getTotalIssueQuantity());
        couponTemplateEo.setInstanceId(couponCreateReqExtDto.getInstanceId());
        couponTemplateEo.setTenantId(couponCreateReqExtDto.getTenantId());
        couponTemplateEo.setAmount(couponCreateReqExtDto.getAmount());
        couponTemplateEo.setActivityId(activityId);
        couponTemplateEo.setInvalidTime(couponCreateReqExtDto.getInvalidTime());
        couponTemplateEo.setEffectiveTime(couponCreateReqExtDto.getEffectiveTime());
        couponTemplateEo.setStatus(EnableStatusEnum.ENABLE.getKey());
        couponTemplateEo.setId(id);
        if (couponCreateReqExtDto.getExtFields() != null) {
            couponTemplateEo.setExtension(JacksonUtil.toJson((Object)couponCreateReqExtDto.getExtFields()));
        }
        this.couponTemplateDas.updateSelective((BaseEo)couponTemplateEo);
    }

    private void createCouponItemMapping(List<CouponItemReqDto> activityItemDtoList, Long couponTemplateId) {
        if (CollectionUtils.isNotEmpty(activityItemDtoList)) {
            ArrayList activityItemEoList = new ArrayList();
            activityItemDtoList.forEach(itemDto -> {
                CouponItemMappingEo couponItemMappingEo = BeanCopyUtil.copyProperties(CouponItemMappingEo.class, itemDto, new String[0]);
                couponItemMappingEo.setCouponTemplateId(couponTemplateId);
                activityItemEoList.add(couponItemMappingEo);
            });
            this.couponItemMappingDas.insertBatch(activityItemEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invalid(Long id) {
        CouponTemplateEo couponTemplateEo = this.validateCouponTemplateExist(id);
        CouponTemplateStatusEnum statusEnum = CouponTemplateStatusEnum.findEnum((String)couponTemplateEo.getCouponTemplateStatus());
        if (statusEnum == null) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_STATUS_EXIST.getMsg());
        }
        if (statusEnum == CouponTemplateStatusEnum.INVALID) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_STATUS_ALREADY_INVALID.getMsg());
        }
        CouponTemplateEo update = new CouponTemplateEo();
        update.setId(id);
        update.setCouponTemplateStatus(CouponTemplateStatusEnum.INVALID.getStatus());
        this.couponTemplateDas.updateSelective((BaseEo)update);
        this.couponTemplateDas.removeLogicCache((BaseEo)couponTemplateEo);
        this.couponTemplateCacheService.deleteCouponTemplateListCache(id);
        this.activityService.finish(couponTemplateEo.getActivityId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void log(Long id) {
        CouponTemplateEo couponTemplateEo = this.validateCouponTemplateExist(id);
        CouponTemplateStatusEnum statusEnum = CouponTemplateStatusEnum.findEnum((String)couponTemplateEo.getCouponTemplateStatus());
        if (statusEnum == null) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_STATUS_EXIST.getMsg());
        }
        if (statusEnum == CouponTemplateStatusEnum.LOG) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_STATUS_ALREADY_LOG.getMsg());
        }
        CouponTemplateEo update = new CouponTemplateEo();
        update.setId(id);
        update.setCouponTemplateStatus(CouponTemplateStatusEnum.LOG.getStatus());
        this.couponTemplateDas.updateSelective((BaseEo)update);
        this.couponTemplateDas.removeLogicCache((BaseEo)couponTemplateEo);
        this.couponTemplateCacheService.deleteCouponTemplateListCache(id);
        this.activityService.finish(couponTemplateEo.getActivityId());
    }

    @Override
    public void setStatus(Long id, String status) {
        CouponTemplateEo couponTemplateEo = this.validateCouponTemplateExist(id);
        CouponTemplateStatusEnum statusEnum = CouponTemplateStatusEnum.findEnum((String)status);
        if (statusEnum == null) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_STATUS_EXIST.getMsg());
        }
        if (statusEnum == CouponTemplateStatusEnum.INVALID) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_STATUS_ALREADY_INVALID.getMsg());
        }
        CouponTemplateEo update = new CouponTemplateEo();
        update.setId(id);
        update.setCouponTemplateStatus(statusEnum.getStatus());
        this.couponTemplateDas.updateSelective((BaseEo)update);
        this.couponTemplateDas.removeLogicCache((BaseEo)couponTemplateEo);
        this.couponTemplateCacheService.deleteCouponTemplateListCache(id);
    }

    @Override
    public void delay(CouponTemplateDelayReqDto couponTemplateDelayReqDto) {
        if (null == couponTemplateDelayReqDto) {
            throw new ProBizException(CouponTemplateErrorEnum.PARAMS_EXIST.getMsg());
        }
        if (null == couponTemplateDelayReqDto.getInvalidTime()) {
            throw new ProBizException(CouponTemplateErrorEnum.INVALIDTIME_EXIST.getMsg());
        }
        CouponTemplateEo couponTemplateEo = this.validateCouponTemplateExist(couponTemplateDelayReqDto.getId());
        if (CouponValidityTypeEnum.DYNAMIC_DATE.getType().equals(couponTemplateEo.getValidityType())) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_DYNAMIC_DATE_NOT_DELAY.getMsg());
        }
        if (couponTemplateDelayReqDto.getInvalidTime().before(couponTemplateEo.getInvalidTime())) {
            throw new ProBizException(CouponTemplateErrorEnum.INVALIDTIME_BEFORE.getMsg());
        }
        CouponTemplateEo update = new CouponTemplateEo();
        update.setId(couponTemplateDelayReqDto.getId());
        update.setInvalidTime(couponTemplateDelayReqDto.getInvalidTime());
        this.couponTemplateDas.updateSelective((BaseEo)update);
        this.couponTemplateDas.removeLogicCache((BaseEo)couponTemplateEo);
        this.couponTemplateCacheService.deleteCouponTemplateListCache(couponTemplateEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchActivate(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<CouponTemplateExtRespDto> couponTemplateEoList = this.couponTemplateExtQueryService.listByIds(ids);
        List couponTemplateNames = couponTemplateEoList.stream().filter(couponTemplateEo -> !couponTemplateEo.getCouponTemplateStatus().equals(CouponTemplateStatusEnum.CREATE.getStatus())).map(CouponTemplateExtRespDto::getCouponName).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(couponTemplateNames)) {
            throw new ProBizException("\u6a21\u677f\u72b6\u6001\u4e0d\u662f\u5df2\u521b\u5efa");
        }
        couponTemplateNames = couponTemplateEoList.stream().filter(couponTemplateEo -> {
            if (couponTemplateEo.getInvalidTime() == null) {
                return false;
            }
            return CouponValidityTypeEnum.FIXED_DATE.getType().equals(couponTemplateEo.getValidityType()) && new Date().after(couponTemplateEo.getInvalidTime());
        }).map(CouponTemplateExtRespDto::getCouponName).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(couponTemplateNames)) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_BATCH_ACTIVE_EXPIRE.getMsg());
        }
        couponTemplateEoList.forEach(couponTemplateEo -> {
            CouponTemplateEo update = new CouponTemplateEo();
            update.setId(couponTemplateEo.getId());
            update.setCouponTemplateStatus(CouponTemplateStatusEnum.ACTIVATE.getStatus());
            this.couponTemplateDas.updateSelective((BaseEo)update);
        });
    }

    @Override
    public void delete(Long id) {
        CouponTemplateEo eo = (CouponTemplateEo)this.couponTemplateDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u8be5\u4f18\u60e0\u5238\u6a21\u677fid\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728"}).format(new String[]{"" + id}));
        }
        this.activityService.delete(eo.getActivityId());
        this.couponTemplateDas.logicDeleteById(id);
    }

    @Override
    public void updateDbStockByJob() {
        List<CouponTemplateEo> couponTemplateList = this.couponTemplateExtQueryService.listAllEffective();
        couponTemplateList.forEach(couponTemplateEo -> {
            Long availableStock = this.couponTemplateStockService.getAvailableStock(couponTemplateEo.getId());
            if (null != availableStock) {
                CouponTemplateEo update = new CouponTemplateEo();
                update.setId(couponTemplateEo.getId());
                update.setRemainingQuantity(availableStock);
                this.couponTemplateDas.updateSelective((BaseEo)update);
            }
        });
    }

    @Override
    public void initStock() {
        List<CouponTemplateEo> couponTemplateList = this.couponTemplateExtQueryService.listAllEffective();
        couponTemplateList.forEach(couponTemplateEo -> this.couponTemplateStockService.initStock(couponTemplateEo.getId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustTmplByMember(List<TaskCustomerCouponTemplateReqDto> taskCustomerCouponTemplateReqDtos) {
        if (CollectionUtils.isNotEmpty(taskCustomerCouponTemplateReqDtos)) {
            LinkedList taskCustomerCouponTemplateEos = new LinkedList();
            DtoHelper.dtoList2EoList(taskCustomerCouponTemplateReqDtos, taskCustomerCouponTemplateEos, TaskCustomerCouponTemplateEo.class);
            this.taskCustomerCouponTemplateDas.insertBatch(taskCustomerCouponTemplateEos);
            return 0L;
        }
        return null;
    }

    @Override
    public void deleteCustTmplByTaskId(Long taskId) {
        TaskCustomerCouponTemplateEo logicDelete = new TaskCustomerCouponTemplateEo();
        logicDelete.setTaskId(taskId);
        this.taskCustomerCouponTemplateDas.logicDelete((BaseEo)logicDelete);
    }

    private CouponTemplateEo validateCouponTemplateExist(Long id) {
        CouponTemplateEo couponTemplateEo = (CouponTemplateEo)this.couponTemplateDas.selectByPrimaryKey(id);
        if (null == couponTemplateEo) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
        }
        return couponTemplateEo;
    }
}

