/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ObjectType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.PromotionUnit;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ReturnType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PresentDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.ProportionUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.AbstractConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.DiscountType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.PromotionCategory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.enums.Stair;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.vo.ReturnAndGiftConditionVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.IPresentQueryService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;

public class ReturnAndGiftCondition
extends AbstractConditionTemplate<ReturnAndGiftConditionVo> {
    private static final String CONDITION = "ReturnAndGiftCondition.condition";
    private static final String TYPE = "ReturnAndGiftCondition.type";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        List conditionVos = this.sort((List)this.getParam(CONDITION, templateDefine, configParams, "\u8fd4\u8d60\u914d\u7f6e\u672a\u914d\u7f6e"));
        Integer discountTypeInt = (Integer)this.getParam(TYPE, templateDefine, configParams, "\u4fc3\u9500\u7c7b\u522b\u672a\u914d\u7f6e");
        DiscountType discountType = DiscountType.getByType(discountTypeInt);
        double totalAmt = context.getItems().stream().mapToDouble(itemVo -> {
            BigDecimal payAmt = MapUtils.getBigDecimal((Map)itemVo.getExtendsAttribute(), (Object)"payAmt");
            if (payAmt == null) {
                return itemVo.getPrice().setScale(6, 2).doubleValue() * (double)itemVo.getNum();
            }
            BigDecimal disPrice = payAmt.divide(new BigDecimal(itemVo.getNum()), 6, 2);
            itemVo.setDiscountPrice(disPrice);
            return payAmt.doubleValue();
        }).sum();
        BigDecimal itemTotalAmt = BigDecimal.valueOf(totalAmt);
        Integer itemTotalNum = this.getItemTotalNum(context.getItems());
        Stair stair = Stair.newStair();
        boolean result = false;
        for (ReturnAndGiftConditionVo conditionVo : conditionVos) {
            PromotionCategory promotionCategory = PromotionCategory.getByType(conditionVo.getCondition());
            result |= this.switchPromotionCategory(promotionCategory, stair, context, itemTotalAmt, itemTotalNum, discountType, conditionVo);
        }
        if (!result) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u4e0d\u6ee1\u8db3\u53c2\u4e0e\u6d3b\u52a8\u6761\u4ef6"}));
        }
        return result;
    }

    @Override
    public <T extends EngineParams> boolean eachFull(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, ReturnAndGiftConditionVo conditionConfig) {
        if (conditionConfig.getLimitAmount().compareTo(BigDecimal.ZERO) > 0) {
            int discountCount = 0;
            if (Objects.equals(conditionConfig.getPriceType(), PromotionUnit.PIECE.getType())) {
                if (itemTotalNum > 0) {
                    discountCount = BigDecimal.valueOf(itemTotalNum.intValue()).divide(conditionConfig.getLimitAmount(), 0, 1).intValue();
                }
            } else if (itemTotalAmt.compareTo(BigDecimal.ZERO) > 0) {
                discountCount = itemTotalAmt.divide(conditionConfig.getLimitAmount(), 0, 1).intValue();
            }
            if (discountCount > 0) {
                conditionConfig.setReturnNum(conditionConfig.getReturnNum() * (double)discountCount);
                this.handleDiscount(context, itemTotalAmt, discountType, conditionConfig);
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends EngineParams> void handleDiscount(T context, BigDecimal itemTotalAmt, DiscountType discountType, ReturnAndGiftConditionVo conditionConfig) {
        switch (discountType) {
            case FULL_RETURN: {
                this.handleReturn(context, itemTotalAmt, conditionConfig);
                break;
            }
            case FULL_GIFT: {
                this.handleGift(context, itemTotalAmt, conditionConfig);
                break;
            }
            default: {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6298\u6263\u7c7b\u578b\u6709\u8bef"}));
            }
        }
    }

    private <T extends EngineParams> void handleReturn(T context, BigDecimal itemTotalAmt, ReturnAndGiftConditionVo conditionConfig) {
        ReturnType returnType = conditionConfig.getReturnType();
        switch (returnType) {
            case POINT: {
                BigDecimal returnPoints = BigDecimal.valueOf(conditionConfig.getReturnNum());
                ProportionUtil.setPoint2Context(context, returnPoints);
                this.avgDisPoints(context.getItems(), itemTotalAmt, returnPoints);
                break;
            }
            case COUPON: {
                Long couponGroup = conditionConfig.getObjGroupId();
                Map extendsAttribute = context.getExtendsAttribute();
                PresentDetailRespDto present = ((IPresentQueryService)SpringBeanUtil.getBean(IPresentQueryService.class)).queryDetailById(couponGroup);
                if (present == null || !CollectionUtils.isNotEmpty((Collection)present.getPresentList())) break;
                HashMap couponMap = Maps.newHashMap();
                present.getPresentList().forEach(coupon -> {
                    if (conditionConfig.getObjectType().equals((Object)ObjectType.SINGLE)) {
                        couponMap.put(coupon.getCode(), (int)conditionConfig.getReturnNum());
                    } else {
                        couponMap.put(coupon.getCode(), coupon.getNum());
                    }
                });
                Map sourceCoupons = (Map)MapUtils.getObject((Map)extendsAttribute, (Object)"returnCoupon", new HashMap(1));
                Map<String, Integer> result = Stream.concat(couponMap.entrySet().stream(), sourceCoupons.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
                sourceCoupons.putAll(result);
                extendsAttribute.put("returnCoupon", sourceCoupons);
                break;
            }
            default: {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6298\u6263\u7c7b\u578b\u6709\u8bef"}));
            }
        }
    }

    private <T extends EngineParams> void handleGift(T context, BigDecimal itemTotalAmt, ReturnAndGiftConditionVo conditionConfig) {
        ReturnType returnType = conditionConfig.getReturnType();
        switch (returnType) {
            case ITEM: {
                HashMap giftMap = Maps.newHashMap();
                Long giftGroupId = conditionConfig.getObjGroupId();
                HashMap itemMap = Maps.newHashMap();
                ArrayList itemCodeList = Lists.newArrayList();
                PresentDetailRespDto present = ((IPresentQueryService)SpringBeanUtil.getBean(IPresentQueryService.class)).queryDetailById(giftGroupId);
                if (present != null && CollectionUtils.isNotEmpty((Collection)present.getPresentList())) {
                    present.getPresentList().forEach(item -> {
                        itemMap.put(item.getCode(), item.getNum());
                        itemCodeList.add(item.getCode());
                    });
                }
                if (MapUtils.isNotEmpty((Map)itemMap)) {
                    if (conditionConfig.getObjectType().equals((Object)ObjectType.SINGLE)) {
                        itemMap.forEach((item, num) -> giftMap.put(item, (int)conditionConfig.getReturnNum()));
                    } else if (conditionConfig.isRandom()) {
                        Map<String, Integer> randomMap = this.random(itemMap);
                        giftMap.putAll(randomMap);
                    } else {
                        if (CollectionUtils.isEmpty((Collection)context.getGifts())) {
                            return;
                        }
                        List giftVos = context.getGifts();
                        for (ItemVo gift : giftVos) {
                            String giftCode = gift.getItemId();
                            if (!this.checkChoiceGiftIds(itemCodeList, giftCode)) continue;
                            giftMap.put(giftCode, itemMap.get(giftCode));
                            giftVos.remove(gift);
                            break;
                        }
                    }
                }
                Map extendsAttribute = context.getExtendsAttribute();
                Map sourceGifts = (Map)MapUtils.getObject((Map)extendsAttribute, (Object)"returnGift", new HashMap(1));
                Map<String, Integer> result = Stream.concat(giftMap.entrySet().stream(), sourceGifts.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
                sourceGifts.putAll(result);
                extendsAttribute.put("returnGift", sourceGifts);
                break;
            }
            case POSTAGE: {
                BigDecimal freight = context.getFreight();
                if (freight == null || freight.compareTo(BigDecimal.ZERO) <= 0) break;
                context.setTotalDiscountFreight(context.getTotalDiscountFreight().add(freight));
                context.setFreight(BigDecimal.ZERO);
                break;
            }
            default: {
                throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u8fd4\u8d60\u7c7b\u578b\u6709\u8bef"}));
            }
        }
    }

    private boolean checkChoiceGiftIds(List<String> giftCodes, String choiceGiftCode) {
        return giftCodes.contains(choiceGiftCode);
    }

    private Map<String, Integer> random(Map<String, Integer> itemMap) {
        ArrayList<String> keys = new ArrayList<String>(itemMap.keySet());
        Random random = new Random();
        String key = (String)keys.get(random.nextInt(keys.size()));
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(key, itemMap.get(key));
        return resultMap;
    }

    @Override
    public <T extends EngineParams> boolean equal(T context, BigDecimal itemTotalAmt, Integer itemTotalNum, DiscountType discountType, ReturnAndGiftConditionVo conditionConfig) {
        throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6ee1\u8fd4\u6ee1\u8d60\u4e0d\u80fd\u542b\u6709\"\u7b49\u4e8e\"\u6761\u4ef6"}));
    }

    private <T extends EngineParams> void avgDisPoints(List<ItemVo> itemVos, BigDecimal totalItemAmt, BigDecimal totalDiscountAmt) {
        BigDecimal hasCalculate = BigDecimal.ZERO;
        for (int i = 0; i < itemVos.size(); ++i) {
            BigDecimal currItemDiscountAmt;
            ItemVo currItem = itemVos.get(i);
            BigDecimal payAmt = MapUtils.getBigDecimal((Map)currItem.getExtendsAttribute(), (Object)"payAmt");
            BigDecimal currItemPayAmt = payAmt == null ? currItem.getDiscountPrice().multiply(BigDecimal.valueOf(currItem.getNum())) : payAmt;
            BigDecimal percentage = currItemPayAmt.divide(totalItemAmt, 6, 2);
            if (i == itemVos.size() - 1) {
                currItemDiscountAmt = totalDiscountAmt.subtract(hasCalculate);
                ProportionUtil.setPoint2extendsAttribute(currItem, currItemDiscountAmt);
                continue;
            }
            currItemDiscountAmt = percentage.multiply(totalDiscountAmt).setScale(0, 1);
            hasCalculate = hasCalculate.add(currItemDiscountAmt);
            ProportionUtil.setPoint2extendsAttribute(currItem, currItemDiscountAmt);
        }
    }
}

