/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.tag.dto.ActivityStatusChangeMessage;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IItemActivityPriceService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ACTIVITY_STATUS_CHANGE")
public class ActivityStatusChangeProcessor
implements IMessageProcessor<ActivityStatusChangeMessage> {
    private static Logger logger = LoggerFactory.getLogger(ActivityStatusChangeProcessor.class);
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private ICommonsMqService commonsMqService;
    private static Map<Integer, Long> msgDelayTime = Maps.newHashMap();
    @Resource
    private ICacheService cacheService;
    @Resource
    private IActivityItemService activityItemService;
    @Resource
    private IActivityService activityService;
    @Resource
    private IItemActivityPriceService itemActivityPriceService;

    public MessageResponse process(ActivityStatusChangeMessage message) {
        logger.info("\u6536\u5230\u6d3b\u52a8\u72b6\u6001\u53d8\u66f4\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
        if (ActivityStatusEnum.READY.equals((Object)message.getActivityStatus())) {
            boolean lock = this.cacheService.add(message.getBizId(), (Object)message.getBizId(), 604800);
            if (!lock) {
                logger.info("\u6d3b\u52a8\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5df2\u7ecf\u5904\u7406\u8fc7, bizId={}", (Object)message.getBizId());
                return MessageResponse.SUCCESS;
            }
            try {
                this.itemActivityTagService.saveItemActivityTagByActivityId(message.getActivityId());
            }
            catch (Exception e) {
                logger.error("\u5546\u54c1\u6d3b\u52a8\u6807\u7b7e\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
        }
        if (ActivityStatusEnum.FINISH.equals((Object)message.getActivityStatus()) || ActivityStatusEnum.PAUSE.equals((Object)message.getActivityStatus())) {
            try {
                this.itemActivityTagService.deleteItemActivityTag(message.getActivityId());
            }
            catch (Exception e) {
                if (null != msgDelayTime.get(message.getRetryCount())) {
                    logger.info("{}\u79d2\u540e\u53d1\u9001\u5220\u9664\u5546\u54c1\u6d3b\u52a8\u6807\u7b7e\u91cd\u8bd5\u901a\u77e5", (Object)message.getRetryCount());
                    message.setRetryCount(Integer.valueOf(message.getRetryCount() + 1));
                    this.commonsMqService.sendDelaySingleMessage("ACTIVITY_STATUS_CHANGE", (Object)message, msgDelayTime.get(message.getRetryCount()));
                }
                logger.error("\u5546\u54c1\u6d3b\u52a8\u6807\u7b7e\u5220\u9664\u5931\u8d25", (Throwable)e);
            }
        }
        return MessageResponse.SUCCESS;
    }

    static {
        msgDelayTime.put(0, 1L);
        msgDelayTime.put(1, 3L);
        msgDelayTime.put(2, 15L);
        msgDelayTime.put(3, 60L);
        msgDelayTime.put(4, 180L);
        msgDelayTime.put(5, 900L);
        msgDelayTime.put(6, 3600L);
    }
}

