/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.schedule;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.schedule.CouponTemplateStockSchedule;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
public class StockScheduleCreateService
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(StockScheduleCreateService.class);
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;

    public void createCouponTemplateStockTaskSchedule() {
        String bizName = "\u4f18\u60e0\u5238\u5e93\u5b58\u7ba1\u7406\u6267\u884c\u4efb\u52a1";
        CouponTemplateStockSchedule couponTemplateStockSchedule = new CouponTemplateStockSchedule();
        Component component = ((Object)((Object)couponTemplateStockSchedule)).getClass().getAnnotation(Component.class);
        String bizCode = component.value();
        TaskAndBizCreateReqDto coupon = new TaskAndBizCreateReqDto();
        coupon.setAppCode(this.appCode);
        coupon.setBizCode(bizCode);
        coupon.setBizName(bizName);
        coupon.setParams("");
        String cron = "0 0/5 * * * ?";
        coupon.setScheduleExpression(cron);
        coupon.setShardType("SINGLE");
        coupon.setTaskBatchId(null);
        coupon.setTaskDesc(bizName);
        coupon.setTaskName(String.format("%s:%s", bizName, cron));
        coupon.setInstanceId(Long.valueOf(-1L));
        coupon.setTenantId(Long.valueOf(-1L));
        try {
            RestResponse addResult = this.taskApi.addWithBiz(coupon);
            if ("0".equals(addResult.getResultCode())) {
                logger.info("\u542f\u7528\u4efb\u52a1\uff1a{}", addResult.getData());
                this.taskApi.enableById((Long)addResult.getData(), "{}");
            } else {
                logger.warn("\u521b\u5efa\u4efb\u52a1\u5931\u8d25\uff1a{}", (Object)addResult.getResultMsg());
            }
        }
        catch (Exception e) {
            logger.error("\u51fa\u73b0\u5f02\u5e38========{}", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.createCouponTemplateStockTaskSchedule();
    }
}

