/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponUseTimeDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.CouponDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.CouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.CouponTemplateDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.ExchangeItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.MatchCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.ICoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.ICouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.CouponTemplateImpl;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.MarketingModuleHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponImpl
implements ICoupon {
    private static Logger logger = LoggerFactory.getLogger(CouponTemplateImpl.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Resource(name="couponEsQueryApi")
    private ICouponExtQueryApi couponExtQueryApi;
    @Resource
    private ICouponTemplate couponTemplate;
    @Resource
    private IItem itemService;

    @Override
    public List<CouponExtRespDto> queryMemberCoupons(Long memberId, Integer couponRange) {
        return this.queryMemberCoupons(memberId, couponRange, null);
    }

    @Override
    public List<CouponExtRespDto> queryMemberCoupons(Long memberId, Integer couponRange, List<Integer> couponCategoryList) {
        List<Object> couponList = Lists.newArrayList();
        String currentStr = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date());
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)memberId));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_status", (Object)CouponStatusEnum.CREATE.getStatus()));
        sqlFilterList.add(SqlFilter.le((String)"effective_time", (Object)currentStr));
        sqlFilterList.add(SqlFilter.gt((String)"invalid_time", (Object)currentStr));
        Criteria criteria = new Criteria();
        criteria.setFilters((List)sqlFilterList);
        String filter = ObjectHelper.bean2Json((Object)criteria);
        PageInfo pageInfo = (PageInfo)this.couponExtQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(100)).getData();
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return couponList;
        }
        couponList.addAll(pageInfo.getList());
        for (int i = 2; i <= pageInfo.getPages(); ++i) {
            PageInfo indexPageInfo = (PageInfo)this.couponExtQueryApi.queryByPage(filter, Integer.valueOf(i), Integer.valueOf(100)).getData();
            if (!CollectionUtils.isNotEmpty((Collection)indexPageInfo.getList())) continue;
            couponList.addAll(indexPageInfo.getList());
        }
        if (null != couponRange) {
            couponList = couponList.stream().filter(couponExtRespDto -> couponRange.equals(couponExtRespDto.getCouponRange())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(couponCategoryList)) {
            couponList = couponList.stream().filter(couponExtRespDto -> null != couponExtRespDto.getCouponTemplate() && couponCategoryList.contains(couponExtRespDto.getCouponTemplate().getCouponCategory())).collect(Collectors.toList());
        }
        return couponList;
    }

    @Override
    public CouponDetailRespDto getById(Long id) {
        CouponExtRespDto couponExtRespDto = (CouponExtRespDto)this.couponExtQueryApi.queryById(id).getData();
        if (null == couponExtRespDto) {
            return null;
        }
        CouponTemplateDetailRespDto template = this.couponTemplate.getDetail(couponExtRespDto.getCouponTemplateId());
        if (null == template) {
            return null;
        }
        CouponDetailRespDto couponDetailRespDto = new CouponDetailRespDto();
        CubeBeanUtils.copyProperties((Object)couponDetailRespDto, (Object)couponExtRespDto, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)template.getExchangeItems())) {
            ArrayList exchangeItems = Lists.newArrayList();
            template.getExchangeItems().forEach(exItem -> {
                List items = exItem.getSkus().stream().map(this::convert).collect(Collectors.toList());
                exchangeItems.addAll(items);
            });
            couponDetailRespDto.setExchangeItems((List)exchangeItems);
        }
        this.setCouponUseTimeDto((CouponRespDto)couponDetailRespDto, couponExtRespDto);
        return couponDetailRespDto;
    }

    private void setMatchCouponUseTimeDto(MatchCouponRespDto couponRespDto, CouponExtRespDto couponExtRespDto) {
        if (couponRespDto == null) {
            return;
        }
        if (couponExtRespDto == null) {
            return;
        }
        CouponUseTimeDto couponUseTimeDto = new CouponUseTimeDto();
        JSONObject value = new JSONObject();
        value.put("couponUseBeginTime", (Object)couponExtRespDto.getEffectiveTime());
        value.put("couponUseEndTime", (Object)couponExtRespDto.getInvalidTime());
        couponUseTimeDto.setValue((Object)value);
        if (couponExtRespDto.getValidityType() == CouponValidityTypeEnum.FOREVER_DATE.getType()) {
            couponUseTimeDto.setType(Integer.valueOf(3));
        } else {
            couponUseTimeDto.setType(Integer.valueOf(0));
        }
        couponRespDto.setCouponUseTimeDto(couponUseTimeDto);
    }

    private void setCouponUseTimeDto(CouponRespDto couponRespDto, CouponExtRespDto couponExtRespDto) {
        if (couponRespDto == null) {
            return;
        }
        if (couponExtRespDto == null) {
            return;
        }
        CouponUseTimeDto couponUseTimeDto = new CouponUseTimeDto();
        JSONObject value = new JSONObject();
        value.put("couponUseBeginTime", (Object)couponExtRespDto.getEffectiveTime());
        value.put("couponUseEndTime", (Object)couponExtRespDto.getInvalidTime());
        couponUseTimeDto.setValue((Object)value);
        if (couponExtRespDto.getValidityType() == CouponValidityTypeEnum.FOREVER_DATE.getType()) {
            couponUseTimeDto.setType(Integer.valueOf(3));
        } else {
            couponUseTimeDto.setType(Integer.valueOf(0));
        }
        couponRespDto.setCouponUseTimeDto(couponUseTimeDto);
    }

    private ExchangeItemRespDto convert(CouponItemSkuDto couponItemSkuDto) {
        ExchangeItemRespDto itemRespDto = new ExchangeItemRespDto();
        CubeBeanUtils.copyProperties((Object)itemRespDto, (Object)couponItemSkuDto, (String[])new String[0]);
        ItemDetailRespDto itemDetail = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(couponItemSkuDto.getItemId(), "attributes,sku,medias", null).getData();
        if (null == itemDetail) {
            return itemRespDto;
        }
        String path = ((ItemMediasRespDto)itemDetail.getItemMediasList().get(0)).getPath1();
        ItemSkuRespDto sku = itemDetail.getItemSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(couponItemSkuDto.getSkuId())).findAny().orElseGet(() -> null);
        itemRespDto.setImgPath(path);
        if (null != sku) {
            Map attrs = (Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class);
            itemRespDto.setAttrs(attrs);
        }
        itemRespDto.setItemName(itemDetail.getItem().getName());
        BigDecimal price = this.itemService.queryItemPrice(couponItemSkuDto.getShopId(), couponItemSkuDto.getItemId(), couponItemSkuDto.getSkuId());
        itemRespDto.setSellPrice(price);
        return itemRespDto;
    }
}

