/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.validate;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponUseTimeDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IValidateCouPonUseTimeParam;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.CollectionMethodEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.MarketingModuleExcpCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.validate.ValidateCouPonUseTimeParamDistribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CouponUseTimeByRange
implements IValidateCouPonUseTimeParam {
    private static final Integer TYPE = 0;
    public static final String START_TIME = "couponUseBeginTime";
    public static final String END_TIME = "couponUseEndTime";
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public CouponUseTimeByRange() {
        ValidateCouPonUseTimeParamDistribute.setValidateCouPonUseTimeParamMap(TYPE, this);
    }

    @Override
    public Integer getType() {
        return TYPE;
    }

    @Override
    public void validateParam(CouponTemplate couponTemplate) {
        CouponUseTimeDto couponUseTimeDto = couponTemplate.getCouponUseTimeReqDto();
        if (couponUseTimeDto == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_NOT_EXIST);
        }
        if (couponUseTimeDto.getType() == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED);
        }
        if (couponUseTimeDto.getValue() == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED);
        }
        String text = couponUseTimeDto.getValue().toString();
        JSONObject jsonObject = JSONObject.parseObject((String)text);
        String startTimeText = jsonObject.getString(START_TIME);
        String endTimeText = jsonObject.getString(END_TIME);
        if (StringUtils.isEmpty((CharSequence)startTimeText)) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED);
        }
        if (StringUtils.isEmpty((CharSequence)endTimeText)) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED);
        }
        try {
            Date startTime = this.simpleDateFormat.parse(startTimeText);
            Date endTime = this.simpleDateFormat.parse(endTimeText);
            if (endTime.getTime() - startTime.getTime() < 0L) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_ERROR);
            }
            if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplate.getCollectionMethod()) && startTime.before(couponTemplate.getReceiveStartTime())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.USE_TIME_GE_RECEIVE_START_TIME);
            }
        }
        catch (ParseException e) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED, (Throwable)e);
        }
    }
}

