/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityJoinLogService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityJoinLogDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityJoinLogEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityJoinLogEo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityJoinLogServiceImpl
implements IActivityJoinLogService {
    @Autowired
    private ActivityJoinLogDas activityJoinLogDas;

    @Override
    public long queryJoinTime(long activityId, long userId, long couponId, String itemId) {
        if (activityId < 1L || userId < 1L) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8\u6216\u8005\u7528\u6237ID\u975e\u6cd5"}));
        }
        Long time = this.activityJoinLogDas.queryJoinTime(activityId, userId, couponId, itemId);
        if (null == time) {
            time = 0L;
        }
        return time;
    }

    @Override
    public long insert(ActivityJoinLogEo tempEO) {
        return this.activityJoinLogDas.insert((BaseEo)tempEO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertBatch(List<ActivityJoinLogEo> tempEos) {
        this.activityJoinLogDas.insertBatch(tempEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void joinInActivity(EngineParams params) {
        LinkedList logs = Lists.newLinkedList();
        if (CollectionUtils.isEmpty((Collection)params.getItems())) {
            this.fillEo(params, null, 0L, logs);
        } else {
            boolean hasCoupon;
            ActivityCoupon activityCoupon = params.getCouponByActivityId(Long.valueOf(params.getActivityId()));
            List couponIds = null;
            if (activityCoupon != null) {
                couponIds = activityCoupon.getCouponIds();
            }
            boolean bl = hasCoupon = !CollectionUtils.isEmpty(couponIds) || params.getItems().stream().anyMatch(item -> item.getCouponId() > 0L);
            if (hasCoupon) {
                for (ItemVo itemVo : params.getItems()) {
                    if (itemVo.getPrice().equals(itemVo.getDiscountPrice()) || itemVo.getCouponId() <= 0L) continue;
                    this.fillEo(params, itemVo, itemVo.getCouponId(), logs);
                }
                if (!CollectionUtils.isEmpty((Collection)couponIds)) {
                    Iterator iterator = couponIds.iterator();
                    while (iterator.hasNext()) {
                        long couponId = (Long)iterator.next();
                        for (ItemVo itemVo : params.getItems()) {
                            if (!itemVo.getPrice().equals(itemVo.getDiscountPrice()) || couponId <= 0L) continue;
                            this.fillEo(params, itemVo, couponId, logs);
                        }
                    }
                }
            } else {
                for (ItemVo itemVo : params.getItems()) {
                    if (itemVo.getPrice().equals(itemVo.getDiscountPrice())) continue;
                    this.fillEo(params, itemVo, 0L, logs);
                }
            }
        }
        this.insertBatch(logs);
    }

    private void fillEo(EngineParams params, ItemVo itemVo, long couponId, List<ActivityJoinLogEo> logs) {
        if (itemVo.getDiscountTotalPrice() != null) {
            itemVo.setDiscountPrice(itemVo.getDiscountTotalPrice().divide(new BigDecimal(itemVo.getNum()), 4, 1));
        }
        ActivityJoinLogEo tempEO = ActivityJoinLogEo.newInstance();
        tempEO.setActivityId(Long.valueOf(params.getActivityId()));
        tempEO.setCouponId(Long.valueOf(couponId));
        tempEO.setItemId(itemVo.getItemId());
        tempEO.setItemNum(Integer.valueOf(itemVo.getNum()));
        tempEO.setProgramSrc(params.getProgramSrc());
        tempEO.setSerialNumber(params.getSerialNumber());
        tempEO.setSkuId(itemVo.getSkuId());
        tempEO.setStatus(EnableStatusEnum.DISABLE.getKey());
        tempEO.setUserId(Long.valueOf(params.getUserId()));
        tempEO.setOrderCode(params.getOrderCode());
        tempEO.setSourcePrice(itemVo.getPrice());
        tempEO.setTargetPrice(itemVo.getDiscountPrice());
        tempEO.setCreateTime(new Date());
        tempEO.setInstanceId(params.getInstanceId());
        tempEO.setTenantId(params.getTenantId());
        logs.add(tempEO);
    }

    @Override
    public void enable(String orderCode) {
        ActivityJoinLogEo eo = ActivityJoinLogEo.newInstance();
        eo.setStatus(EnableStatusEnum.ENABLE.getKey());
        eo.setSqlFilters(SqlFilterBuilder.newInstance().buildEqualsSqlFilter("order_code", orderCode).get());
        this.activityJoinLogDas.updateSelectiveSqlFilter((BaseEo)eo);
    }

    @Override
    public void disable(long userId, long activityId, List<Long> couponIds) {
        ActivityJoinLogEo eo = ActivityJoinLogEo.newInstance();
        if (this.fullSqlFilter(userId, activityId, couponIds, eo)) {
            return;
        }
        this.activityJoinLogDas.logicDeleteByExample((BaseEo)eo);
    }

    @Override
    public void enable(long userId, long activityId, List<Long> couponIds, String orderCode) {
        ActivityJoinLogEo eo = ActivityJoinLogEo.newInstance();
        eo.setStatus(EnableStatusEnum.ENABLE.getKey());
        eo.setOrderCode(orderCode);
        if (this.fullSqlFilter(userId, activityId, couponIds, eo)) {
            this.activityJoinLogDas.updateSelectiveSqlFilter((BaseEo)eo);
        }
    }

    private boolean fullSqlFilter(long userId, long activityId, List<Long> couponIds, ActivityJoinLogEo eo) {
        if (!CollectionUtils.isEmpty(couponIds)) {
            eo.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("coupon_id", couponIds).buildEqualsSqlFilter("user_id", userId).get());
        } else {
            if (activityId <= 0L) {
                return false;
            }
            eo.setSqlFilters(SqlFilterBuilder.newInstance().buildEqualsSqlFilter("activity_id", activityId).buildEqualsSqlFilter("user_id", userId).get());
        }
        return true;
    }

    @Override
    public int countJoinNumByOrderNo(Long userId, Long activityId) {
        ActivityJoinLogEo param = ActivityJoinLogEo.newInstance();
        param.setUserId(userId);
        param.setActivityId(activityId);
        param.setStatus(EnableStatusEnum.ENABLE.getKey());
        List joinLogs = this.activityJoinLogDas.select((BaseEo)param);
        if (CollectionUtils.isEmpty((Collection)joinLogs)) {
            return 0;
        }
        Map<String, List<ActivityJoinLogEo>> group = joinLogs.stream().collect(Collectors.groupingBy(StdActivityJoinLogEo::getOrderCode));
        return group.size();
    }
}

